/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.logicalLayer;

import java.util.ArrayList;
import java.util.List;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.ExpressionOperator;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LOCast;
import org.apache.pig.impl.logicalLayer.LOConst;
import org.apache.pig.impl.logicalLayer.LOForEach;
import org.apache.pig.impl.logicalLayer.LOProject;
import org.apache.pig.impl.logicalLayer.LOUnion;
import org.apache.pig.impl.logicalLayer.LOVisitor;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.logicalLayer.validators.LogicalPlanValidationExecutor;
import org.apache.pig.impl.logicalLayer.validators.UnionOnSchemaSetException;
import org.apache.pig.impl.plan.CompilationMessageCollector;
import org.apache.pig.impl.plan.DependencyOrderWalker;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanValidationException;
import org.apache.pig.impl.plan.PlanWalker;

public class UnionOnSchemaSetter
extends LOVisitor {
    private PigContext pigContext;

    public UnionOnSchemaSetter(LogicalPlan plan, PigContext pigContext) {
        super(plan, (PlanWalker<LogicalOperator, LogicalPlan>)new DependencyOrderWalker<LogicalOperator, LogicalPlan>(plan));
        this.pigContext = pigContext;
    }

    public void visit(LOUnion loUnion) throws PlanValidationException, UnionOnSchemaSetException {
        Schema mergedSchema;
        if (!loUnion.isOnSchema()) {
            return;
        }
        CompilationMessageCollector collector = new CompilationMessageCollector();
        boolean isBeforeOptimizer = true;
        LogicalPlanValidationExecutor validator = new LogicalPlanValidationExecutor((LogicalPlan)this.mPlan, this.pigContext, isBeforeOptimizer);
        validator.validate((LogicalPlan)this.mPlan, collector);
        List<LOUnion> preds = ((LogicalPlan)this.mPlan).getPredecessors(loUnion);
        try {
            mergedSchema = loUnion.getSchema();
        }
        catch (FrontendException e) {
            String msg = "Error creating merged schemas for union-onschema operator : " + e.getMessage();
            throw new UnionOnSchemaSetException(msg, 1116, 2, e);
        }
        ArrayList<Schema> mergedSchemaList = new ArrayList<Schema>();
        for (Schema.FieldSchema fieldSchema : mergedSchema.getFields()) {
            mergedSchemaList.add(new Schema(new Schema.FieldSchema(fieldSchema.alias, 1)));
        }
        for (LogicalOperator logicalOperator : preds) {
            try {
                if (logicalOperator.getSchema().equals(mergedSchema)) continue;
                int mergeSchSz = mergedSchema.size();
                ArrayList<LogicalPlan> generatePlans = new ArrayList<LogicalPlan>(mergeSchSz);
                ArrayList<Boolean> flattenList = new ArrayList<Boolean>(mergeSchSz);
                String scope = loUnion.getOperatorKey().getScope();
                for (Schema.FieldSchema fs : mergedSchema.getFields()) {
                    LogicalPlan projectPlan = new LogicalPlan();
                    Schema inpSchema = logicalOperator.getSchema();
                    flattenList.add(Boolean.FALSE);
                    int inpPos = inpSchema.getPositionSubName(fs.alias);
                    ExpressionOperator columnProj = null;
                    boolean isCastNeeded = false;
                    if (inpPos == -1) {
                        columnProj = new LOConst((LogicalPlan)this.mPlan, this.getNextId(scope), null);
                        if (fs.type != 50) {
                            isCastNeeded = true;
                        }
                    } else {
                        columnProj = new LOProject(projectPlan, new OperatorKey(scope, NodeIdGenerator.getGenerator().getNextNodeId(scope)), logicalOperator, inpPos);
                        Schema.FieldSchema inpFs = inpSchema.getFieldSubNameMatch(fs.alias);
                        if (inpFs.type != fs.type) {
                            isCastNeeded = true;
                        }
                    }
                    projectPlan.add(columnProj);
                    if (isCastNeeded) {
                        LOCast loCast = new LOCast(projectPlan, this.getNextId(scope), fs.type);
                        loCast.setFieldSchema(fs);
                        projectPlan.add(loCast);
                        projectPlan.connect(columnProj, loCast);
                    }
                    generatePlans.add(projectPlan);
                }
                LOForEach foreach = new LOForEach((LogicalPlan)this.mPlan, this.getNextId(scope), generatePlans, flattenList, mergedSchemaList);
                ((LogicalPlan)this.mPlan).add(foreach);
                ((LogicalPlan)this.mPlan).insertBetween(logicalOperator, foreach, loUnion);
            }
            catch (FrontendException e) {
                String msg = "Error adding union operator " + loUnion.getAlias() + ":" + e.getMessage();
                UnionOnSchemaSetException pe = new UnionOnSchemaSetException(msg);
                pe.initCause(e);
                throw pe;
            }
        }
    }

    private OperatorKey getNextId(String scope) {
        return new OperatorKey(scope, NodeIdGenerator.getGenerator().getNextNodeId(scope));
    }
}

