/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.relational;

import java.util.ArrayList;
import java.util.List;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.PlanVisitor;
import org.apache.pig.newplan.logical.expression.ProjectExpression;
import org.apache.pig.newplan.logical.relational.LOInnerLoad;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalNodesVisitor;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LOForEach
extends LogicalRelationalOperator {
    private static final long serialVersionUID = 2L;
    private LogicalPlan innerPlan;

    public LOForEach(OperatorPlan plan) {
        super("LOForEach", plan);
    }

    public LogicalPlan getInnerPlan() {
        return this.innerPlan;
    }

    public void setInnerPlan(LogicalPlan p) {
        this.innerPlan = p;
    }

    @Override
    public boolean isEqual(Operator other) throws FrontendException {
        if (!(other instanceof LOForEach)) {
            return false;
        }
        return this.innerPlan.isEqual(((LOForEach)other).innerPlan);
    }

    @Override
    public LogicalSchema getSchema() throws FrontendException {
        List<Operator> ll = this.innerPlan.getSinks();
        if (ll != null) {
            this.schema = ((LogicalRelationalOperator)ll.get(0)).getSchema();
        }
        return this.schema;
    }

    @Override
    public void accept(PlanVisitor v) throws FrontendException {
        if (!(v instanceof LogicalRelationalNodesVisitor)) {
            throw new FrontendException("Expected LogicalPlanVisitor", 2222);
        }
        ((LogicalRelationalNodesVisitor)v).visit(this);
    }

    public static List<LOInnerLoad> findReacheableInnerLoadFromBoundaryProject(ProjectExpression project) throws FrontendException {
        LogicalRelationalOperator referred = project.findReferent();
        List<Operator> srcs = referred.getPlan().getSources();
        ArrayList<LOInnerLoad> innerLoads = new ArrayList<LOInnerLoad>();
        block0: for (Operator src : srcs) {
            if (!(src instanceof LOInnerLoad)) continue;
            Operator succ = src;
            while (succ != null) {
                if (succ == referred) {
                    innerLoads.add((LOInnerLoad)src);
                }
                if (referred.getPlan().getSuccessors(succ) == null) continue block0;
                succ = referred.getPlan().getSuccessors(succ).get(0);
            }
        }
        return innerLoads;
    }
}

