/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.mapr401.authentication;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Properties;
import org.apache.commons.lang.ClassUtils;
import org.apache.log4j.Logger;
import org.pentaho.di.core.auth.core.AuthenticationManager;
import org.pentaho.di.core.auth.core.AuthenticationProvider;
import org.pentaho.di.core.encryption.Encr;

public class PropertyAuthenticationProviderParser {
    private static final Logger logger = Logger.getLogger(PropertyAuthenticationProviderParser.class);
    private final Properties properties;
    private final AuthenticationManager manager;
    private final AuthenticationProviderInstantiator authenticationProviderInstantiator;

    public PropertyAuthenticationProviderParser(Properties properties, AuthenticationManager manager) {
        this(properties, manager, new AuthenticationProviderInstantiator(){

            @Override
            public AuthenticationProvider instantiate(String canonicalName) {
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(canonicalName);
                }
                catch (ClassNotFoundException e) {
                    logger.warn((Object)("Cannot locate class " + canonicalName + ", provider will not be processed."), (Throwable)e);
                }
                if (clazz != null) {
                    try {
                        return (AuthenticationProvider)clazz.newInstance();
                    }
                    catch (Exception e) {
                        logger.warn((Object)("Cannot instantiate class " + canonicalName + ", provider will not be processed."), (Throwable)e);
                    }
                }
                return null;
            }
        });
    }

    public PropertyAuthenticationProviderParser(Properties properties, AuthenticationManager manager, AuthenticationProviderInstantiator authenticationProviderInstantiator) {
        this.properties = properties;
        this.manager = manager;
        this.authenticationProviderInstantiator = authenticationProviderInstantiator;
    }

    public void process(String providerListProperty) {
        if (this.properties.containsKey(providerListProperty)) {
            for (String prefix : this.properties.getProperty(providerListProperty).split(",")) {
                if ((prefix = prefix.trim()).length() <= 0) continue;
                this.processPrefix(prefix);
            }
        }
    }

    private void processPrefix(String prefix) {
        AuthenticationProvider provider = this.authenticationProviderInstantiator.instantiate(this.properties.getProperty(prefix + ".class"));
        if (provider != null) {
            for (Method method : provider.getClass().getMethods()) {
                if (!method.getName().startsWith("set") || method.getName().length() < 4 || method.getParameterTypes().length != 1) continue;
                String propName = prefix + "." + method.getName().substring(3, 4).toLowerCase();
                if (method.getName().length() > 4) {
                    propName = propName + method.getName().substring(4);
                }
                if (!this.properties.containsKey(propName)) continue;
                String strValue = Encr.decryptPasswordOptionallyEncrypted((String)this.properties.getProperty(propName));
                Object actualValue = null;
                Class argType = method.getParameterTypes()[0];
                if (argType.isPrimitive()) {
                    argType = ClassUtils.primitiveToWrapper(argType);
                }
                if (argType == String.class) {
                    actualValue = strValue;
                } else {
                    Method valueOf = null;
                    try {
                        valueOf = argType.getMethod("valueOf", String.class);
                    }
                    catch (NoSuchMethodException e1) {
                        logger.warn((Object)("Unable to find valueOf method on " + argType.getClass().getCanonicalName()));
                    }
                    if (valueOf != null && Modifier.isStatic(valueOf.getModifiers())) {
                        try {
                            actualValue = valueOf.invoke(null, strValue);
                        }
                        catch (Exception e) {
                            logger.warn((Object)("Unable to convert string property " + propName + "(" + strValue + ") to " + argType.getClass().getCanonicalName() + " to invoke setter " + method.getName()), (Throwable)e);
                        }
                    } else {
                        logger.warn((Object)("Could not find method to convert " + propName + "(" + strValue + ") to " + argType.getClass().getCanonicalName() + " (currently only primitives and their wrappers are supported)"));
                    }
                }
                if (actualValue == null) continue;
                try {
                    method.invoke((Object)provider, strValue);
                }
                catch (Exception e) {
                    Throwable cause = e;
                    if (e instanceof InvocationTargetException) {
                        cause = e.getCause();
                    }
                    logger.warn((Object)("Error invoking setter " + method.toString() + " with property " + propName + "(" + strValue + ")"), cause);
                }
            }
            this.manager.registerAuthenticationProvider(provider);
        }
    }

    public static interface AuthenticationProviderInstantiator {
        public AuthenticationProvider instantiate(String var1);
    }
}

