/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.extensions.pentaho.repository.actions;

import java.io.IOException;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.VFS;
import org.pentaho.reporting.designer.core.auth.AuthenticationData;
import org.pentaho.reporting.designer.extensions.pentaho.repository.actions.LoginTask;
import org.pentaho.reporting.designer.extensions.pentaho.repository.util.PublishUtil;
import org.pentaho.reporting.libraries.pensol.vfs.WebSolutionFileSystem;

public class ValidateLoginTask
implements Runnable {
    private AuthenticationData loginData;
    private Exception exception;
    private boolean loginComplete;

    public ValidateLoginTask(LoginTask loginTask) {
        this.loginData = loginTask.getLoginData();
    }

    @Override
    public void run() {
        this.loginComplete = false;
        try {
            this.loginComplete = this.validateLoginData();
        }
        catch (FileSystemException exception) {
            this.loginComplete = false;
            this.exception = exception;
        }
    }

    public Exception getException() {
        return this.exception;
    }

    public boolean isLoginComplete() {
        return this.loginComplete;
    }

    public boolean validateLoginData() throws FileSystemException {
        if (this.loginData == null) {
            return true;
        }
        FileObject vfsConnection = PublishUtil.createVFSConnection(VFS.getManager(), this.loginData);
        try {
            FileSystem fileSystem = vfsConnection.getFileSystem();
            if (fileSystem instanceof WebSolutionFileSystem) {
                WebSolutionFileSystem webSolutionFileSystem = (WebSolutionFileSystem)fileSystem;
                Long l = (Long)webSolutionFileSystem.getAttribute("lastRefreshTime");
                if (l != null && System.currentTimeMillis() - l > 500L) {
                    webSolutionFileSystem.getLocalFileModel().refresh();
                }
                return true;
            }
        }
        catch (FileSystemException fse) {
        }
        catch (IOException e) {
            return false;
        }
        FileType type = vfsConnection.getType();
        return type == FileType.FOLDER;
    }
}

