/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.avroinput;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.util.Utf8;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.avroinput.AvroInput;
import org.pentaho.di.trans.steps.avroinput.AvroInputData;
import org.w3c.dom.Node;

@Step(id="AvroInput", image="Avro.png", name="AvroInput.Name", description="AvroInput.Description", categoryDescription="i18n:org.pentaho.di.trans.step:BaseStep.Category.BigData", i18nPackageName="org.pentaho.di.trans.steps.avroinput")
public class AvroInputMeta
extends BaseStepMeta
implements StepMetaInterface {
    protected static Class<?> PKG = AvroInputMeta.class;
    protected String m_filename = "";
    protected String m_schemaFilename = "";
    protected boolean m_isJsonEncoded = false;
    protected boolean m_avroInField = false;
    protected String m_avroFieldName = "";
    protected boolean m_schemaInField;
    protected String m_schemaFieldName;
    protected boolean m_schemaInFieldIsPath;
    protected boolean m_cacheSchemasInMemory;
    protected boolean m_dontComplainAboutMissingFields;
    protected List<AvroField> m_fields;
    protected List<LookupField> m_lookups;

    public void setAvroInField(boolean a) {
        this.m_avroInField = a;
    }

    public boolean getAvroInField() {
        return this.m_avroInField;
    }

    public void setAvroFieldName(String f) {
        this.m_avroFieldName = f;
    }

    public String getAvroFieldName() {
        return this.m_avroFieldName;
    }

    public void setSchemaInField(boolean s) {
        this.m_schemaInField = s;
    }

    public boolean getSchemaInField() {
        return this.m_schemaInField;
    }

    public void setSchemaFieldName(String fn) {
        this.m_schemaFieldName = fn;
    }

    public String getSchemaFieldName() {
        return this.m_schemaFieldName;
    }

    public void setSchemaInFieldIsPath(boolean p) {
        this.m_schemaInFieldIsPath = p;
    }

    public boolean getSchemaInFieldIsPath() {
        return this.m_schemaInFieldIsPath;
    }

    public void setCacheSchemasInMemory(boolean c) {
        this.m_cacheSchemasInMemory = c;
    }

    public boolean getCacheSchemasInMemory() {
        return this.m_cacheSchemasInMemory;
    }

    public void setFilename(String filename) {
        this.m_filename = filename;
    }

    public String getFilename() {
        return this.m_filename;
    }

    public void setSchemaFilename(String schemaFile) {
        this.m_schemaFilename = schemaFile;
    }

    public String getSchemaFilename() {
        return this.m_schemaFilename;
    }

    public boolean getAvroIsJsonEncoded() {
        return this.m_isJsonEncoded;
    }

    public void setAvroIsJsonEncoded(boolean j) {
        this.m_isJsonEncoded = j;
    }

    public void setAvroFields(List<AvroField> fields) {
        this.m_fields = fields;
    }

    public List<AvroField> getAvroFields() {
        return this.m_fields;
    }

    public List<LookupField> getLookupFields() {
        return this.m_lookups;
    }

    public void setLookupFields(List<LookupField> lookups) {
        this.m_lookups = lookups;
    }

    public void setDontComplainAboutMissingFields(boolean c) {
        this.m_dontComplainAboutMissingFields = c;
    }

    public boolean getDontComplainAboutMissingFields() {
        return this.m_dontComplainAboutMissingFields;
    }

    public void getFields(RowMetaInterface rowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        List<AvroField> fieldsToOutput = null;
        if (this.m_fields != null && this.m_fields.size() > 0) {
            fieldsToOutput = this.m_fields;
        } else {
            Schema s;
            if (!Const.isEmpty((String)this.getSchemaFilename())) {
                String fn = space.environmentSubstitute(this.m_schemaFilename);
                try {
                    s = AvroInputData.loadSchema(fn);
                    fieldsToOutput = AvroInputData.getLeafFields(s);
                }
                catch (KettleException e) {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"AvroInput.Error.UnableToLoadSchema", (String[])new String[]{fn}), (Throwable)e);
                }
            }
            if (this.m_avroInField) {
                throw new KettleStepException(BaseMessages.getString(PKG, (String)"AvroInput.Error.NoSchemaSupplied", (String[])new String[0]));
            }
            String avroFilename = this.m_filename;
            avroFilename = space.environmentSubstitute(avroFilename);
            try {
                s = AvroInputData.loadSchemaFromContainer(avroFilename);
                fieldsToOutput = AvroInputData.getLeafFields(s);
            }
            catch (KettleException e) {
                throw new KettleStepException(BaseMessages.getString(PKG, (String)"AvroInput.Error.UnableToLoadSchemaFromContainerFile", (String[])new String[]{avroFilename}));
            }
        }
        for (AvroField f : fieldsToOutput) {
            ValueMeta vm = new ValueMeta();
            vm.setName(f.m_fieldName);
            vm.setOrigin(origin);
            vm.setType(ValueMeta.getType((String)f.m_kettleType));
            if (f.m_indexedVals != null) {
                vm.setIndex(f.m_indexedVals.toArray());
            }
            rowMeta.addValueMeta((ValueMetaInterface)vm);
        }
    }

    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        return new AvroInput(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public StepDataInterface getStepData() {
        return new AvroInputData();
    }

    protected static String indexedValsList(List<String> indexedVals) {
        StringBuffer temp = new StringBuffer();
        for (int i = 0; i < indexedVals.size(); ++i) {
            temp.append(indexedVals.get(i));
            if (i >= indexedVals.size() - 1) continue;
            temp.append(",");
        }
        return temp.toString();
    }

    protected static List<String> indexedValsList(String indexedVals) {
        String[] parts = indexedVals.split(",");
        ArrayList<String> list = new ArrayList<String>();
        for (String s : parts) {
            list.add(s.trim());
        }
        return list;
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer();
        if (!Const.isEmpty((String)this.m_filename)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"avro_filename", (String)this.m_filename));
        }
        if (!Const.isEmpty((String)this.m_schemaFilename)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"schema_filename", (String)this.m_schemaFilename));
        }
        retval.append("\n    ").append(XMLHandler.addTagValue((String)"json_encoded", (boolean)this.m_isJsonEncoded));
        retval.append("\n    ").append(XMLHandler.addTagValue((String)"avro_in_field", (boolean)this.m_avroInField));
        if (!Const.isEmpty((String)this.m_avroFieldName)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"avro_field_name", (String)this.m_avroFieldName));
        }
        retval.append("\n    ").append(XMLHandler.addTagValue((String)"schema_in_field", (boolean)this.m_schemaInField));
        if (!Const.isEmpty((String)this.m_schemaFieldName)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"schema_field_name", (String)this.m_schemaFieldName));
        }
        retval.append("\n    ").append(XMLHandler.addTagValue((String)"schema_in_field_is_path", (boolean)this.m_schemaInFieldIsPath));
        retval.append("\n    ").append(XMLHandler.addTagValue((String)"cache_schemas", (boolean)this.m_cacheSchemasInMemory));
        retval.append("\n    ").append(XMLHandler.addTagValue((String)"ignore_missing_fields", (boolean)this.m_dontComplainAboutMissingFields));
        if (this.m_fields != null && this.m_fields.size() > 0) {
            retval.append("\n    ").append(XMLHandler.openTag((String)"avro_fields"));
            for (AvroField avroField : this.m_fields) {
                retval.append("\n      ").append(XMLHandler.openTag((String)"avro_field"));
                retval.append("\n        ").append(XMLHandler.addTagValue((String)"field_name", (String)avroField.m_fieldName));
                retval.append("\n        ").append(XMLHandler.addTagValue((String)"field_path", (String)avroField.m_fieldPath));
                retval.append("\n        ").append(XMLHandler.addTagValue((String)"field_type", (String)avroField.m_kettleType));
                if (avroField.m_indexedVals != null && avroField.m_indexedVals.size() > 0) {
                    retval.append("\n        ").append(XMLHandler.addTagValue((String)"indexed_vals", (String)AvroInputMeta.indexedValsList(avroField.m_indexedVals)));
                }
                retval.append("\n      ").append(XMLHandler.closeTag((String)"avro_field"));
            }
            retval.append("\n    ").append(XMLHandler.closeTag((String)"avro_fields"));
        }
        if (this.m_lookups != null && this.m_lookups.size() > 0) {
            retval.append("\n    ").append(XMLHandler.openTag((String)"lookup_fields"));
            for (LookupField lookupField : this.m_lookups) {
                retval.append("\n      ").append(XMLHandler.openTag((String)"lookup_field"));
                retval.append("\n        ").append(XMLHandler.addTagValue((String)"lookup_field_name", (String)lookupField.m_fieldName));
                retval.append("\n        ").append(XMLHandler.addTagValue((String)"variable_name", (String)lookupField.m_variableName));
                retval.append("\n        ").append(XMLHandler.addTagValue((String)"default_value", (String)lookupField.m_defaultValue));
                retval.append("\n      ").append(XMLHandler.closeTag((String)"lookup_field"));
            }
            retval.append("\n    ").append(XMLHandler.closeTag((String)"lookup_fields"));
        }
        return retval.toString();
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        Node lFields;
        Node fields;
        String ignoreMissing;
        String cacheSchemas;
        String avroInField;
        this.m_filename = XMLHandler.getTagValue((Node)stepnode, (String)"avro_filename");
        this.m_schemaFilename = XMLHandler.getTagValue((Node)stepnode, (String)"schema_filename");
        String jsonEnc = XMLHandler.getTagValue((Node)stepnode, (String)"json_encoded");
        if (!Const.isEmpty((String)jsonEnc)) {
            this.m_isJsonEncoded = jsonEnc.equalsIgnoreCase("Y");
        }
        if (!Const.isEmpty((String)(avroInField = XMLHandler.getTagValue((Node)stepnode, (String)"avro_in_field")))) {
            this.m_avroInField = avroInField.equalsIgnoreCase("Y");
        }
        this.m_avroFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"avro_field_name");
        String schemaInField = XMLHandler.getTagValue((Node)stepnode, (String)"schema_in_field");
        if (!Const.isEmpty((String)schemaInField)) {
            this.m_schemaInField = schemaInField.equalsIgnoreCase("Y");
        }
        this.m_schemaFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"schema_field_name");
        String schemaInFieldIsPath = XMLHandler.getTagValue((Node)stepnode, (String)"schema_in_field_is_path");
        if (!Const.isEmpty((String)schemaInFieldIsPath)) {
            this.m_schemaInFieldIsPath = schemaInFieldIsPath.equalsIgnoreCase("Y");
        }
        if (!Const.isEmpty((String)(cacheSchemas = XMLHandler.getTagValue((Node)stepnode, (String)"cache_schemas")))) {
            this.m_cacheSchemasInMemory = cacheSchemas.equalsIgnoreCase("Y");
        }
        if (!Const.isEmpty((String)(ignoreMissing = XMLHandler.getTagValue((Node)stepnode, (String)"ignore_missing_fields")))) {
            this.m_dontComplainAboutMissingFields = ignoreMissing.equalsIgnoreCase("Y");
        }
        if ((fields = XMLHandler.getSubNode((Node)stepnode, (String)"avro_fields")) != null && XMLHandler.countNodes((Node)fields, (String)"avro_field") > 0) {
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"avro_field");
            this.m_fields = new ArrayList<AvroField>();
            for (int i = 0; i < nrfields; ++i) {
                Node fieldNode = XMLHandler.getSubNodeByNr((Node)fields, (String)"avro_field", (int)i);
                AvroField newField = new AvroField();
                newField.m_fieldName = XMLHandler.getTagValue((Node)fieldNode, (String)"field_name");
                newField.m_fieldPath = XMLHandler.getTagValue((Node)fieldNode, (String)"field_path");
                newField.m_kettleType = XMLHandler.getTagValue((Node)fieldNode, (String)"field_type");
                String indexedVals = XMLHandler.getTagValue((Node)fieldNode, (String)"indexed_vals");
                if (indexedVals != null && indexedVals.length() > 0) {
                    newField.m_indexedVals = AvroInputMeta.indexedValsList(indexedVals);
                }
                this.m_fields.add(newField);
            }
        }
        if ((lFields = XMLHandler.getSubNode((Node)stepnode, (String)"lookup_fields")) != null && XMLHandler.countNodes((Node)lFields, (String)"lookup_field") > 0) {
            int nrfields = XMLHandler.countNodes((Node)lFields, (String)"lookup_field");
            this.m_lookups = new ArrayList<LookupField>();
            for (int i = 0; i < nrfields; ++i) {
                Node fieldNode = XMLHandler.getSubNodeByNr((Node)lFields, (String)"lookup_field", (int)i);
                LookupField newField = new LookupField();
                newField.m_fieldName = XMLHandler.getTagValue((Node)fieldNode, (String)"lookup_field_name");
                newField.m_variableName = XMLHandler.getTagValue((Node)fieldNode, (String)"variable_name");
                newField.m_defaultValue = XMLHandler.getTagValue((Node)fieldNode, (String)"default_value");
                this.m_lookups.add(newField);
            }
        }
    }

    public void readRep(Repository rep, ObjectId id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        Object newField;
        int i;
        this.m_filename = rep.getStepAttributeString(id_step, 0, "avro_filename");
        this.m_schemaFilename = rep.getStepAttributeString(id_step, 0, "schema_filename");
        this.m_isJsonEncoded = rep.getStepAttributeBoolean(id_step, 0, "json_encoded");
        this.m_avroInField = rep.getStepAttributeBoolean(id_step, 0, "avro_in_field");
        this.m_avroFieldName = rep.getStepAttributeString(id_step, 0, "avro_field_name");
        this.m_schemaInField = rep.getStepAttributeBoolean(id_step, 0, "schema_in_field");
        this.m_schemaFieldName = rep.getStepAttributeString(id_step, 0, "schema_field_name");
        this.m_schemaInFieldIsPath = rep.getStepAttributeBoolean(id_step, 0, "schema_in_field_is_path");
        this.m_cacheSchemasInMemory = rep.getStepAttributeBoolean(id_step, 0, "cache_schemas");
        this.m_dontComplainAboutMissingFields = rep.getStepAttributeBoolean(id_step, 0, "ignore_missing_fields");
        int nrfields = rep.countNrStepAttributes(id_step, "field_name");
        if (nrfields > 0) {
            this.m_fields = new ArrayList<AvroField>();
            for (i = 0; i < nrfields; ++i) {
                newField = new AvroField();
                ((AvroField)newField).m_fieldName = rep.getStepAttributeString(id_step, i, "field_name");
                ((AvroField)newField).m_fieldPath = rep.getStepAttributeString(id_step, i, "field_path");
                ((AvroField)newField).m_kettleType = rep.getStepAttributeString(id_step, i, "field_type");
                String indexedVals = rep.getStepAttributeString(id_step, i, "indexed_vals");
                if (indexedVals != null && indexedVals.length() > 0) {
                    ((AvroField)newField).m_indexedVals = AvroInputMeta.indexedValsList(indexedVals);
                }
                this.m_fields.add((AvroField)newField);
            }
        }
        if ((nrfields = rep.countNrStepAttributes(id_step, "lookup_field_name")) > 0) {
            this.m_lookups = new ArrayList<LookupField>();
            for (i = 0; i < nrfields; ++i) {
                newField = new LookupField();
                ((LookupField)newField).m_fieldName = rep.getStepAttributeString(id_step, i, "lookup_field_name");
                ((LookupField)newField).m_variableName = rep.getStepAttributeString(id_step, i, "variable_name");
                ((LookupField)newField).m_defaultValue = rep.getStepAttributeString(id_step, i, "default_value");
                this.m_lookups.add((LookupField)newField);
            }
        }
    }

    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        Object f;
        int i;
        if (!Const.isEmpty((String)this.m_filename)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "avro_filename", this.m_filename);
        }
        if (!Const.isEmpty((String)this.m_schemaFilename)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "schema_filename", this.m_schemaFilename);
        }
        rep.saveStepAttribute(id_transformation, id_step, 0, "json_encoded", this.m_isJsonEncoded);
        rep.saveStepAttribute(id_transformation, id_step, 0, "avro_in_field", this.m_avroInField);
        if (!Const.isEmpty((String)this.m_avroFieldName)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "avro_field_name", this.m_avroFieldName);
        }
        rep.saveStepAttribute(id_transformation, id_step, 0, "schema_in_field", this.m_schemaInField);
        if (!Const.isEmpty((String)this.m_schemaFieldName)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "schema_field_name", this.m_schemaFieldName);
        }
        rep.saveStepAttribute(id_transformation, id_step, 0, "schema_in_field_is_path", this.m_schemaInFieldIsPath);
        rep.saveStepAttribute(id_transformation, id_step, 0, "cache_schemas", this.m_cacheSchemasInMemory);
        rep.saveStepAttribute(id_transformation, id_step, 0, "ignore_missing_fields", this.m_dontComplainAboutMissingFields);
        if (this.m_fields != null && this.m_fields.size() > 0) {
            for (i = 0; i < this.m_fields.size(); ++i) {
                f = this.m_fields.get(i);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", ((AvroField)f).m_fieldName);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_path", ((AvroField)f).m_fieldPath);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_type", ((AvroField)f).m_kettleType);
                if (((AvroField)f).m_indexedVals == null || ((AvroField)f).m_indexedVals.size() <= 0) continue;
                String indexedVals = AvroInputMeta.indexedValsList(((AvroField)f).m_indexedVals);
                rep.saveStepAttribute(id_transformation, id_step, i, "indexed_vals", indexedVals);
            }
        }
        if (this.m_lookups != null && this.m_lookups.size() > 0) {
            for (i = 0; i < this.m_lookups.size(); ++i) {
                f = this.m_lookups.get(i);
                rep.saveStepAttribute(id_transformation, id_step, i, "lookup_field_name", ((LookupField)f).m_fieldName);
                rep.saveStepAttribute(id_transformation, id_step, i, "variable_name", ((LookupField)f).m_variableName);
                rep.saveStepAttribute(id_transformation, id_step, i, "default_value", ((LookupField)f).m_defaultValue);
            }
        }
    }

    public void setDefault() {
    }

    public String getDialogClassName() {
        return "org.pentaho.di.trans.steps.avroinput.AvroInputDialog";
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public static class AvroField {
        public String m_fieldName = "";
        public String m_fieldPath = "";
        public String m_kettleType = "";
        public List<String> m_indexedVals;
        protected int m_outputIndex;
        private ValueMeta m_tempValueMeta;
        private List<String> m_pathParts;
        private List<String> m_tempParts;

        public void init(int outputIndex) throws KettleException {
            if (Const.isEmpty((String)this.m_fieldPath)) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.NoPathSet", (String[])new String[0]));
            }
            if (this.m_pathParts != null) {
                return;
            }
            String fieldPath = AvroInputData.cleansePath(this.m_fieldPath);
            String[] temp = fieldPath.split("\\.");
            this.m_pathParts = new ArrayList<String>();
            for (String part : temp) {
                this.m_pathParts.add(part);
            }
            if (this.m_pathParts.get(0).equals("$")) {
                this.m_pathParts.remove(0);
            } else if (this.m_pathParts.get(0).startsWith("$[")) {
                String r = this.m_pathParts.get(0).substring(1, this.m_pathParts.get(0).length());
                this.m_pathParts.set(0, r);
            }
            this.m_tempParts = new ArrayList<String>();
            this.m_tempValueMeta = new ValueMeta();
            this.m_tempValueMeta.setType(ValueMeta.getType((String)this.m_kettleType));
            this.m_outputIndex = outputIndex;
        }

        public void reset(VariableSpace space) {
            this.m_tempParts.clear();
            for (String part : this.m_pathParts) {
                this.m_tempParts.add(space.environmentSubstitute(part));
            }
        }

        protected Object getKettleValue(Object fieldValue) throws KettleException {
            switch (this.m_tempValueMeta.getType()) {
                case 6: {
                    return this.m_tempValueMeta.getBigNumber(fieldValue);
                }
                case 8: {
                    return this.m_tempValueMeta.getBinary(fieldValue);
                }
                case 4: {
                    return this.m_tempValueMeta.getBoolean(fieldValue);
                }
                case 3: {
                    return this.m_tempValueMeta.getDate(fieldValue);
                }
                case 5: {
                    return this.m_tempValueMeta.getInteger(fieldValue);
                }
                case 1: {
                    return this.m_tempValueMeta.getNumber(fieldValue);
                }
                case 2: {
                    return this.m_tempValueMeta.getString(fieldValue);
                }
            }
            return null;
        }

        protected Object getPrimitive(Object fieldValue, Schema s) throws KettleException {
            if (fieldValue == null) {
                return null;
            }
            switch (s.getType()) {
                case BOOLEAN: 
                case LONG: 
                case DOUBLE: 
                case BYTES: 
                case ENUM: 
                case STRING: {
                    return this.getKettleValue(fieldValue);
                }
                case INT: {
                    return this.getKettleValue(new Long(((Integer)fieldValue).intValue()));
                }
                case FLOAT: {
                    return this.getKettleValue(new Double(((Float)fieldValue).floatValue()));
                }
                case FIXED: {
                    return ((GenericFixed)fieldValue).bytes();
                }
            }
            return null;
        }

        public Object convertToKettleValue(Map<Utf8, Object> map, Schema s, boolean ignoreMissing) throws KettleException {
            Object value;
            if (map == null) {
                return null;
            }
            if (this.m_tempParts.size() == 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.MalformedPathMap", (String[])new String[0]));
            }
            String part = this.m_tempParts.remove(0);
            if (part.charAt(0) != '[') {
                throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.MalformedPathMap2", (String[])new String[]{part}));
            }
            String key = part.substring(1, part.indexOf(93));
            if (part.indexOf(93) < part.length() - 1) {
                part = part.substring(part.indexOf(93) + 1, part.length());
                this.m_tempParts.add(0, part);
            }
            if ((value = map.get(new Utf8(key))) == null) {
                return null;
            }
            Schema valueType = s.getValueType();
            if (valueType.getType() == Schema.Type.UNION) {
                if (value instanceof GenericContainer) {
                    valueType = ((GenericContainer)value).getSchema();
                } else if (value instanceof Map) {
                    Schema mapSchema = null;
                    for (Schema ts : valueType.getTypes()) {
                        if (ts.getType() != Schema.Type.MAP) continue;
                        mapSchema = ts;
                        break;
                    }
                    if (mapSchema == null) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.UnableToFindSchemaForUnionMap", (String[])new String[0]));
                    }
                    valueType = mapSchema;
                } else {
                    valueType = this.m_tempValueMeta.getType() != 2 ? AvroInputData.checkUnion(valueType) : Schema.create((Schema.Type)Schema.Type.STRING);
                }
            }
            if (valueType.getType() == Schema.Type.RECORD) {
                return this.convertToKettleValue((GenericData.Record)value, valueType, ignoreMissing);
            }
            if (valueType.getType() == Schema.Type.ARRAY) {
                return this.convertToKettleValue((GenericData.Array)value, valueType, ignoreMissing);
            }
            if (valueType.getType() == Schema.Type.MAP) {
                return this.convertToKettleValue((Map)value, valueType, ignoreMissing);
            }
            return this.getPrimitive(value, valueType);
        }

        public Object convertToKettleValue(GenericData.Array array, Schema s, boolean ignoreMissing) throws KettleException {
            if (array == null) {
                return null;
            }
            if (this.m_tempParts.size() == 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.MalformedPathArray", (String[])new String[0]));
            }
            String part = this.m_tempParts.remove(0);
            if (part.charAt(0) != '[') {
                throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.MalformedPathArray2", (String[])new String[]{part}));
            }
            String index = part.substring(1, part.indexOf(93));
            int arrayI = 0;
            try {
                arrayI = Integer.parseInt(index.trim());
            }
            catch (NumberFormatException e) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.UnableToParseArrayIndex", (String[])new String[]{index}));
            }
            if (part.indexOf(93) < part.length() - 1) {
                part = part.substring(part.indexOf(93) + 1, part.length());
                this.m_tempParts.add(0, part);
            }
            if (arrayI >= array.size() || arrayI < 0) {
                return null;
            }
            Object element = array.get(arrayI);
            Schema elementType = s.getElementType();
            if (element == null) {
                return null;
            }
            if (elementType.getType() == Schema.Type.UNION) {
                if (element instanceof GenericContainer) {
                    elementType = ((GenericContainer)element).getSchema();
                } else if (element instanceof Map) {
                    Schema mapSchema = null;
                    for (Schema ts : elementType.getTypes()) {
                        if (ts.getType() != Schema.Type.MAP) continue;
                        mapSchema = ts;
                        break;
                    }
                    if (mapSchema == null) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.UnableToFindSchemaForUnionMap", (String[])new String[0]));
                    }
                    elementType = mapSchema;
                } else {
                    elementType = this.m_tempValueMeta.getType() != 2 ? AvroInputData.checkUnion(elementType) : Schema.create((Schema.Type)Schema.Type.STRING);
                }
            }
            if (elementType.getType() == Schema.Type.RECORD) {
                return this.convertToKettleValue((GenericData.Record)element, elementType, ignoreMissing);
            }
            if (elementType.getType() == Schema.Type.ARRAY) {
                return this.convertToKettleValue((GenericData.Array)element, elementType, ignoreMissing);
            }
            if (elementType.getType() == Schema.Type.MAP) {
                return this.convertToKettleValue((Map)element, elementType, ignoreMissing);
            }
            return this.getPrimitive(element, elementType);
        }

        public Object convertToKettleValue(GenericData.Record record, Schema s, boolean ignoreMissing) throws KettleException {
            Schema.Field fieldS;
            if (record == null) {
                return null;
            }
            if (this.m_tempParts.size() == 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.MalformedPathRecord", (String[])new String[0]));
            }
            String part = this.m_tempParts.remove(0);
            if (part.charAt(0) == '[') {
                throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.InvalidPath", (String[])new String[0]) + this.m_tempParts);
            }
            if (part.indexOf(91) > 0) {
                String arrayPart = part.substring(part.indexOf(91));
                part = part.substring(0, part.indexOf(91));
                this.m_tempParts.add(0, arrayPart);
            }
            if ((fieldS = s.getField(part)) == null && !ignoreMissing) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.NonExistentField", (String[])new String[]{part}));
            }
            Object field = record.get(part);
            if (field == null) {
                return null;
            }
            Schema.Type fieldT = fieldS.schema().getType();
            Schema fieldSchema = fieldS.schema();
            if (fieldT == Schema.Type.UNION) {
                if (field instanceof GenericContainer) {
                    fieldSchema = ((GenericContainer)field).getSchema();
                    fieldT = fieldSchema.getType();
                } else if (field instanceof Map) {
                    Schema mapSchema = null;
                    for (Schema ts : fieldSchema.getTypes()) {
                        if (ts.getType() != Schema.Type.MAP) continue;
                        mapSchema = ts;
                        break;
                    }
                    if (mapSchema == null) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"AvroInput.Error.UnableToFindSchemaForUnionMap", (String[])new String[0]));
                    }
                    fieldSchema = mapSchema;
                    fieldT = Schema.Type.MAP;
                } else if (this.m_tempValueMeta.getType() != 2) {
                    fieldSchema = AvroInputData.checkUnion(fieldSchema);
                    fieldT = fieldSchema.getType();
                } else {
                    fieldSchema = Schema.create((Schema.Type)Schema.Type.STRING);
                    fieldT = fieldSchema.getType();
                }
            }
            if (fieldT == Schema.Type.RECORD) {
                return this.convertToKettleValue((GenericData.Record)field, fieldSchema, ignoreMissing);
            }
            if (fieldT == Schema.Type.ARRAY) {
                return this.convertToKettleValue((GenericData.Array)field, fieldSchema, ignoreMissing);
            }
            if (fieldT == Schema.Type.MAP) {
                return this.convertToKettleValue((Map)field, fieldSchema, ignoreMissing);
            }
            return this.getPrimitive(field, fieldSchema);
        }
    }

    public static class LookupField {
        public String m_fieldName = "";
        public String m_variableName = "";
        public String m_defaultValue = "";
        protected String m_cleansedVariableName;
        protected String m_resolvedFieldName;
        protected String m_resolvedDefaultValue;
        protected boolean m_isValid = true;
        protected int m_inputIndex = -1;
        protected ValueMetaInterface m_fieldVM;

        public boolean init(RowMetaInterface inRowMeta, VariableSpace space) {
            if (inRowMeta == null) {
                this.m_isValid = false;
                return false;
            }
            this.m_resolvedFieldName = space != null ? space.environmentSubstitute(this.m_fieldName) : this.m_fieldName;
            this.m_inputIndex = inRowMeta.indexOfValue(this.m_resolvedFieldName);
            if (this.m_inputIndex < 0) {
                this.m_isValid = false;
                return this.m_isValid;
            }
            this.m_fieldVM = inRowMeta.getValueMeta(this.m_inputIndex);
            if (Const.isEmpty((String)this.m_variableName)) {
                this.m_isValid = false;
                return this.m_isValid;
            }
            this.m_cleansedVariableName = this.m_variableName.replaceAll("\\.", "_");
            this.m_resolvedDefaultValue = space.environmentSubstitute(this.m_defaultValue);
            return this.m_isValid;
        }

        public void setVariable(VariableSpace space, Object[] inRow) {
            if (!this.m_isValid) {
                return;
            }
            String valueToSet = "";
            try {
                valueToSet = this.m_fieldVM.isNull(inRow[this.m_inputIndex]) ? (!Const.isEmpty((String)this.m_resolvedDefaultValue) ? this.m_resolvedDefaultValue : "null") : this.m_fieldVM.getString(inRow[this.m_inputIndex]);
            }
            catch (KettleValueException e) {
                valueToSet = "null";
            }
            space.setVariable(this.m_cleansedVariableName, valueToSet);
        }
    }
}

