/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CellScannable;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.MultiAction;
import org.apache.hadoop.hbase.client.MultiResponse;
import org.apache.hadoop.hbase.client.RegionServerCallable;
import org.apache.hadoop.hbase.ipc.PayloadCarryingRpcController;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;

class MultiServerCallable<R>
extends RegionServerCallable<MultiResponse> {
    private final MultiAction<R> multiAction;
    private final boolean cellBlock;

    MultiServerCallable(HConnection connection, TableName tableName, ServerName location, MultiAction<R> multi) {
        super(connection, tableName, null);
        this.multiAction = multi;
        this.location = new HRegionLocation(null, location);
        this.cellBlock = this.isCellBlock();
    }

    @Override
    protected HRegionLocation getLocation() {
        throw new RuntimeException("Cannot get region location for multi-region request");
    }

    @Override
    public HRegionInfo getHRegionInfo() {
        throw new RuntimeException("Cannot get region info for multi-region request");
    }

    MultiAction<R> getMulti() {
        return this.multiAction;
    }

    @Override
    public MultiResponse call() throws IOException {
        ClientProtos.MultiResponse responseProto;
        int countOfActions = this.multiAction.size();
        if (countOfActions <= 0) {
            throw new DoNotRetryIOException("No Actions");
        }
        ClientProtos.MultiRequest.Builder multiRequestBuilder = ClientProtos.MultiRequest.newBuilder();
        ClientProtos.RegionAction.Builder regionActionBuilder = ClientProtos.RegionAction.newBuilder();
        ClientProtos.Action.Builder actionBuilder = ClientProtos.Action.newBuilder();
        ClientProtos.MutationProto.Builder mutationBuilder = ClientProtos.MutationProto.newBuilder();
        ArrayList<CellScannable> cells = null;
        long nonceGroup = this.multiAction.getNonceGroup();
        if (nonceGroup != 0L) {
            multiRequestBuilder.setNonceGroup(nonceGroup);
        }
        for (Map.Entry e : this.multiAction.actions.entrySet()) {
            byte[] regionName = e.getKey();
            List actions = e.getValue();
            regionActionBuilder.clear();
            regionActionBuilder.setRegion(RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName));
            if (this.cellBlock) {
                if (cells == null) {
                    cells = new ArrayList<CellScannable>(countOfActions);
                }
                regionActionBuilder = RequestConverter.buildNoDataRegionAction(regionName, actions, cells, regionActionBuilder, actionBuilder, mutationBuilder);
            } else {
                regionActionBuilder = RequestConverter.buildRegionAction(regionName, actions, regionActionBuilder, actionBuilder, mutationBuilder);
            }
            multiRequestBuilder.addRegionAction(regionActionBuilder.build());
        }
        PayloadCarryingRpcController controller = new PayloadCarryingRpcController(cells);
        controller.setPriority(this.getTableName());
        ClientProtos.MultiRequest requestProto = multiRequestBuilder.build();
        try {
            responseProto = this.getStub().multi((RpcController)controller, requestProto);
        }
        catch (ServiceException e) {
            throw ProtobufUtil.getRemoteException(e);
        }
        return ResponseConverter.getResults(requestProto, responseProto, controller.cellScanner());
    }

    private boolean isCellBlock() {
        HConnection connection = this.getConnection();
        if (connection == null) {
            return true;
        }
        Configuration configuration = connection.getConfiguration();
        if (configuration == null) {
            return true;
        }
        String codec = configuration.get("hbase.client.rpc.codec", "");
        return codec != null && codec.length() > 0;
    }

    @Override
    public void prepare(boolean reload) throws IOException {
        this.setStub(this.getConnection().getClient(this.location.getServerName()));
    }

    @VisibleForTesting
    ServerName getServerName() {
        return this.location.getServerName();
    }
}

