/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.Collection;
import java.util.Iterator;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.HRegionInfo;

@InterfaceAudience.Private
public class RegionReplicaUtil {
    static final int DEFAULT_REPLICA_ID = 0;

    public static HRegionInfo getRegionInfoForReplica(HRegionInfo regionInfo, int replicaId) {
        if (regionInfo.getReplicaId() == replicaId) {
            return regionInfo;
        }
        HRegionInfo replicaInfo = new HRegionInfo(regionInfo.getTable(), regionInfo.getStartKey(), regionInfo.getEndKey(), regionInfo.isSplit(), regionInfo.getRegionId(), replicaId);
        replicaInfo.setOffline(regionInfo.isOffline());
        return replicaInfo;
    }

    public static HRegionInfo getRegionInfoForDefaultReplica(HRegionInfo regionInfo) {
        return RegionReplicaUtil.getRegionInfoForReplica(regionInfo, 0);
    }

    public static boolean isDefaultReplica(HRegionInfo hri) {
        return hri.getReplicaId() == 0;
    }

    public static boolean isDefaultReplica(int replicaId) {
        return 0 == replicaId;
    }

    public static void removeNonDefaultRegions(Collection<HRegionInfo> regions) {
        Iterator<HRegionInfo> iterator = regions.iterator();
        while (iterator.hasNext()) {
            HRegionInfo hri = iterator.next();
            if (RegionReplicaUtil.isDefaultReplica(hri)) continue;
            iterator.remove();
        }
    }
}

