/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.Trace;
import java.io.CharConversionException;

public class ConvTableUnicodeBigMap
extends ConvTable {
    ConvTableUnicodeBigMap(int n) {
        super(n);
    }

    final String byteArrayToString(byte[] byArray, int n, int n2, int n3) {
        return this.byteArrayToString(byArray, n, n2);
    }

    final String byteArrayToString(byte[] byArray, int n, int n2, BidiConversionProperties bidiConversionProperties) {
        return this.byteArrayToString(byArray, n, n2);
    }

    final String byteArrayToString(byte[] byArray, int n, int n2) {
        if (Trace.traceOn_) {
            Trace.log(5, "Converting byte array to string for ccsid: " + this.ccsid_, byArray, n, n2);
        }
        char[] cArray = new char[n2 / 2];
        int n3 = n;
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = (char)(((byArray[n3++] & 0xFF) << 8) + (byArray[n3++] & 0xFF));
        }
        if (Trace.traceOn_) {
            Trace.log(5, "Destination string for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(cArray));
        }
        return String.copyValueOf(cArray);
    }

    final byte[] stringToByteArray(String string, int n) {
        char[] cArray = string.toCharArray();
        return this.stringToByteArray(cArray, 0, cArray.length);
    }

    final byte[] stringToByteArray(String string, BidiConversionProperties bidiConversionProperties) {
        char[] cArray = string.toCharArray();
        return this.stringToByteArray(cArray, 0, cArray.length);
    }

    final byte[] stringToByteArray(char[] cArray, int n, int n2) {
        if (Trace.traceOn_) {
            Trace.log(5, "Converting string to byte array for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(cArray, n, n2));
        }
        byte[] byArray = new byte[n2 * 2];
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            byArray[n3++] = (byte)(cArray[i] >>> 8);
            byArray[n3++] = (byte)cArray[i];
        }
        if (Trace.traceOn_) {
            Trace.log(5, "Destination byte array for ccsid: " + this.ccsid_, byArray);
        }
        return byArray;
    }

    final void stringToByteArray(String string, byte[] byArray, int n) throws CharConversionException {
        char[] cArray = string.toCharArray();
        if (Trace.traceOn_) {
            Trace.log(5, "Converting string to byte array for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(cArray));
        }
        try {
            int n2 = n;
            for (int i = 0; i < cArray.length; ++i) {
                byArray[n2++] = (byte)(cArray[i] >>> 8);
                byArray[n2++] = (byte)cArray[i];
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Trace.log(2, "Source length: " + cArray.length + "; Source offset: 0; Destination length: " + byArray.length + "; Destination offset: " + n + ";", (Throwable)arrayIndexOutOfBoundsException);
            throw new CharConversionException();
        }
        if (Trace.traceOn_) {
            Trace.log(5, "Destination byte array for ccsid: " + this.ccsid_, byArray, n, cArray.length * 2);
        }
    }

    final void stringToByteArray(String string, byte[] byArray, int n, int n2) throws CharConversionException {
        char[] cArray = string.toCharArray();
        int n3 = Math.min(cArray.length, n2 / 2);
        if (Trace.traceOn_) {
            Trace.log(5, "Converting string to byte array for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(cArray, 0, n3));
        }
        try {
            int n4 = n;
            for (int i = 0; i < n3; ++i) {
                byArray[n4++] = (byte)(cArray[i] >>> 8);
                byArray[n4++] = (byte)cArray[i];
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Trace.log(5, "Source length: " + cArray.length + "; Source offset: 0; Destination length: " + byArray.length + "; Destination offset: " + n + "; Number of bytes to copy: " + n2, (Throwable)arrayIndexOutOfBoundsException);
            throw new CharConversionException();
        }
        if (Trace.traceOn_) {
            Trace.log(5, "Destination byte array for ccsid: " + this.ccsid_, byArray, n, n3 * 2);
        }
    }

    final void stringToByteArray(String string, byte[] byArray, int n, int n2, int n3) throws CharConversionException {
        this.stringToByteArray(string, byArray, n, n2);
    }

    final void stringToByteArray(String string, byte[] byArray, int n, int n2, BidiConversionProperties bidiConversionProperties) throws CharConversionException {
        this.stringToByteArray(string, byArray, n, n2);
    }
}

