/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import com.cloudera.sqoop.lib.LargeObjectLoader;
import com.cloudera.sqoop.lib.SqoopRecord;
import com.cloudera.sqoop.mapreduce.AutoProgressMapper;
import java.io.IOException;
import java.sql.SQLException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.mapred.AvroWrapper;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.sqoop.avro.AvroUtil;
import org.apache.sqoop.mapreduce.AvroJob;

public class AvroImportMapper
extends AutoProgressMapper<LongWritable, SqoopRecord, AvroWrapper<GenericRecord>, NullWritable> {
    private final AvroWrapper<GenericRecord> wrapper = new AvroWrapper();
    private Schema schema;
    private LargeObjectLoader lobLoader;
    private boolean bigDecimalFormatString;

    @Override
    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        this.schema = AvroJob.getMapOutputSchema(conf);
        this.lobLoader = new LargeObjectLoader(conf);
        this.bigDecimalFormatString = conf.getBoolean("sqoop.bigdecimal.format.string", true);
    }

    protected void map(LongWritable key, SqoopRecord val, Mapper.Context context) throws IOException, InterruptedException {
        try {
            val.loadLargeObjects(this.lobLoader);
        }
        catch (SQLException sqlE) {
            throw new IOException(sqlE);
        }
        GenericRecord outKey = AvroUtil.toGenericRecord(val.getFieldMap(), this.schema, this.bigDecimalFormatString);
        this.wrapper.datum((Object)outKey);
        context.write(this.wrapper, (Object)NullWritable.get());
    }

    protected void cleanup(Mapper.Context context) throws IOException {
        if (null != this.lobLoader) {
            this.lobLoader.close();
        }
    }
}

