/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.hbase.HBasePutProcessor;
import com.cloudera.sqoop.lib.FieldMapProcessor;
import com.cloudera.sqoop.lib.SqoopRecord;
import com.cloudera.sqoop.manager.ConnManager;
import com.cloudera.sqoop.manager.ImportJobContext;
import com.cloudera.sqoop.mapreduce.DataDrivenImportJob;
import com.cloudera.sqoop.util.ImportException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.sqoop.mapreduce.DelegatingOutputFormat;
import org.apache.sqoop.mapreduce.HBaseImportMapper;

public class HBaseImportJob
extends DataDrivenImportJob {
    public static final Log LOG = LogFactory.getLog((String)HBaseImportJob.class.getName());

    public HBaseImportJob(SqoopOptions opts, ImportJobContext importContext) {
        super(opts, importContext.getInputFormat(), importContext);
    }

    @Override
    protected void configureMapper(Job job, String tableName, String tableClassName) throws IOException {
        job.setOutputKeyClass(SqoopRecord.class);
        job.setOutputValueClass(NullWritable.class);
        job.setMapperClass(this.getMapperClass());
    }

    @Override
    protected Class<? extends Mapper> getMapperClass() {
        return HBaseImportMapper.class;
    }

    @Override
    protected Class<? extends OutputFormat> getOutputFormatClass() throws ClassNotFoundException {
        return DelegatingOutputFormat.class;
    }

    @Override
    protected void configureOutputFormat(Job job, String tableName, String tableClassName) throws ClassNotFoundException, IOException {
        job.setOutputFormatClass(this.getOutputFormatClass());
        Configuration conf = job.getConfiguration();
        conf.setClass("sqoop.output.delegate.field.map.processor.class", HBasePutProcessor.class, FieldMapProcessor.class);
        conf.set("sqoop.hbase.insert.table", this.options.getHBaseTable());
        conf.set("sqoop.hbase.insert.column.family", this.options.getHBaseColFamily());
        String rowKeyCol = this.options.getHBaseRowKeyColumn();
        if (null == rowKeyCol) {
            rowKeyCol = this.options.getSplitByCol();
        }
        if (null == rowKeyCol) {
            ConnManager manager = this.getContext().getConnManager();
            rowKeyCol = manager.getPrimaryKey(tableName);
        }
        if (null == rowKeyCol) {
            throw new IOException("Could not determine the row-key column. Use --hbase-row-key to specify the input column that names each row.");
        }
        conf.set("sqoop.hbase.insert.row.key.column", rowKeyCol);
    }

    @Override
    protected void jobSetup(Job job) throws IOException, ImportException {
        Configuration conf = job.getConfiguration();
        String tableName = conf.get("sqoop.hbase.insert.table");
        String familyName = conf.get("sqoop.hbase.insert.column.family");
        if (null == tableName) {
            throw new ImportException("Import to HBase error: Table name not specified");
        }
        if (null == familyName) {
            throw new ImportException("Import to HBase error: Column family not specified");
        }
        Configuration newConf = HBaseConfiguration.create((Configuration)conf);
        HBaseConfiguration.merge((Configuration)conf, (Configuration)newConf);
        HBaseAdmin admin = new HBaseAdmin(conf);
        try {
            Method isHBaseSecurityEnabled = User.class.getMethod("isHBaseSecurityEnabled", Configuration.class);
            Method obtainAuthTokenForJob = User.class.getMethod("obtainAuthTokenForJob", Configuration.class, Job.class);
            User user = User.getCurrent();
            if (((Boolean)isHBaseSecurityEnabled.invoke(null, conf)).booleanValue()) {
                obtainAuthTokenForJob.invoke((Object)user, conf, job);
            }
        }
        catch (NoSuchMethodException e) {
            LOG.info((Object)"It seems that we're running on HBase without security additions. Security additions will not be used during this job.");
        }
        catch (InvocationTargetException e) {
            throw new ImportException("Can't get authentication token", e);
        }
        catch (IllegalAccessException e) {
            throw new ImportException("Can't get authentication token", e);
        }
        HTableDescriptor tableDesc = null;
        byte[] familyBytes = Bytes.toBytes((String)familyName);
        HColumnDescriptor colDesc = new HColumnDescriptor(familyBytes);
        if (!admin.tableExists(tableName)) {
            if (this.options.getCreateHBaseTable()) {
                LOG.info((Object)("Creating missing HBase table " + tableName));
                tableDesc = new HTableDescriptor(tableName);
                tableDesc.addFamily(colDesc);
                admin.createTable(tableDesc);
            } else {
                LOG.warn((Object)("Could not find HBase table " + tableName));
                LOG.warn((Object)"This job may fail. Either explicitly create the table,");
                LOG.warn((Object)"or re-run with --hbase-create-table.");
            }
        } else {
            tableDesc = admin.getTableDescriptor(Bytes.toBytes((String)tableName));
            if (!tableDesc.hasFamily(familyBytes)) {
                if (this.options.getCreateHBaseTable()) {
                    LOG.info((Object)("Creating missing column family " + familyName));
                    admin.disableTable(tableName);
                    admin.addColumn(tableName, colDesc);
                    admin.enableTable(tableName);
                } else {
                    LOG.warn((Object)("Could not find column family " + familyName + " in table " + tableName));
                    LOG.warn((Object)"This job may fail. Either create the column family,");
                    LOG.warn((Object)"or re-run with --hbase-create-table.");
                }
            }
        }
        TableMapReduceUtil.addDependencyJars((Job)job);
        TableMapReduceUtil.addDependencyJars((Configuration)conf, (Class[])new Class[]{HTable.class});
        super.jobSetup(job);
    }
}

