/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.avatica;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConnectionProperty
extends Enum<ConnectionProperty> {
    public static final /* enum */ ConnectionProperty AUTO_TEMP = new ConnectionProperty("autoTemp", Type.BOOLEAN, "false");
    public static final /* enum */ ConnectionProperty MATERIALIZATIONS_ENABLED = new ConnectionProperty("materializationsEnabled", Type.BOOLEAN, "true");
    public static final /* enum */ ConnectionProperty MODEL = new ConnectionProperty("model", Type.STRING, null);
    public static final /* enum */ ConnectionProperty LEX = new ConnectionProperty("lex", Type.ENUM, "ORACLE");
    public static final /* enum */ ConnectionProperty QUOTING = new ConnectionProperty("quoting", Type.ENUM, null);
    public static final /* enum */ ConnectionProperty QUOTED_CASING = new ConnectionProperty("quotedCasing", Type.ENUM, null);
    public static final /* enum */ ConnectionProperty UNQUOTED_CASING = new ConnectionProperty("unquotedCasing", Type.ENUM, null);
    public static final /* enum */ ConnectionProperty CASE_SENSITIVE = new ConnectionProperty("caseSensitive", Type.BOOLEAN, null);
    public static final /* enum */ ConnectionProperty SCHEMA = new ConnectionProperty("schema", Type.STRING, null);
    public static final /* enum */ ConnectionProperty SPARK = new ConnectionProperty("spark", Type.BOOLEAN, "false");
    public static final /* enum */ ConnectionProperty TIMEZONE = new ConnectionProperty("timezone", Type.STRING, null);
    private final String camelName;
    private final Type type;
    private final String defaultValue;
    private static final Map<String, ConnectionProperty> NAME_TO_PROPS;
    private static final Converter<Boolean> BOOLEAN_CONVERTER;
    private static final Converter<String> IDENTITY_CONVERTER;
    private static final /* synthetic */ ConnectionProperty[] $VALUES;

    public static ConnectionProperty[] values() {
        return (ConnectionProperty[])$VALUES.clone();
    }

    public static ConnectionProperty valueOf(String name) {
        return Enum.valueOf(ConnectionProperty.class, name);
    }

    private ConnectionProperty(String camelName, Type type, String defaultValue) {
        this.camelName = camelName;
        this.type = type;
        this.defaultValue = defaultValue;
    }

    private <T> T get_(Properties properties, Converter<T> converter, String defaultValue) {
        Map<ConnectionProperty, String> map = ConnectionProperty.parse(properties);
        String s = map.get((Object)this);
        if (s != null) {
            return converter.apply(this, s);
        }
        return converter.apply(this, defaultValue);
    }

    public String getString(Properties properties) {
        return this.getString(properties, this.defaultValue);
    }

    public String getString(Properties properties, String defaultValue) {
        assert (this.type == Type.STRING);
        return this.get_(properties, IDENTITY_CONVERTER, defaultValue);
    }

    public boolean getBoolean(Properties properties) {
        return this.getBoolean(properties, Boolean.valueOf(this.defaultValue));
    }

    public boolean getBoolean(Properties properties, boolean defaultValue) {
        assert (this.type == Type.BOOLEAN);
        return this.get_(properties, BOOLEAN_CONVERTER, Boolean.toString(defaultValue));
    }

    public <E extends Enum<E>> E getEnum(Properties properties, Class<E> enumClass) {
        return this.getEnum(properties, enumClass, Enum.valueOf(enumClass, this.defaultValue));
    }

    public <E extends Enum<E>> E getEnum(Properties properties, Class<E> enumClass, E defaultValue) {
        assert (this.type == Type.ENUM);
        return (E)((Enum)this.get_(properties, ConnectionProperty.enumConverter(enumClass), defaultValue.name()));
    }

    static Map<ConnectionProperty, String> parse(Properties properties) {
        LinkedHashMap<ConnectionProperty, String> map = new LinkedHashMap<ConnectionProperty, String>();
        for (String name : properties.stringPropertyNames()) {
            ConnectionProperty connectionProperty = NAME_TO_PROPS.get(name.toUpperCase());
            if (connectionProperty == null) continue;
            map.put(connectionProperty, properties.getProperty(name));
        }
        return map;
    }

    private static <E extends Enum> Converter<E> enumConverter(final Class<E> enumClass) {
        return new Converter<E>(){

            @Override
            public E apply(ConnectionProperty connectionProperty, String s) {
                if (s == null) {
                    throw new RuntimeException("Required property '" + connectionProperty.camelName + "' not specified");
                }
                try {
                    return Enum.valueOf(enumClass, s);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException("Property '" + s + "' not valid for enum " + enumClass.getName());
                }
            }
        };
    }

    static {
        $VALUES = new ConnectionProperty[]{AUTO_TEMP, MATERIALIZATIONS_ENABLED, MODEL, LEX, QUOTING, QUOTED_CASING, UNQUOTED_CASING, CASE_SENSITIVE, SCHEMA, SPARK, TIMEZONE};
        NAME_TO_PROPS = new HashMap<String, ConnectionProperty>();
        for (ConnectionProperty property : ConnectionProperty.values()) {
            NAME_TO_PROPS.put(property.camelName.toUpperCase(), property);
            NAME_TO_PROPS.put(property.name(), property);
        }
        BOOLEAN_CONVERTER = new Converter<Boolean>(){

            @Override
            public Boolean apply(ConnectionProperty connectionProperty, String s) {
                if (s == null) {
                    throw new RuntimeException("Required property '" + connectionProperty.camelName + "' not specified");
                }
                return Boolean.parseBoolean(s);
            }
        };
        IDENTITY_CONVERTER = new Converter<String>(){

            @Override
            public String apply(ConnectionProperty connectionProperty, String s) {
                return s;
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        BOOLEAN,
        STRING,
        ENUM;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Converter<T> {
        public T apply(ConnectionProperty var1, String var2);
    }
}

