/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.regionserver.wal.MetricsWALSource;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class MetricsWAL {
    static final Log LOG = LogFactory.getLog(MetricsWAL.class);
    private final MetricsWALSource source = (MetricsWALSource)CompatibilitySingletonFactory.getInstance(MetricsWALSource.class);

    public void finishSync(long time) {
        this.source.incrementSyncTime(time);
    }

    public void finishAppend(long time, long size) {
        this.source.incrementAppendCount();
        this.source.incrementAppendTime(time);
        this.source.incrementAppendSize(size);
        if (time > 1000L) {
            this.source.incrementSlowAppendCount();
            LOG.warn((Object)String.format("%s took %d ms appending an edit to hlog; len~=%s", Thread.currentThread().getName(), time, StringUtils.humanReadableInt((long)size)));
        }
    }
}

