/*
 * Decompiled with CFR 0.152.
 */
package com.infobright.reflect;

import com.infobright.reflect.MethodTimedOutException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class TimeoutEnabledMethod {
    private final Method method;

    public TimeoutEnabledMethod(Method method) {
        this.method = method;
        method.setAccessible(true);
    }

    public Object invoke(long millis, Object obj, Object ... args) throws MethodTimedOutException, InterruptedException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        ExecutorThread worker = new ExecutorThread(obj, args);
        worker.start();
        worker.join(millis);
        if (!Thread.State.TERMINATED.equals((Object)worker.getState())) {
            worker.interrupt();
            worker.join();
            throw new MethodTimedOutException(millis, this.method, obj, args);
        }
        if (worker.getIllegalAccessException() != null) {
            throw worker.getIllegalAccessException();
        }
        if (worker.getIllegalArgumentException() != null) {
            throw worker.getIllegalArgumentException();
        }
        if (worker.getInvocationTargetException() != null) {
            throw worker.getInvocationTargetException();
        }
        if (worker.getNullPointerException() != null) {
            throw worker.getNullPointerException();
        }
        if (worker.getExceptionInInitializerError() != null) {
            throw worker.getExceptionInInitializerError();
        }
        return worker.getReturnValue();
    }

    private class ExecutorThread
    extends Thread {
        private final Object obj;
        private final Object[] args;
        private IllegalAccessException illegalAccessException = null;
        private IllegalArgumentException illegalArgumentException = null;
        private InvocationTargetException invocationTargetException = null;
        private NullPointerException nullPointerException = null;
        private ExceptionInInitializerError exceptionInInitializerError = null;
        private Object returnValue = null;

        public ExecutorThread(Object obj, Object[] args) {
            this.obj = obj;
            this.args = args;
        }

        public void run() {
            try {
                this.returnValue = TimeoutEnabledMethod.this.method.invoke(this.obj, this.args);
            }
            catch (IllegalAccessException e) {
                this.illegalAccessException = e;
            }
            catch (IllegalArgumentException e) {
                this.illegalArgumentException = e;
            }
            catch (InvocationTargetException e) {
                this.invocationTargetException = e;
            }
            catch (NullPointerException e) {
                this.nullPointerException = e;
            }
            catch (ExceptionInInitializerError e) {
                this.exceptionInInitializerError = e;
            }
        }

        private IllegalAccessException getIllegalAccessException() {
            return this.illegalAccessException;
        }

        private IllegalArgumentException getIllegalArgumentException() {
            return this.illegalArgumentException;
        }

        private InvocationTargetException getInvocationTargetException() {
            return this.invocationTargetException;
        }

        private NullPointerException getNullPointerException() {
            return this.nullPointerException;
        }

        private Error getExceptionInInitializerError() {
            return this.exceptionInInitializerError;
        }

        private Object getReturnValue() {
            return this.returnValue;
        }
    }
}

