/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.commons.connection.marshal;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.commons.connection.marshal.MarshallableColumnNames;
import org.pentaho.commons.connection.marshal.MarshallableColumnTypes;
import org.pentaho.commons.connection.marshal.MarshallableResultSet;
import org.pentaho.commons.connection.marshal.MarshallableRow;
import org.pentaho.commons.connection.memory.MemoryMetaData;
import org.pentaho.commons.connection.memory.MemoryResultSet;

public class ResultSetMarshaller {
    public static MarshallableResultSet fromResultSet(IPentahoResultSet results) {
        MarshallableResultSet data = new MarshallableResultSet();
        data.setResultSet(results);
        return data;
    }

    public static IPentahoResultSet toResultSet(MarshallableResultSet data) {
        MarshallableColumnNames columnNames = data.getColumnNames();
        MarshallableColumnTypes columnTypes = data.getColumnTypes();
        MarshallableRow[] rows = data.getRows();
        String[] names = columnNames.getColumnName();
        String[] types = columnTypes.getColumnType();
        MemoryMetaData metadata = new MemoryMetaData(new Object[][]{names}, null);
        metadata.setColumnTypes(types);
        MemoryResultSet result = new MemoryResultSet(metadata);
        int columnCount = names.length;
        for (int i = 0; i < rows.length; ++i) {
            String[] rowAsStrings = rows[i].getCell();
            Object[] row = new Object[columnCount];
            for (int colNo = 0; colNo < columnCount; ++colNo) {
                row[colNo] = ResultSetMarshaller.convertCell(rowAsStrings[colNo], types[colNo]);
            }
            result.addRow(row);
        }
        return result;
    }

    public static Object convertCell(String value, String type) {
        if ("string".equals(type)) {
            return value;
        }
        if (value == null || "".equals(value)) {
            return null;
        }
        if ("integer".equals(type)) {
            return Integer.parseInt(value);
        }
        if ("long".equals(type)) {
            return Long.parseLong(value);
        }
        if ("decimal".equals(type)) {
            return new BigDecimal(value);
        }
        if ("float".equals(type)) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if ("double".equals(type)) {
            return Double.parseDouble(value);
        }
        if ("boolean".equals(type)) {
            return Boolean.parseBoolean(value);
        }
        if ("dateTime".equals(type)) {
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd.HH:mm:ss");
            try {
                return fmt.parse(value.replace('T', '.'));
            }
            catch (ParseException e) {
                return value;
            }
        }
        return value;
    }
}

