/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.core.system.objfac.spring;

import java.util.List;
import java.util.Map;
import org.pentaho.platform.api.engine.IPentahoObjectReference;
import org.pentaho.platform.api.engine.ObjectFactoryException;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;

public class BeanBuilder
implements FactoryBean {
    private String type;
    private Map<String, String> attributes;
    private static ThreadLocal<BeanBuilder> resolvingBean = new ThreadLocal();
    private static Logger log = LoggerFactory.getLogger(BeanBuilder.class);

    public Object getObject() {
        try {
            if (resolvingBean.get() == this) {
                log.warn("Circular Reference detected in bean creation ( " + this.type + " : " + this.attributes + "). Very likely a published " + "pentaho bean is resolving itself. Ensure that the published attributes do not match that of the Pentaho " + "bean query. The system will attempt to find the next highest available bean, but at a performance " + "penilty");
                Class<?> cls = this.getClass().getClassLoader().loadClass(this.type.trim());
                resolvingBean.set(this);
                List objectReferences = PentahoSystem.getObjectFactory().getObjectReferences(cls, PentahoSessionHolder.getSession(), this.attributes);
                resolvingBean.set(null);
                if (objectReferences.size() > 1) {
                    return ((IPentahoObjectReference)objectReferences.get(1)).getObject();
                }
                throw new IllegalStateException("Fatal Circular reference in Pentaho Bean ( " + this.type + " : " + this.attributes + ")");
            }
            Class<?> cls = this.getClass().getClassLoader().loadClass(this.type.trim());
            resolvingBean.set(this);
            Object val = PentahoSystem.get(cls, PentahoSessionHolder.getSession(), this.attributes);
            resolvingBean.set(null);
            return val;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (ObjectFactoryException e) {
            throw new RuntimeException(e);
        }
    }

    public Class<?> getObjectType() {
        return Object.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }
}

