/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.connection.datasource.dbcp;

import javax.sql.DataSource;
import org.pentaho.platform.api.data.DBDatasourceServiceException;
import org.pentaho.platform.engine.services.connection.datasource.dbcp.BaseDatasourceService;
import org.pentaho.platform.engine.services.messages.Messages;

public class JndiDatasourceService
extends BaseDatasourceService {
    @Override
    protected DataSource retrieve(String dsName) throws DBDatasourceServiceException {
        DataSource ds = null;
        try {
            ds = this.getJndiDataSource(dsName);
            if (ds != null) {
                this.cacheManager.putInRegionCache("DataSource", (Object)dsName, (Object)ds);
            }
        }
        catch (DBDatasourceServiceException dse) {
            throw new DBDatasourceServiceException(Messages.getInstance().getErrorString("DatasourceService.ERROR_0003_UNABLE_TO_GET_JNDI_DATASOURCE"), (Throwable)dse);
        }
        return ds;
    }
}

