/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.uifoundation.component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.Element;
import org.dom4j.Node;
import org.pentaho.commons.connection.IPentahoMetaData;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.platform.api.engine.ComponentException;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.uifoundation.component.xml.FilterPanelException;
import org.pentaho.platform.uifoundation.messages.Messages;
import org.pentaho.platform.util.xml.XForm;
import org.pentaho.platform.util.xml.dom4j.XmlDom4JHelper;

public abstract class FilterDefinition {
    private static final String RE_HAS_WHITE_SPACE = ".+\\s+.+";
    private String title;
    private String elementName;
    private IPentahoResultSet resultSet;
    private int type;
    protected String descriptionItem;
    protected String valueItem;
    private String[] defaultValue;
    protected Element node;
    protected String formName;
    protected ILogger logger;
    protected IPentahoSession session;
    private int nameColumnNo = -1;
    private int valueColumnNo = -1;

    protected FilterDefinition(Element node, IPentahoSession session, ILogger logger) {
        this.logger = logger;
        this.node = node;
        this.session = session;
    }

    public String getTitle() {
        return this.title;
    }

    public String getName() {
        return this.elementName;
    }

    public void fromXml(Element xMLnode) throws FilterPanelException {
        this.title = XmlDom4JHelper.getNodeText("title", (Node)xMLnode);
        this.elementName = XmlDom4JHelper.getNodeText("name", (Node)xMLnode);
        this.descriptionItem = XmlDom4JHelper.getNodeText("data-display", (Node)xMLnode);
        this.valueItem = XmlDom4JHelper.getNodeText("data-value", (Node)xMLnode);
        this.formName = XmlDom4JHelper.getNodeText("name", (Node)xMLnode);
        String typeStr = XmlDom4JHelper.getNodeText("type", (Node)xMLnode);
        this.type = "radio".equalsIgnoreCase(typeStr) ? 1 : ("list".equalsIgnoreCase(typeStr) ? 3 : ("list-multi".equalsIgnoreCase(typeStr) ? 4 : ("check-multi".equalsIgnoreCase(typeStr) ? 5 : ("check-multi-scroll".equalsIgnoreCase(typeStr) ? 6 : ("check-multi-scroll-2-column".equalsIgnoreCase(typeStr) ? 7 : ("check-multi-scroll-3-column".equalsIgnoreCase(typeStr) ? 8 : ("check-multi-scroll-4-column".equalsIgnoreCase(typeStr) ? 9 : ("text-box".equalsIgnoreCase(typeStr) ? 10 : 2))))))));
    }

    public void setDefaultValue(String[] defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isValid(String[] values) {
        if (values == null) {
            return false;
        }
        for (String element : values) {
            if (this.isValid(element)) continue;
            return false;
        }
        return true;
    }

    protected boolean isValid(String value) {
        boolean mustExistInList;
        String empty = XmlDom4JHelper.getNodeText("empty-accepted", (Node)this.node);
        String valueInList = XmlDom4JHelper.getNodeText("value-in-list", (Node)this.node);
        boolean isEmptyAccepted = Boolean.parseBoolean(empty);
        boolean bl = mustExistInList = valueInList != null && valueInList.length() > 0 ? Boolean.parseBoolean(valueInList) : true;
        if (mustExistInList) {
            if (value == null) {
                return false;
            }
            if (this.resultSet == null) {
                return false;
            }
            Object[] row = this.resultSet.next();
            while (row != null) {
                String rowValue = row[this.valueColumnNo].toString();
                if (value.equals(rowValue)) {
                    this.resultSet.close();
                    return true;
                }
                row = this.resultSet.next();
            }
            this.resultSet.close();
            return false;
        }
        if (isEmptyAccepted) {
            return true;
        }
        return value != null && value.length() > 0;
    }

    protected abstract IPentahoResultSet getResultSet(Map var1);

    public boolean populate(Map parameterProviders, String[] value) {
        this.defaultValue = value;
        this.resultSet = this.getResultSet(parameterProviders);
        if (this.resultSet != null) {
            IPentahoMetaData metaData = this.resultSet.getMetaData();
            this.nameColumnNo = metaData.getColumnIndex(this.descriptionItem);
            this.valueColumnNo = metaData.getColumnIndex(this.valueItem);
        }
        return this.resultSet != null;
    }

    public void getXForm(StringBuffer xformHeader, StringBuffer xformBody) throws ComponentException {
        HashMap<String, String> displayNames = null;
        ArrayList<String> items = null;
        if (this.resultSet != null && this.resultSet.getRowCount() > 0) {
            displayNames = new HashMap<String, String>();
            items = new ArrayList<String>();
            if (this.nameColumnNo == -1) {
                throw new ComponentException(Messages.getInstance().getErrorString("FilterDefinition.ERROR_0001_NAME_COLUMN_MISSING", this.descriptionItem));
            }
            if (this.valueColumnNo == -1) {
                throw new ComponentException(Messages.getInstance().getErrorString("FilterDefinition.ERROR_0002_VALUE_COLUMN_MISSING", this.valueItem));
            }
            Object[] row = null;
            try {
                row = this.resultSet.next();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (row == null) {
                this.logger.warn(Messages.getInstance().getErrorString("FilterDefinition.ERROR_0004_FILTER_DEFINITION_EMPTY"));
            } else {
                while (row != null) {
                    String value = row[this.valueColumnNo].toString();
                    items.add(value);
                    String name = row[this.nameColumnNo].toString();
                    if (name != null) {
                        displayNames.put(value, name);
                    }
                    row = this.resultSet.next();
                }
            }
            this.resultSet.close();
            if (displayNames.size() == 0) {
                displayNames = null;
            }
        } else if (this.type != 10) {
            throw new ComponentException(Messages.getInstance().getErrorString("FilterDefinition.ERROR_0003_FILTER_DEFINITION_NULL"));
        }
        assert (this.formName != null) : Messages.getInstance().getErrorString("FilterDefinition.ERROR_0005_NAME_ELEMENT_EMPTY");
        assert (!this.formName.matches(RE_HAS_WHITE_SPACE)) : Messages.getInstance().getErrorString("FilterDefinition.ERROR_0006_NAME_ELEMENT_WHITESPACE");
        XForm.createXFormControl(this.type, this.elementName, this.defaultValue, items, displayNames, this.formName, xformHeader, xformBody);
    }

    public static void main(String[] args) {
        String[] nm;
        for (String element : nm = new String[]{" xx", "xx ", " xx ", "x x", "xx", "custome rnumber", " x x "}) {
            boolean matches = element.matches(RE_HAS_WHITE_SPACE);
            System.out.println("[" + element + "] matches: " + matches);
        }
    }
}

