/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.util;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.pentaho.platform.api.engine.IDocumentResourceLoader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JarEntityResolver
implements IDocumentResourceLoader {
    private static JarEntityResolver instance;

    public static JarEntityResolver getInstance() {
        if (instance == null) {
            instance = new JarEntityResolver();
        }
        return instance;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        int idx = systemId.lastIndexOf(47);
        String dtdName = systemId.substring(idx + 1);
        try {
            InputStream xslIS = this.getClass().getClassLoader().getResourceAsStream("system/dtd/" + dtdName);
            if (xslIS != null) {
                InputSource source = new InputSource(xslIS);
                return source;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    public Source resolve(String href, String base) {
        try {
            InputStream xslIS = this.getClass().getClassLoader().getResourceAsStream(href);
            StreamSource xslSrc = new StreamSource(xslIS);
            return xslSrc;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public InputStream loadXsl(String name) {
        try {
            InputStream xslIS = this.getClass().getClassLoader().getResourceAsStream(name);
            return xslIS;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

