/*
 * Decompiled with CFR 0.152.
 */
package mondrian.mdx;

import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ResultStyle;
import mondrian.calc.TupleIterable;
import mondrian.calc.impl.AbstractIterCalc;
import mondrian.mdx.MdxVisitor;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.ExpBase;
import mondrian.olap.Hierarchy;
import mondrian.olap.NamedSet;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.type.Type;

public class NamedSetExpr
extends ExpBase
implements Exp {
    private final NamedSet namedSet;

    public NamedSetExpr(NamedSet namedSet) {
        Util.assertPrecondition(namedSet != null, "namedSet != null");
        this.namedSet = namedSet;
    }

    public NamedSet getNamedSet() {
        return this.namedSet;
    }

    public String toString() {
        return this.namedSet.getUniqueName();
    }

    public NamedSetExpr clone() {
        return new NamedSetExpr(this.namedSet);
    }

    public int getCategory() {
        return 8;
    }

    public Exp accept(Validator validator) {
        NamedSet namedSet2 = this.namedSet.validate(validator);
        if (namedSet2 == this.namedSet) {
            return this;
        }
        return new NamedSetExpr(namedSet2);
    }

    public Calc accept(ExpCompiler compiler) {
        List<ResultStyle> styleList = compiler.getAcceptableResultStyles();
        if (!styleList.contains((Object)ResultStyle.ITERABLE) && !styleList.contains((Object)ResultStyle.ANY)) {
            return null;
        }
        return new AbstractIterCalc(this, new Calc[0]){

            public TupleIterable evaluateIterable(Evaluator evaluator) {
                Evaluator.NamedSetEvaluator eval = NamedSetExpr.this.getEval(evaluator);
                return eval.evaluateTupleIterable(evaluator);
            }

            public boolean dependsOn(Hierarchy hierarchy) {
                return false;
            }
        };
    }

    public Evaluator.NamedSetEvaluator getEval(Evaluator evaluator) {
        return evaluator.getNamedSetEvaluator(this.namedSet, true);
    }

    public Object accept(MdxVisitor visitor) {
        Object o = visitor.visit(this);
        if (visitor.shouldVisitChildren()) {
            this.namedSet.getExp().accept(visitor);
        }
        return o;
    }

    public Type getType() {
        return this.namedSet.getType();
    }
}

