/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.AbstractList;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.IntegerCalc;
import mondrian.calc.ListCalc;
import mondrian.calc.ResultStyle;
import mondrian.calc.TupleCollections;
import mondrian.calc.TupleList;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.calc.impl.DelegatingTupleList;
import mondrian.calc.impl.UnaryTupleList;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.NativeEvaluator;
import mondrian.olap.SchemaReader;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.MultiResolver;

class TopBottomCountFunDef
extends FunDefBase {
    boolean top;
    static final MultiResolver TopCountResolver = new MultiResolver("TopCount", "TopCount(<Set>, <Count>[, <Numeric Expression>])", "Returns a specified number of items from the top of a set, optionally ordering the set first.", new String[]{"fxxnn", "fxxn"}){

        protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
            return new TopBottomCountFunDef(dummyFunDef, true);
        }
    };
    static final MultiResolver BottomCountResolver = new MultiResolver("BottomCount", "BottomCount(<Set>, <Count>[, <Numeric Expression>])", "Returns a specified number of items from the bottom of a set, optionally ordering the set first.", new String[]{"fxxnn", "fxxn"}){

        protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
            return new TopBottomCountFunDef(dummyFunDef, false);
        }
    };

    public TopBottomCountFunDef(FunDef dummyFunDef, boolean top) {
        super(dummyFunDef);
        this.top = top;
    }

    public Calc compileCall(final ResolvedFunCall call, ExpCompiler compiler) {
        final ListCalc listCalc = compiler.compileList(call.getArg(0), true);
        final IntegerCalc integerCalc = compiler.compileInteger(call.getArg(1));
        final Calc orderCalc = call.getArgCount() > 2 ? compiler.compileScalar(call.getArg(2), true) : null;
        final int arity = call.getType().getArity();
        return new AbstractListCalc(call, new Calc[]{listCalc, integerCalc, orderCalc}){

            public TupleList evaluateList(Evaluator evaluator) {
                SchemaReader schemaReader = evaluator.getSchemaReader();
                NativeEvaluator nativeEvaluator = schemaReader.getNativeSetEvaluator(call.getFunDef(), call.getArgs(), evaluator, this);
                if (nativeEvaluator != null) {
                    return (TupleList)nativeEvaluator.execute(ResultStyle.LIST);
                }
                int n = integerCalc.evaluateInteger(evaluator);
                if (n == 0 || n == -2147483647) {
                    return TupleCollections.emptyList(arity);
                }
                TupleList list = listCalc.evaluateList(evaluator);
                assert (list.getArity() == arity);
                if (list.isEmpty()) {
                    return list;
                }
                if (orderCalc == null) {
                    if (list instanceof AbstractList && list.size() <= n) {
                        return list;
                    }
                    return list.subList(0, n);
                }
                return this.partiallySortList(evaluator, list, this.hasHighCardDimension(list), Math.min(n, list.size()));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private TupleList partiallySortList(Evaluator evaluator, TupleList list, boolean highCard, int n) {
                assert (list.size() > 0);
                assert (n <= list.size());
                if (highCard) {
                    int chunkSize = 6400;
                    TupleList allChunkResults = TupleCollections.createList(arity);
                    int i = 0;
                    while (i < list.size()) {
                        int next = Math.min(i + 6400, list.size());
                        TupleList chunk = list.subList(i, next);
                        TupleList chunkResult = this.partiallySortList(evaluator, chunk, false, n);
                        allChunkResults.addAll(chunkResult);
                        i = next;
                    }
                    return this.partiallySortList(evaluator, allChunkResults, false, n);
                }
                int savepoint = evaluator.savepoint();
                try {
                    switch (list.getArity()) {
                        case 1: {
                            List<Member> members = FunUtil.partiallySortMembers(evaluator.push(), list.slice(0), orderCalc, n, TopBottomCountFunDef.this.top);
                            UnaryTupleList i = new UnaryTupleList(members);
                            return i;
                        }
                    }
                    List<List<Member>> tuples = FunUtil.partiallySortTuples(evaluator.push(), list, orderCalc, n, TopBottomCountFunDef.this.top);
                    DelegatingTupleList delegatingTupleList = new DelegatingTupleList(list.getArity(), tuples);
                    return delegatingTupleList;
                }
                finally {
                    evaluator.restore(savepoint);
                }
            }

            public boolean dependsOn(Hierarchy hierarchy) {
                return 3.anyDependsButFirst(this.getCalcs(), hierarchy);
            }

            private boolean hasHighCardDimension(TupleList l) {
                List trial = (List)l.get(0);
                for (Member m : trial) {
                    if (!m.getHierarchy().getDimension().isHighCardinality()) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

