/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.CalcWriter;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ResultStyle;
import mondrian.calc.impl.AbstractCalc;
import mondrian.calc.impl.DelegatingExpCompiler;
import mondrian.calc.impl.GenericCalc;
import mondrian.calc.impl.GenericIterCalc;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.type.SetType;
import mondrian.olap.type.Type;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapEvaluatorRoot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolapProfilingEvaluator
extends RolapEvaluator {
    RolapProfilingEvaluator(RolapEvaluatorRoot root) {
        super(root);
    }

    private RolapProfilingEvaluator(RolapEvaluatorRoot root, RolapProfilingEvaluator evaluator, List<List<Member>> aggregationList) {
        super(root, evaluator, aggregationList);
    }

    @Override
    protected RolapEvaluator _push(List<List<Member>> aggregationList) {
        return new RolapProfilingEvaluator(this.root, this, aggregationList);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProfilingScalarCalc
    extends GenericCalc {
        private final Calc calc;
        private int callCount;
        private long callMillis;

        ProfilingScalarCalc(Exp exp, Calc calc) {
            super(exp, new Calc[]{calc});
            this.calc = calc;
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) {
            return this.calc.isWrapperFor(iface);
        }

        @Override
        public <T> T unwrap(Class<T> iface) {
            return this.calc.unwrap(iface);
        }

        @Override
        public Type getType() {
            return this.calc.getType();
        }

        @Override
        public Calc[] getCalcs() {
            return ((AbstractCalc)this.calc).getCalcs();
        }

        @Override
        public boolean dependsOn(Hierarchy hierarchy) {
            return this.calc.dependsOn(hierarchy);
        }

        @Override
        public Object evaluate(Evaluator evaluator) {
            ++this.callCount;
            long start = System.currentTimeMillis();
            Object o = this.calc.evaluate(evaluator);
            long end = System.currentTimeMillis();
            this.callMillis += end - start;
            return o;
        }

        @Override
        public void accept(CalcWriter calcWriter) {
            LinkedHashMap<String, Object> argumentMap = new LinkedHashMap<String, Object>();
            if (calcWriter.enableProfiling()) {
                argumentMap.put("callCount", this.callCount);
                argumentMap.put("callMillis", this.callMillis);
            }
            calcWriter.setParentArgs(this.calc, argumentMap);
            this.calc.accept(calcWriter);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProfilingIterCalc
    extends GenericIterCalc {
        private final Calc calc;
        private int callCount;
        private long callMillis;
        private long elementCount;
        private long elementSquaredCount;

        protected ProfilingIterCalc(Exp exp, Calc calc) {
            super(exp, new Calc[]{calc});
            this.calc = calc;
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) {
            return this.calc.isWrapperFor(iface);
        }

        @Override
        public <T> T unwrap(Class<T> iface) {
            return this.calc.unwrap(iface);
        }

        @Override
        public SetType getType() {
            return (SetType)this.calc.getType();
        }

        @Override
        public ResultStyle getResultStyle() {
            return this.calc.getResultStyle();
        }

        @Override
        public boolean dependsOn(Hierarchy hierarchy) {
            return this.calc.dependsOn(hierarchy);
        }

        @Override
        public Object evaluate(Evaluator evaluator) {
            ++this.callCount;
            long start = System.currentTimeMillis();
            Object o = this.calc.evaluate(evaluator);
            long end = System.currentTimeMillis();
            this.callMillis += end - start;
            if (o instanceof Collection) {
                long size = ((Collection)o).size();
                this.elementCount += size;
                this.elementSquaredCount += size * size;
            }
            return o;
        }

        @Override
        public void accept(CalcWriter calcWriter) {
            LinkedHashMap<String, Object> argumentMap = new LinkedHashMap<String, Object>();
            if (calcWriter.enableProfiling()) {
                argumentMap.put("callCount", this.callCount);
                argumentMap.put("callMillis", this.callMillis);
                argumentMap.put("elementCount", this.elementCount);
                argumentMap.put("elementSquaredCount", this.elementSquaredCount);
            }
            calcWriter.setParentArgs(this.calc, argumentMap);
            this.calc.accept(calcWriter);
        }
    }

    static class ProfilingEvaluatorCompiler
    extends DelegatingExpCompiler {
        ProfilingEvaluatorCompiler(ExpCompiler compiler) {
            super(compiler);
        }

        protected Calc afterCompile(Exp exp, Calc calc, boolean mutable) {
            if ((calc = super.afterCompile(exp, calc, mutable)) == null) {
                return null;
            }
            if (calc.getType() instanceof SetType) {
                return new ProfilingIterCalc(exp, calc);
            }
            return new ProfilingScalarCalc(exp, calc);
        }
    }
}

