/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import mondrian.util.IteratorIterable;
import org.apache.commons.collections.iterators.EnumerationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ClassResolver {
    public static final ClassResolver INSTANCE = new ThreadContextClassResolver();

    public <T> Class<T> forName(String var1, boolean var2) throws ClassNotFoundException;

    public <T> T instantiateSafe(String var1, Object ... var2);

    public Iterable<URL> getResources(String var1) throws IOException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractClassResolver
    implements ClassResolver {
        @Override
        public <T> T instantiateSafe(String className, Object ... args) {
            try {
                Class<T> clazz = this.forName(className, true);
                if (args.length == 0) {
                    return clazz.newInstance();
                }
                Class[] types = new Class[args.length];
                for (int i = 0; i < args.length; ++i) {
                    types[i] = args[i].getClass();
                }
                Constructor<T> constructor = clazz.getConstructor(types);
                return constructor.newInstance(args);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public <T> Class<T> forName(String className, boolean initialize) throws ClassNotFoundException {
            return Class.forName(className, initialize, this.getClassLoader());
        }

        protected abstract ClassLoader getClassLoader();

        protected ClassLoader getClassLoaderNotNull() {
            ClassLoader classLoader = this.getClassLoader();
            return classLoader != null ? classLoader : this.getClass().getClassLoader();
        }

        @Override
        public Iterable<URL> getResources(String name) throws IOException {
            Enumeration<URL> resources = this.getClassLoaderNotNull().getResources(name);
            return new IteratorIterable<URL>((Iterator<URL>)new EnumerationIterator(resources));
        }
    }

    public static class ThreadContextClassResolver
    extends AbstractClassResolver {
        protected ClassLoader getClassLoader() {
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

