/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.registry;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.fonts.LibFontBoot;
import org.pentaho.reporting.libraries.fonts.encoding.EncodingRegistry;
import org.pentaho.reporting.libraries.fonts.registry.DefaultFontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontFileRecord;
import org.pentaho.reporting.libraries.fonts.registry.FontRegistry;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public abstract class AbstractFontFileRegistry
implements FontRegistry {
    private static final Log logger = LogFactory.getLog(AbstractFontFileRegistry.class);
    private HashMap<String, FontFileRecord> seenFiles = new HashMap();
    private HashMap<String, DefaultFontFamily> fontFamilies = new HashMap();
    private HashMap<String, DefaultFontFamily> alternateFamilyNames = new HashMap();
    private HashMap<String, DefaultFontFamily> fullFontNames = new HashMap();

    protected AbstractFontFileRegistry() {
    }

    protected HashMap<String, FontFileRecord> getSeenFiles() {
        return this.seenFiles;
    }

    protected abstract FileFilter getFileFilter();

    @Override
    public void initialize() {
        this.registerDefaultFontPath();
        Configuration configuration = LibFontBoot.getInstance().getGlobalConfig();
        Iterator extraDirIt = configuration.findPropertyKeys("org.pentaho.reporting.libraries.fonts.extra-font-dirs.");
        while (extraDirIt.hasNext()) {
            String extraDirKey = (String)extraDirIt.next();
            String extraDir = configuration.getConfigProperty(extraDirKey);
            File extraDirFile = new File(extraDir);
            try {
                if (!extraDirFile.isDirectory()) continue;
                this.registerFontPath(extraDirFile, this.getDefaultEncoding());
            }
            catch (Exception e) {
                logger.warn((Object)("Extra font path " + extraDir + " could not be fully registered."), (Throwable)e);
            }
        }
    }

    protected String getDefaultEncoding() {
        return LibFontBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.libraries.fonts.itext.FontEncoding", EncodingRegistry.getPlatformDefaultEncoding());
    }

    public void registerDefaultFontPath() {
        String encoding = this.getDefaultEncoding();
        this.loadFromCache(encoding);
        String osname = this.safeSystemGetProperty("os.name", "<protected by system security>");
        String jrepath = this.safeSystemGetProperty("java.home", ".");
        String fs = this.safeSystemGetProperty("file.separator", File.separator);
        logger.debug((Object)("Running on operating system: " + osname));
        logger.debug((Object)("Character encoding used as default: " + encoding));
        if (StringUtils.startsWithIgnoreCase((String)osname, (String)"mac os x")) {
            String userhome = this.safeSystemGetProperty("user.home", ".");
            logger.debug((Object)"Detected MacOS.");
            this.registerFontPath(new File(userhome + "/Library/Fonts"), encoding);
            this.registerFontPath(new File("/Library/Fonts"), encoding);
            this.registerFontPath(new File("/Network/Library/Fonts"), encoding);
            this.registerFontPath(new File("/System/Library/Fonts"), encoding);
        } else if (StringUtils.startsWithIgnoreCase((String)osname, (String)"windows")) {
            this.registerWindowsFontPath(encoding);
        } else {
            logger.debug((Object)"Assuming unix like file structures");
            this.registerFontPath(new File("/usr/X11R6/lib/X11/fonts"), encoding);
            this.registerFontPath(new File("/usr/share/fonts"), encoding);
        }
        this.registerFontPath(new File(jrepath, "lib" + fs + "fonts"), encoding);
        this.storeToCache(encoding);
        logger.info((Object)"Completed font registration.");
    }

    protected void registerPrimaryName(String name, DefaultFontFamily family) {
        this.fontFamilies.put(name, family);
    }

    protected void registerAlternativeName(String name, DefaultFontFamily family) {
        this.alternateFamilyNames.put(name, family);
    }

    protected void registerFullName(String name, DefaultFontFamily family) {
        this.fullFontNames.put(name, family);
    }

    protected DefaultFontFamily createFamily(String name) {
        DefaultFontFamily fontFamily = this.fontFamilies.get(name);
        if (fontFamily != null) {
            return fontFamily;
        }
        DefaultFontFamily createdFamily = new DefaultFontFamily(name);
        this.fontFamilies.put(name, createdFamily);
        return createdFamily;
    }

    @Override
    public String[] getRegisteredFamilies() {
        return this.fontFamilies.keySet().toArray(new String[this.fontFamilies.size()]);
    }

    @Override
    public String[] getAllRegisteredFamilies() {
        return this.alternateFamilyNames.keySet().toArray(new String[this.alternateFamilyNames.size()]);
    }

    @Override
    public FontFamily getFontFamily(String name) {
        FontFamily primary = this.fontFamilies.get(name);
        if (primary != null) {
            return primary;
        }
        FontFamily secondary = this.alternateFamilyNames.get(name);
        if (secondary != null) {
            return secondary;
        }
        return this.fullFontNames.get(name);
    }

    protected void loadFromCache(String encoding) {
        String fileName = this.getCacheFileName();
        if (fileName == null) {
            return;
        }
        this.loadFromCache(encoding, fileName);
    }

    protected void populateFromCache(HashMap<String, DefaultFontFamily> cachedFontFamilies, HashMap<String, DefaultFontFamily> cachedFullFontNames, HashMap<String, DefaultFontFamily> cachedAlternateNames) {
        this.fontFamilies.putAll(cachedFontFamilies);
        this.fullFontNames.putAll(cachedFullFontNames);
        this.alternateFamilyNames.putAll(cachedAlternateNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFromCache(String encoding, String filename) {
        ResourceManager resourceManager = new ResourceManager();
        File location = this.createStorageLocation();
        if (location == null) {
            return;
        }
        File ttfCache = new File(location, filename);
        try {
            HashMap cachedAlternateNames;
            HashMap cachedFullFontNames;
            HashMap cachedFontFamilies;
            HashMap cachedSeenFiles;
            ResourceKey resourceKey = resourceManager.createKey((Object)ttfCache);
            ResourceData data = resourceManager.load(resourceKey);
            InputStream stream = data.getResourceAsStream(resourceManager);
            try {
                ObjectInputStream oin = new ObjectInputStream(stream);
                Object[] cache = (Object[])oin.readObject();
                if (cache.length != 5) {
                    return;
                }
                if (!ObjectUtilities.equal((Object)encoding, (Object)cache[0])) {
                    return;
                }
                cachedSeenFiles = (HashMap)cache[1];
                cachedFontFamilies = (HashMap)cache[2];
                cachedFullFontNames = (HashMap)cache[3];
                cachedAlternateNames = (HashMap)cache[4];
            }
            finally {
                stream.close();
            }
            if (this.isCacheValid(cachedSeenFiles)) {
                this.getSeenFiles().putAll(cachedSeenFiles);
                this.populateFromCache(cachedFontFamilies, cachedFullFontNames, cachedAlternateNames);
            }
        }
        catch (ClassNotFoundException cnfe) {
            logger.debug((Object)"Failed to restore the cache: Cache was created by a different version of LibFonts");
        }
        catch (Exception e) {
            logger.debug((Object)"Non-Fatal: Failed to restore the cache. The cache will be rebuilt.", (Throwable)e);
        }
    }

    protected String getCacheFileName() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeToCache(String encoding) {
        String cacheFileName = this.getCacheFileName();
        if (cacheFileName == null) {
            return;
        }
        File location = this.createStorageLocation();
        if (location == null) {
            return;
        }
        location.mkdirs();
        if (!location.exists() || !location.isDirectory()) {
            return;
        }
        File ttfCache = new File(location, cacheFileName);
        try {
            FileOutputStream fout = new FileOutputStream(ttfCache);
            try {
                Object[] map = new Object[]{encoding, this.getSeenFiles(), this.fontFamilies, this.fullFontNames, this.alternateFamilyNames};
                ObjectOutputStream objectOut = new ObjectOutputStream(new BufferedOutputStream(fout));
                objectOut.writeObject(map);
                objectOut.close();
            }
            finally {
                try {
                    fout.close();
                }
                catch (IOException e) {
                    logger.debug((Object)"Failed to store cached font data", (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            logger.debug((Object)"Failed to store cached font data", (Throwable)e);
        }
    }

    private void registerWindowsFontPath(String encoding) {
        logger.debug((Object)"Found 'Windows' in the OS name, assuming DOS/Win32 structures");
        String fontPath = null;
        String windirs = this.safeSystemGetProperty("java.library.path", null);
        String fs = this.safeSystemGetProperty("file.separator", File.separator);
        if (windirs != null) {
            StringTokenizer strtok = new StringTokenizer(windirs, this.safeSystemGetProperty("path.separator", File.pathSeparator));
            while (strtok.hasMoreTokens()) {
                String token = strtok.nextToken();
                if (!StringUtils.endsWithIgnoreCase((String)token, (String)"System32")) continue;
                int lastBackslash = token.lastIndexOf(fs);
                if (lastBackslash != -1) {
                    fontPath = token.substring(0, lastBackslash) + fs + "Fonts";
                    break;
                }
                int lastSlash = token.lastIndexOf(47);
                if (lastSlash == -1) continue;
                fontPath = token.substring(0, lastSlash) + lastSlash + "Fonts";
                break;
            }
        }
        logger.debug((Object)("Fonts located in \"" + fontPath + '\"'));
        if (fontPath != null) {
            File file = new File(fontPath);
            this.registerFontPath(file, encoding);
        }
    }

    public void registerFontPath(File file, String encoding) {
        if (file.exists() && file.isDirectory() && file.canRead()) {
            for (File currentFile : file.listFiles(this.getFileFilter())) {
                if (currentFile.isDirectory()) {
                    this.registerFontPath(currentFile, encoding);
                    continue;
                }
                if (this.isCached(currentFile)) continue;
                this.registerFontFile(currentFile, encoding);
            }
        }
    }

    protected boolean isCached(File file) {
        try {
            FontFileRecord stored = this.seenFiles.get(file.getCanonicalPath());
            if (stored == null) {
                return false;
            }
            FontFileRecord rec = new FontFileRecord(file);
            if (!stored.equals(rec)) {
                this.seenFiles.remove(file.getCanonicalPath());
                return false;
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void registerFontFile(String filename, String encoding) {
        File file = new File(filename);
        this.registerFontFile(file, encoding);
    }

    public synchronized void registerFontFile(File file, String encoding) {
        if (this.getFileFilter().accept(file) && file.exists() && file.isFile() && file.canRead()) {
            try {
                if (file.length() == 0L) {
                    logger.warn((Object)("Font " + file + " is invalid [zero size]."));
                    return;
                }
                if (this.addFont(file, encoding)) {
                    FontFileRecord value = new FontFileRecord(file);
                    this.seenFiles.put(file.getCanonicalPath(), value);
                }
            }
            catch (Exception e) {
                logger.warn((Object)("Font " + file + " is invalid. Message:" + e.getMessage()), (Throwable)e);
            }
        }
    }

    protected abstract boolean addFont(File var1, String var2) throws IOException;

    protected String safeSystemGetProperty(String name, String defaultValue) {
        try {
            return System.getProperty(name, defaultValue);
        }
        catch (SecurityException se) {
            return defaultValue;
        }
    }

    protected boolean isCacheValid(HashMap cachedSeenFiles) {
        for (Map.Entry entry : cachedSeenFiles.entrySet()) {
            String fullFileName = (String)entry.getKey();
            FontFileRecord fontFileRecord = (FontFileRecord)entry.getValue();
            File fontFile = new File(fullFileName);
            if (!fontFile.isFile() || !fontFile.exists()) {
                return false;
            }
            if (fontFile.length() != fontFileRecord.getFileSize()) {
                return false;
            }
            if (fontFile.lastModified() == fontFileRecord.getLastAccessTime()) continue;
            return false;
        }
        return true;
    }

    protected File createStorageLocation() {
        if (!"true".equals(LibFontBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.libraries.fonts.CacheFontRegistration"))) {
            return null;
        }
        String homeDirectory = this.safeSystemGetProperty("user.home", null);
        if (homeDirectory == null) {
            return null;
        }
        File homeFile = new File(homeDirectory);
        if (!homeFile.isDirectory()) {
            return null;
        }
        return new File(homeFile, ".pentaho/caches/libfonts2");
    }
}

