/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization.acl;

import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.security.authorization.AccessControlUtils;
import org.apache.jackrabbit.core.security.authorization.CompiledPermissions;
import org.apache.jackrabbit.core.security.authorization.acl.ACLEditor;
import org.apache.jackrabbit.core.security.authorization.acl.ACLProvider;
import org.apache.jackrabbit.core.security.authorization.acl.CachingPentahoEntryCollector;
import org.apache.jackrabbit.core.security.authorization.acl.EntryCollector;
import org.apache.jackrabbit.core.security.authorization.acl.PentahoCompiledPermissionsImpl;
import org.apache.jackrabbit.core.security.authorization.acl.PentahoEntryCollector;
import org.pentaho.platform.api.engine.ISystemConfig;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PentahoACLProvider
extends ACLProvider {
    private Map configuration;
    private EntryCollector entryCollector;
    private Map<Integer, PentahoCompiledPermissionsImpl> compiledPermissionsCache = new HashMap<Integer, PentahoCompiledPermissionsImpl>();
    private boolean useCachingEntryCollector;
    private Logger logger = LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getName());
    private boolean initialized;

    public void init(Session systemSession, Map conf) throws RepositoryException {
        this.configuration = conf;
        ISystemConfig settings = (ISystemConfig)PentahoSystem.get(ISystemConfig.class);
        if (settings != null) {
            this.useCachingEntryCollector = "true".equals(settings.getProperty("system.cachingEntryCollector"));
        }
        super.init(systemSession, conf);
        this.updateRootAcl((SessionImpl)systemSession, new ACLEditor((Session)this.session, (AccessControlUtils)this));
        this.initialized = true;
        this.registerEntryCollectorWithObservationManager(systemSession);
    }

    protected void registerEntryCollectorWithObservationManager(Session systemSession) throws RepositoryException {
        if (this.entryCollector != null && this.initialized) {
            ObservationManager observationMgr = systemSession.getWorkspace().getObservationManager();
            observationMgr.addEventListener((EventListener)this.entryCollector, 3, "/", true, null, null, false);
        }
    }

    protected void updateRootAcl(SessionImpl systemSession, ACLEditor editor) throws RepositoryException {
        String rootPath = this.session.getRootNode().getPath();
        AccessControlPolicy[] acls = editor.getPolicies(rootPath);
        if (acls.length > 0) {
            AccessControlEntry[] acEntries;
            PrincipalManager pMgr = systemSession.getPrincipalManager();
            AccessControlManager acMgr = this.session.getAccessControlManager();
            Principal everyone = pMgr.getEveryone();
            Privilege[] privs = new Privilege[]{acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}read"), acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}readAccessControl")};
            AccessControlList acList = (AccessControlList)acls[0];
            for (AccessControlEntry acEntry : acEntries = acList.getAccessControlEntries()) {
                if (!acEntry.getPrincipal().equals(everyone)) continue;
                acList.removeAccessControlEntry(acEntry);
            }
            acList.addAccessControlEntry(everyone, privs);
            editor.setPolicy(rootPath, (AccessControlPolicy)acList);
            this.session.save();
        }
    }

    protected EntryCollector createEntryCollector(SessionImpl systemSession) throws RepositoryException {
        if (this.entryCollector != null) {
            return this.entryCollector;
        }
        if (this.useCachingEntryCollector) {
            this.entryCollector = new CachingPentahoEntryCollector(systemSession, this.getRootNodeId(), this.configuration);
            this.logger.debug("Using Caching EntryCollector");
        } else {
            this.entryCollector = new PentahoEntryCollector(systemSession, this.getRootNodeId(), this.configuration);
            this.logger.debug("Using Non-Caching EntryCollector");
        }
        this.registerEntryCollectorWithObservationManager((Session)systemSession);
        return this.entryCollector;
    }

    public CompiledPermissions compilePermissions(Set<Principal> principals) throws RepositoryException {
        this.checkInitialized();
        if (this.isAdminOrSystem(principals)) {
            return this.getAdminPermissions();
        }
        if (this.isReadOnly(principals)) {
            return this.getReadOnlyPermissions();
        }
        return this.getCompiledPermissions(principals);
    }

    protected PentahoCompiledPermissionsImpl getCompiledPermissions(Set<Principal> principals) throws RepositoryException {
        if (this.compiledPermissionsCache.containsKey(principals.hashCode())) {
            return this.compiledPermissionsCache.get(principals.hashCode());
        }
        PentahoCompiledPermissionsImpl compiledPermissions = new PentahoCompiledPermissionsImpl(principals, this.session, this.entryCollector, (AccessControlUtils)this, true);
        this.compiledPermissionsCache.put(principals.hashCode(), compiledPermissions);
        return compiledPermissions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canAccessRoot(Set<Principal> principals) throws RepositoryException {
        this.checkInitialized();
        if (this.isAdminOrSystem(principals)) {
            return true;
        }
        PentahoCompiledPermissionsImpl cp = this.getCompiledPermissions(principals);
        try {
            boolean bl = cp.canRead(null, (ItemId)this.getRootNodeId());
            return bl;
        }
        finally {
            cp.close();
        }
    }

    private NodeId getRootNodeId() throws RepositoryException {
        return ((NodeImpl)this.session.getRootNode()).getNodeId();
    }
}

