/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.jcr;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.security.Principal;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.api.security.user.Group;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAce;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAcl;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.api.repository2.unified.RepositoryFileSid;
import org.pentaho.platform.repository2.messages.Messages;
import org.pentaho.platform.repository2.unified.jcr.DefaultPermissionConversionHelper;
import org.pentaho.platform.repository2.unified.jcr.IAclMetadataStrategy;
import org.pentaho.platform.repository2.unified.jcr.JcrAclMetadataStrategy;
import org.pentaho.platform.repository2.unified.jcr.JcrRepositoryFileUtils;
import org.pentaho.platform.repository2.unified.jcr.JcrTenantUtils;
import org.pentaho.platform.repository2.unified.jcr.PentahoJcrConstants;
import org.pentaho.platform.repository2.unified.jcr.jackrabbit.security.SpringSecurityRolePrincipal;
import org.pentaho.platform.repository2.unified.jcr.jackrabbit.security.SpringSecurityUserPrincipal;

public class JcrRepositoryFileAclUtils {
    private static final Log logger = LogFactory.getLog(JcrRepositoryFileAclUtils.class);
    public static final String DEFAULT = "DEFAULT";
    public static final String SYSTEM_PROPERTY = "pentaho.repository.server.aclMetadataStrategy";
    private static String strategyName = System.getProperty("pentaho.repository.server.aclMetadataStrategy");
    private static IAclMetadataStrategy strategy;

    private JcrRepositoryFileAclUtils() {
    }

    private static void initialize() {
        if (strategyName == null || "".equals(strategyName)) {
            strategyName = DEFAULT;
        }
        if (strategyName.equals(DEFAULT)) {
            strategy = new JcrAclMetadataStrategy();
        } else {
            try {
                Class<?> clazz = Class.forName(strategyName);
                Constructor<?> customStrategy = clazz.getConstructor(new Class[0]);
                strategy = (IAclMetadataStrategy)customStrategy.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        logger.debug((Object)("JcrRepositoryFileAclUtils initialized: strategy=" + strategyName));
    }

    public static IAclMetadataStrategy.AclMetadata getAclMetadata(Session session, String path, AccessControlList acList) throws RepositoryException {
        return strategy.getAclMetadata(session, path, acList);
    }

    public static void setAclMetadata(Session session, String path, AccessControlList acList, IAclMetadataStrategy.AclMetadata aclMetadata) throws RepositoryException {
        strategy.setAclMetadata(session, path, acList, aclMetadata);
    }

    public static List<AccessControlEntry> removeAclMetadata(List<AccessControlEntry> acEntries) throws RepositoryException {
        return strategy.removeAclMetadata(acEntries);
    }

    public static Privilege[] expandPrivileges(Privilege[] privileges, boolean expandNonStandardOnly) {
        boolean foundAggregatePrivilege;
        HashSet<Privilege> expandedPrivileges = new HashSet<Privilege>();
        expandedPrivileges.addAll(Arrays.asList(privileges));
        do {
            foundAggregatePrivilege = false;
            HashSet iterable = new HashSet(expandedPrivileges);
            for (Privilege privilege : iterable) {
                if (expandNonStandardOnly && (!expandNonStandardOnly || privilege.getName().startsWith("jcr:")) || !privilege.isAggregate()) continue;
                expandedPrivileges.remove(privilege);
                expandedPrivileges.addAll(Arrays.asList(privilege.getAggregatePrivileges()));
                foundAggregatePrivilege = true;
            }
        } while (foundAggregatePrivilege);
        return expandedPrivileges.toArray(new Privilege[0]);
    }

    public static RepositoryFileAcl createAcl(Session session, PentahoJcrConstants pentahoJcrConstants, Serializable fileId, RepositoryFileAcl acl) throws ItemNotFoundException, RepositoryException {
        Node node = session.getNodeByIdentifier(fileId.toString());
        String absPath = node.getPath();
        AccessControlManager acMgr = session.getAccessControlManager();
        AccessControlList acList = JcrRepositoryFileAclUtils.getAccessControlList(acMgr, absPath);
        acMgr.setPolicy(absPath, (AccessControlPolicy)acList);
        return JcrRepositoryFileAclUtils.internalUpdateAcl(session, pentahoJcrConstants, fileId, acl);
    }

    public static void addPermission(Session session, PentahoJcrConstants pentahoJcrConstants, Serializable fileId, RepositoryFileSid recipient, EnumSet<RepositoryFilePermission> permissions) throws RepositoryException {
        JcrRepositoryFileAclUtils.addAce(session, pentahoJcrConstants, fileId, recipient, permissions);
    }

    public static void setOwner(Session session, PentahoJcrConstants pentahoJcrConstants, RepositoryFile file, RepositoryFileSid owner) throws RepositoryException {
        RepositoryFileSid newOwnerSid = owner;
        if (JcrTenantUtils.getUserNameUtils().getTenant(owner.getName()) == null) {
            newOwnerSid = new RepositoryFileSid(JcrTenantUtils.getTenantedUser(owner.getName()), owner.getType());
        }
        RepositoryFileAcl acl = JcrRepositoryFileAclUtils.getAcl(session, pentahoJcrConstants, file.getId());
        RepositoryFileAcl newAcl = new RepositoryFileAcl.Builder(acl).owner(newOwnerSid).build();
        JcrRepositoryFileAclUtils.updateAcl(session, newAcl);
    }

    public static void setFullControl(Session session, PentahoJcrConstants pentahoJcrConstants, Serializable fileId, RepositoryFileSid sid) throws RepositoryException {
        JcrRepositoryFileAclUtils.addAce(session, pentahoJcrConstants, fileId, sid, EnumSet.of(RepositoryFilePermission.ALL));
    }

    public static void addAce(Session session, PentahoJcrConstants pentahoJcrConstants, Serializable id, RepositoryFileSid recipient, EnumSet<RepositoryFilePermission> permission) throws RepositoryException {
        RepositoryFileSid newRecipient = recipient;
        if (JcrTenantUtils.getUserNameUtils().getTenant(recipient.getName()) == null) {
            newRecipient = new RepositoryFileSid(JcrTenantUtils.getTenantedUser(recipient.getName()), recipient.getType());
        }
        RepositoryFileAcl acl = JcrRepositoryFileAclUtils.getAcl(session, pentahoJcrConstants, id);
        RepositoryFileAcl updatedAcl = new RepositoryFileAcl.Builder(acl).ace(newRecipient, permission).build();
        JcrRepositoryFileAclUtils.updateAcl(session, updatedAcl);
    }

    private static RepositoryFileAcl internalUpdateAcl(Session session, PentahoJcrConstants pentahoJcrConstants, Serializable fileId, RepositoryFileAcl acl) throws RepositoryException {
        Node node = session.getNodeByIdentifier(fileId.toString());
        if (node == null) {
            throw new RepositoryException("Node not found");
        }
        String absPath = node.getPath();
        AccessControlManager acMgr = session.getAccessControlManager();
        AccessControlList acList = JcrRepositoryFileAclUtils.getAccessControlList(acMgr, absPath);
        AccessControlEntry[] acEntries = acList.getAccessControlEntries();
        for (int i = 0; i < acEntries.length; ++i) {
            acList.removeAccessControlEntry(acEntries[i]);
        }
        JcrRepositoryFileAclUtils.setAclMetadata(session, absPath, acList, new IAclMetadataStrategy.AclMetadata(acl.getOwner().getName(), acl.isEntriesInheriting()));
        if (!acl.isEntriesInheriting()) {
            for (RepositoryFileAce ace : acl.getAces()) {
                Object principal = null;
                principal = RepositoryFileSid.Type.ROLE == ace.getSid().getType() ? new SpringSecurityRolePrincipal(JcrTenantUtils.getTenantedRole(ace.getSid().getName())) : new SpringSecurityUserPrincipal(JcrTenantUtils.getTenantedUser(ace.getSid().getName()));
                DefaultPermissionConversionHelper permissionConversionHelper = new DefaultPermissionConversionHelper(session);
                acList.addAccessControlEntry((Principal)principal, permissionConversionHelper.pentahoPermissionsToPrivileges(session, ace.getPermissions()));
            }
        }
        acMgr.setPolicy(absPath, (AccessControlPolicy)acList);
        session.save();
        return JcrRepositoryFileAclUtils.getAcl(session, pentahoJcrConstants, fileId);
    }

    public static void updateAcl(Session session, RepositoryFileAcl acl) throws RepositoryException {
        PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
        JcrRepositoryFileUtils.checkoutNearestVersionableFileIfNecessary(session, pentahoJcrConstants, acl.getId());
        JcrRepositoryFileAclUtils.internalUpdateAcl(session, pentahoJcrConstants, acl.getId(), acl);
        JcrRepositoryFileUtils.checkinNearestVersionableFileIfNecessary(session, pentahoJcrConstants, acl.getId(), null, null, true);
    }

    public static RepositoryFileAcl getAcl(Session session, PentahoJcrConstants pentahoJcrConstants, Serializable id) throws RepositoryException {
        Node node = session.getNodeByIdentifier(id.toString());
        if (node == null) {
            throw new RepositoryException(Messages.getInstance().getString("JackrabbitRepositoryFileAclDao.ERROR_0001_NODE_NOT_FOUND", new Object[]{id.toString()}));
        }
        String absPath = node.getPath();
        AccessControlManager acMgr = session.getAccessControlManager();
        AccessControlList acList = JcrRepositoryFileAclUtils.getAccessControlList(acMgr, absPath);
        RepositoryFileSid owner = null;
        String ownerString = JcrTenantUtils.getUserNameUtils().getPrincipleName(JcrRepositoryFileAclUtils.getOwner(session, absPath, acList));
        if (ownerString != null) {
            owner = new RepositoryFileSid(ownerString, RepositoryFileSid.Type.USER);
        }
        RepositoryFileAcl.Builder aclBuilder = new RepositoryFileAcl.Builder(id, owner);
        aclBuilder.entriesInheriting(JcrRepositoryFileAclUtils.isEntriesInheriting(session, absPath, acList));
        List<AccessControlEntry> cleanedAcEntries = JcrRepositoryFileAclUtils.removeAclMetadata(Arrays.asList(acList.getAccessControlEntries()));
        for (AccessControlEntry acEntry : cleanedAcEntries) {
            aclBuilder.ace(JcrRepositoryFileAclUtils.toAce(session, acEntry));
        }
        return aclBuilder.build();
    }

    private static AccessControlList getAccessControlList(AccessControlManager acMgr, String path) throws RepositoryException {
        AccessControlPolicyIterator applicablePolicies = acMgr.getApplicablePolicies(path);
        while (applicablePolicies.hasNext()) {
            AccessControlPolicy policy = applicablePolicies.nextAccessControlPolicy();
            if (!(policy instanceof AccessControlList)) continue;
            return (AccessControlList)policy;
        }
        AccessControlPolicy[] policies = acMgr.getPolicies(path);
        for (int i = 0; i < policies.length; ++i) {
            if (!(policies[i] instanceof AccessControlList)) continue;
            return (AccessControlList)policies[i];
        }
        throw new IllegalStateException("no access control list applies or is bound to node");
    }

    private static String getOwner(Session session, String path, AccessControlList acList) throws RepositoryException {
        IAclMetadataStrategy.AclMetadata aclMetadata = JcrRepositoryFileAclUtils.getAclMetadata(session, path, acList);
        if (aclMetadata != null) {
            return aclMetadata.getOwner();
        }
        return null;
    }

    private static boolean isEntriesInheriting(Session session, String path, AccessControlList acList) throws RepositoryException {
        IAclMetadataStrategy.AclMetadata aclMetadata = JcrRepositoryFileAclUtils.getAclMetadata(session, path, acList);
        if (aclMetadata != null) {
            return aclMetadata.isEntriesInheriting();
        }
        return false;
    }

    private static RepositoryFileAce toAce(Session session, AccessControlEntry acEntry) throws RepositoryException {
        Principal principal = acEntry.getPrincipal();
        RepositoryFileSid sid = null;
        sid = principal instanceof Group ? new RepositoryFileSid(principal.getName(), RepositoryFileSid.Type.ROLE) : new RepositoryFileSid(principal.getName(), RepositoryFileSid.Type.USER);
        Privilege[] privileges = acEntry.getPrivileges();
        DefaultPermissionConversionHelper permissionConversionHelper = new DefaultPermissionConversionHelper(session);
        return new RepositoryFileAce(sid, permissionConversionHelper.privilegesToPentahoPermissions(session, privileges));
    }

    static {
        JcrRepositoryFileAclUtils.initialize();
    }
}

