/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.security.userroledao.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.pentaho.platform.api.engine.IUserRoleListService;
import org.pentaho.platform.api.engine.security.userroledao.IPentahoRole;
import org.pentaho.platform.api.engine.security.userroledao.IPentahoUser;
import org.pentaho.platform.api.engine.security.userroledao.IUserRoleDao;
import org.pentaho.platform.api.mt.ITenant;
import org.pentaho.platform.api.mt.ITenantedPrincipleNameResolver;
import org.pentaho.platform.repository2.unified.jcr.JcrTenantUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.UserDetailsService;
import org.springframework.security.userdetails.UsernameNotFoundException;

public class UserRoleDaoUserRoleListService
implements IUserRoleListService {
    private IUserRoleDao userRoleDao;
    private UserDetailsService userDetailsService;
    private List<String> systemRoles;
    private List<String> extraRoles;
    private String adminRole;
    private ITenantedPrincipleNameResolver usernamePrincipalResolver;

    public UserRoleDaoUserRoleListService() {
    }

    public UserRoleDaoUserRoleListService(IUserRoleDao userRoleDao, UserDetailsService userDetailsService, ITenantedPrincipleNameResolver usernamePrincipalResolver, List<String> systemRoles, List<String> extraRoles, String adminRole) {
        this.userRoleDao = userRoleDao;
        this.userDetailsService = userDetailsService;
        this.usernamePrincipalResolver = usernamePrincipalResolver;
        this.systemRoles = systemRoles;
        this.extraRoles = extraRoles;
        this.adminRole = adminRole;
    }

    private List<String> getAllRoles(List<IPentahoRole> roles) {
        ArrayList<String> auths = new ArrayList<String>(roles.size());
        for (IPentahoRole role : roles) {
            auths.add(role.getName());
        }
        if (auths.contains(this.adminRole)) {
            auths.remove(this.adminRole);
        }
        for (String extraRole : this.extraRoles) {
            if (auths.contains(extraRole)) continue;
            auths.add(extraRole);
        }
        return auths;
    }

    public List<String> getAllRoles() {
        return this.getAllRoles(this.userRoleDao.getRoles());
    }

    public List<String> getAllRoles(ITenant tenant) {
        return this.getAllRoles(this.userRoleDao.getRoles(tenant));
    }

    private List<String> getAllUsers(List<IPentahoUser> users) {
        ArrayList<String> usernames = new ArrayList<String>();
        for (IPentahoUser user : users) {
            usernames.add(user.getUsername());
        }
        return usernames;
    }

    public List<String> getAllUsers() {
        return this.getAllUsers(this.userRoleDao.getUsers());
    }

    public List<String> getAllUsers(ITenant tenant) {
        return this.getAllUsers(this.userRoleDao.getUsers(tenant));
    }

    public List<String> getRolesForUser(ITenant tenant, String username) throws UsernameNotFoundException, DataAccessException {
        String userToSearch = username;
        ITenant tenantFromUser = JcrTenantUtils.getTenant(username, true);
        if (tenantFromUser == null || tenantFromUser.getId() == null) {
            if (tenant == null || tenant.getId() == null) {
                tenant = JcrTenantUtils.getDefaultTenant();
            }
            userToSearch = this.usernamePrincipalResolver.getPrincipleId(tenant, username);
        }
        UserDetails user = this.userDetailsService.loadUserByUsername(userToSearch);
        ArrayList<String> roles = new ArrayList<String>(user.getAuthorities().length);
        for (GrantedAuthority role : user.getAuthorities()) {
            String principalName = role.getAuthority();
            roles.add(principalName);
        }
        return roles;
    }

    public List<String> getUsersInRole(ITenant tenant, IPentahoRole role, String roleName) {
        if (role == null) {
            return Collections.emptyList();
        }
        List users = null;
        ArrayList<String> usernames = new ArrayList<String>();
        users = tenant == null ? this.userRoleDao.getRoleMembers(null, roleName) : this.userRoleDao.getRoleMembers(tenant, roleName);
        for (IPentahoUser user : users) {
            usernames.add(user.getUsername());
        }
        return usernames;
    }

    public List<String> getUsersInRole(ITenant tenant, String roleName) {
        return this.getUsersInRole(tenant, this.userRoleDao.getRole(tenant, roleName), roleName);
    }

    public void setUserRoleDao(IUserRoleDao userRoleDao) {
        this.userRoleDao = userRoleDao;
    }

    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    public List<String> getSystemRoles() {
        return this.systemRoles;
    }
}

