/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.kettle;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeContext;
import org.pentaho.reporting.engine.classic.core.metadata.DataFactoryMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.DataFactoryRegistry;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.EmbeddedKettleTransformationProducer;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.KettleDataFactory;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.KettleTransformationProducer;
import org.pentaho.reporting.ui.datasources.kettle.EmbeddedKettleQueryEntry;
import org.pentaho.reporting.ui.datasources.kettle.FileKettleQueryEntry;
import org.pentaho.reporting.ui.datasources.kettle.KettleDataSourceDialog;
import org.pentaho.reporting.ui.datasources.kettle.KettleQueryEntry;
import org.pentaho.reporting.ui.datasources.kettle.Messages;

public class EmbeddedKettleDataSourceDialog
extends KettleDataSourceDialog {
    private static final long serialVersionUID = 5030572665265231736L;
    private static final Log logger = LogFactory.getLog(EmbeddedKettleDataSourceDialog.class);
    private String datasourceId = null;
    private JPanel datasourcePanel;
    private EmbeddedKettleQueryEntry lastSelectedQuery = null;

    public EmbeddedKettleDataSourceDialog(DesignTimeContext designTimeContext, JDialog parent, String id) {
        super(designTimeContext, parent);
        this.datasourceId = id;
        this.setTitle(this.getDialogTitle());
    }

    public EmbeddedKettleDataSourceDialog(DesignTimeContext designTimeContext, JFrame parent, String id) {
        super(designTimeContext, parent);
        this.datasourceId = id;
        this.setTitle(this.getDialogTitle());
    }

    public EmbeddedKettleDataSourceDialog(DesignTimeContext designTimeContext, String id) {
        super(designTimeContext);
        this.datasourceId = id;
        this.setTitle(this.getDialogTitle());
    }

    @Override
    protected JPanel createDatasourcePanel() {
        this.datasourcePanel = new JPanel(new BorderLayout());
        return this.datasourcePanel;
    }

    private void refreshQueryUIComponents() throws KettleException, ReportDataFactoryException {
        if (this.datasourcePanel.getComponentCount() <= 0) {
            EmbeddedKettleQueryEntry entry = this.createNewQueryEntry(this.findNextName());
            this.datasourcePanel.removeAll();
            this.datasourcePanel.add((Component)entry.createUI(), "Center");
            this.datasourcePanel.revalidate();
            this.setPanelEnabled(false, this.datasourcePanel);
        }
    }

    @Override
    protected String getDialogTitle() {
        if (this.datasourceId == null) {
            return "";
        }
        DataFactoryMetaData meta = DataFactoryRegistry.getInstance().getMetaData(this.datasourceId);
        String displayName = meta.getDisplayName(this.getLocale());
        return Messages.getString("KettleEmbeddedDataSourceDialog.Title", displayName);
    }

    @Override
    protected String getDialogId() {
        return "EmbeddedKettleDataSourceDialog";
    }

    @Override
    protected boolean validateInputs(boolean onConfirm) {
        KettleQueryEntry queryEntry;
        boolean valid = true;
        KettleQueryEntry[] arr$ = this.getQueryEntries();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (valid = (queryEntry = arr$[i$]).isValidated()); ++i$) {
        }
        if (!valid && onConfirm) {
            int val = JOptionPane.showConfirmDialog((Component)((Object)this), Messages.getString("EmbeddedKettleDataSourceDialog.QueryErrorWarning", new Object[0]), Messages.getString("EmbeddedKettleDataSourceDialog.QueryErrorTitle", new Object[0]), 2);
            valid = val == 0;
        }
        return valid && super.validateInputs(onConfirm);
    }

    @Override
    public KettleDataFactory performConfiguration(DesignTimeContext context, KettleDataFactory dataFactory, String queryName) throws KettleException {
        this.configureFromDataFactory(dataFactory, queryName);
        if (dataFactory == null || !dataFactory.queriesAreHomogeneous()) {
            return super.performConfiguration(context, dataFactory, queryName);
        }
        try {
            this.refreshQueryUIComponents();
            if (!this.performEdit()) {
                return null;
            }
        }
        catch (Exception e) {
            return super.performConfiguration(context, dataFactory, queryName);
        }
        KettleDataFactory kettleDataFactory = new KettleDataFactory();
        kettleDataFactory.setMetadata(dataFactory.getMetaData());
        for (KettleQueryEntry queryEntry : this.getQueryEntries()) {
            KettleTransformationProducer producer = queryEntry.createProducer();
            kettleDataFactory.setQuery(queryEntry.getName(), producer);
        }
        return kettleDataFactory;
    }

    @Override
    protected EmbeddedKettleQueryEntry createNewQueryEntry(String queryName) throws KettleException {
        EmbeddedKettleQueryEntry entry = EmbeddedKettleQueryEntry.createFromTemplate(queryName, this.datasourceId);
        entry.addPropertyChangeListener("validated", new PreviewChangeListener());
        return entry;
    }

    @Override
    protected KettleQueryEntry createQueryEntry(String queryName, KettleTransformationProducer producer) throws KettleException {
        if (this.datasourceId == null || !(producer instanceof EmbeddedKettleTransformationProducer)) {
            return new FileKettleQueryEntry(queryName);
        }
        try {
            EmbeddedKettleTransformationProducer prod = (EmbeddedKettleTransformationProducer)producer;
            EmbeddedKettleQueryEntry entry = EmbeddedKettleQueryEntry.createFromExisting(queryName, prod, this.getDesignTimeContext().getDataFactoryContext());
            entry.addPropertyChangeListener("validated", new PreviewChangeListener());
            return entry;
        }
        catch (ReportDataFactoryException e) {
            throw new KettleException((Throwable)e);
        }
    }

    @Override
    protected ListSelectionListener getQueryNameListener() {
        return new EmbeddedQueryNameListSelectionListener();
    }

    private void setPanelEnabled(boolean enable, Component c) {
        if (null == c) {
            return;
        }
        Container container = null;
        if (c instanceof Container) {
            container = (Container)c;
        }
        if (container != null) {
            Component[] components = container.getComponents();
            for (int i = 0; i < container.getComponentCount(); ++i) {
                Component component = components[i];
                this.setPanelEnabled(enable, component);
            }
        }
        c.setEnabled(enable);
    }

    @Override
    protected void clearComponents() {
        EmbeddedKettleQueryEntry kettleQueryEntry = (EmbeddedKettleQueryEntry)this.getSelectedQuery();
        kettleQueryEntry.clear();
        super.clearComponents();
    }

    private class EmbeddedQueryNameListSelectionListener
    extends KettleDataSourceDialog.QueryNameListSelectionListener {
        private EmbeddedQueryNameListSelectionListener() {
            super(EmbeddedKettleDataSourceDialog.this);
        }

        @Override
        protected void handleSelection(KettleQueryEntry value) {
            if (value == null) {
                EmbeddedKettleDataSourceDialog.this.setPanelEnabled(false, EmbeddedKettleDataSourceDialog.this.datasourcePanel);
                EmbeddedKettleDataSourceDialog.this.lastSelectedQuery = null;
                return;
            }
            DesignTimeContext designTimeContext = EmbeddedKettleDataSourceDialog.this.getDesignTimeContext();
            Action editParameterAction = EmbeddedKettleDataSourceDialog.this.getEditParameterAction();
            try {
                EmbeddedKettleQueryEntry selectedQuery = (EmbeddedKettleQueryEntry)value;
                EmbeddedKettleDataSourceDialog.this.setPanelEnabled(true, EmbeddedKettleDataSourceDialog.this.datasourcePanel);
                if (EmbeddedKettleDataSourceDialog.this.lastSelectedQuery == null || selectedQuery != EmbeddedKettleDataSourceDialog.this.lastSelectedQuery) {
                    EmbeddedKettleDataSourceDialog.this.lastSelectedQuery = selectedQuery;
                    EmbeddedKettleDataSourceDialog.this.updateQueryName(selectedQuery.getName());
                    EmbeddedKettleDataSourceDialog.this.datasourcePanel.removeAll();
                    EmbeddedKettleDataSourceDialog.this.datasourcePanel.add((Component)selectedQuery.createUI(), "Center");
                    EmbeddedKettleDataSourceDialog.this.datasourcePanel.revalidate();
                    EmbeddedKettleDataSourceDialog.this.datasourcePanel.repaint();
                }
                EmbeddedKettleDataSourceDialog.this.getStopOnErrorsCheckBox().setSelected(selectedQuery.isStopOnErrors());
                editParameterAction.setEnabled(true);
            }
            catch (Exception e1) {
                designTimeContext.error(e1);
                editParameterAction.setEnabled(false);
            }
            catch (Throwable t1) {
                designTimeContext.error((Exception)new RuntimeException("Fatal error", t1));
                editParameterAction.setEnabled(false);
            }
        }
    }

    protected class PreviewChangeListener
    implements PropertyChangeListener {
        protected PreviewChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("validated")) {
                if (EmbeddedKettleDataSourceDialog.this.lastSelectedQuery == null) {
                    EmbeddedKettleDataSourceDialog.this.getPreviewAction().setEnabled(false);
                } else {
                    EmbeddedKettleDataSourceDialog.this.getPreviewAction().setEnabled(Boolean.TRUE.equals(evt.getNewValue()));
                }
            }
        }
    }
}

