/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.validate;

import org.eigenbase.reltype.RelDataType;
import org.eigenbase.resource.EigenbaseResource;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.validate.AbstractNamespace;
import org.eigenbase.sql.validate.SqlValidatorImpl;
import org.eigenbase.sql.validate.SqlValidatorScope;
import org.eigenbase.util.Util;

public class SetopNamespace
extends AbstractNamespace {
    private final SqlCall call;

    protected SetopNamespace(SqlValidatorImpl validator, SqlCall call, SqlNode enclosingNode) {
        super(validator, enclosingNode);
        this.call = call;
    }

    public SqlNode getNode() {
        return this.call;
    }

    public RelDataType validateImpl() {
        switch (this.call.getKind()) {
            case UNION: 
            case INTERSECT: 
            case EXCEPT: {
                SqlValidatorScope scope = this.validator.scopes.get(this.call);
                for (SqlNode operand : this.call.getOperandList()) {
                    if (!operand.isA(SqlKind.QUERY)) {
                        throw this.validator.newValidationError(operand, EigenbaseResource.instance().NeedQueryOp.ex(operand.toString()));
                    }
                    this.validator.validateQuery(operand, scope);
                }
                return this.call.getOperator().validateOperands(this.validator, scope, this.call);
            }
        }
        throw Util.newInternal("Not a query: " + (Object)((Object)this.call.getKind()));
    }
}

