/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql2rel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import net.hydromatic.linq4j.function.Function1;
import org.eigenbase.rel.AggregateRel;
import org.eigenbase.rel.CalcRel;
import org.eigenbase.rel.CollectRel;
import org.eigenbase.rel.CorrelatorRel;
import org.eigenbase.rel.FilterRel;
import org.eigenbase.rel.IntersectRel;
import org.eigenbase.rel.JoinRel;
import org.eigenbase.rel.MinusRel;
import org.eigenbase.rel.OneRowRel;
import org.eigenbase.rel.ProjectRel;
import org.eigenbase.rel.RelCollation;
import org.eigenbase.rel.RelFieldCollation;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelVisitor;
import org.eigenbase.rel.SamplingRel;
import org.eigenbase.rel.SortRel;
import org.eigenbase.rel.TableAccessRel;
import org.eigenbase.rel.TableFunctionRel;
import org.eigenbase.rel.TableModificationRel;
import org.eigenbase.rel.UncollectRel;
import org.eigenbase.rel.UnionRel;
import org.eigenbase.rel.ValuesRel;
import org.eigenbase.relopt.Convention;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptTable;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexCorrelVariable;
import org.eigenbase.rex.RexFieldAccess;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexLocalRef;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexProgram;
import org.eigenbase.rex.RexProgramBuilder;
import org.eigenbase.rex.RexShuttle;
import org.eigenbase.rex.RexUtil;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.sql.type.SqlTypeUtil;
import org.eigenbase.util.ReflectUtil;
import org.eigenbase.util.ReflectiveVisitDispatcher;
import org.eigenbase.util.ReflectiveVisitor;
import org.eigenbase.util.Util;
import org.eigenbase.util.mapping.Mappings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelStructuredTypeFlattener
implements ReflectiveVisitor {
    private final RexBuilder rexBuilder;
    private final RewriteRelVisitor visitor;
    private Map<RelNode, RelNode> oldToNewRelMap;
    private RelNode currentRel;
    private int iRestructureInput;
    private RelDataType flattenedRootType;
    boolean restructured;
    private final RelOptTable.ToRelContext toRelContext;

    public RelStructuredTypeFlattener(RexBuilder rexBuilder) {
        this.rexBuilder = rexBuilder;
        this.visitor = new RewriteRelVisitor();
        this.toRelContext = null;
    }

    public void updateRelInMap(Map<RelNode, SortedSet<CorrelatorRel.Correlation>> mapRefRelToCorVar) {
        HashSet<RelNode> oldRefRelSet = new HashSet<RelNode>();
        oldRefRelSet.addAll(mapRefRelToCorVar.keySet());
        for (RelNode rel : oldRefRelSet) {
            if (!this.oldToNewRelMap.containsKey(rel)) continue;
            TreeSet corVarSet = new TreeSet();
            corVarSet.addAll(mapRefRelToCorVar.get(rel));
            mapRefRelToCorVar.remove(rel);
            mapRefRelToCorVar.put(this.oldToNewRelMap.get(rel), corVarSet);
        }
    }

    public void updateRelInMap(SortedMap<CorrelatorRel.Correlation, CorrelatorRel> mapCorVarToCorRel) {
        for (CorrelatorRel.Correlation corVar : mapCorVarToCorRel.keySet()) {
            CorrelatorRel oldRel = (CorrelatorRel)mapCorVarToCorRel.get(corVar);
            if (!this.oldToNewRelMap.containsKey(oldRel)) continue;
            RelNode newRel = this.oldToNewRelMap.get(oldRel);
            assert (newRel instanceof CorrelatorRel);
            mapCorVarToCorRel.put(corVar, (CorrelatorRel)newRel);
        }
    }

    public RelNode rewrite(RelNode root, boolean restructure) {
        this.oldToNewRelMap = new HashMap<RelNode, RelNode>();
        this.visitor.visit(root, 0, null);
        RelNode flattened = this.getNewForOldRel(root);
        this.flattenedRootType = flattened.getRowType();
        this.restructured = false;
        List<RexNode> structuringExps = null;
        if (restructure) {
            this.iRestructureInput = 0;
            structuringExps = this.restructureFields(root.getRowType());
        }
        if (this.restructured) {
            return CalcRel.createProject(flattened, structuringExps, root.getRowType().getFieldNames());
        }
        return flattened;
    }

    private List<RexNode> restructureFields(RelDataType structuredType) {
        ArrayList<RexNode> structuringExps = new ArrayList<RexNode>();
        for (RelDataTypeField field : structuredType.getFieldList()) {
            if (field.getType().getSqlTypeName() == SqlTypeName.STRUCTURED) {
                this.restructured = true;
                structuringExps.add(this.restructure(field.getType()));
                continue;
            }
            structuringExps.add(new RexInputRef(this.iRestructureInput, field.getType()));
            ++this.iRestructureInput;
        }
        return structuringExps;
    }

    private RexNode restructure(RelDataType structuredType) {
        RexInputRef nullIndicator = RexInputRef.of(this.iRestructureInput++, this.flattenedRootType.getFieldList());
        List<RexNode> inputExprs = this.restructureFields(structuredType);
        RexNode newInvocation = this.rexBuilder.makeNewInvocation(structuredType, inputExprs);
        if (!structuredType.isNullable()) {
            return newInvocation;
        }
        RexNode[] caseOperands = new RexNode[]{this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, nullIndicator), this.rexBuilder.makeCast(structuredType, this.rexBuilder.constantNull()), newInvocation};
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, caseOperands);
    }

    protected void setNewForOldRel(RelNode oldRel, RelNode newRel) {
        this.oldToNewRelMap.put(oldRel, newRel);
    }

    protected RelNode getNewForOldRel(RelNode oldRel) {
        return this.oldToNewRelMap.get(oldRel);
    }

    protected int getNewForOldInput(int oldOrdinal) {
        assert (this.currentRel != null);
        int newOrdinal = 0;
        RelNode oldInput = null;
        for (RelNode oldInput1 : this.currentRel.getInputs()) {
            RelDataType oldInputType = oldInput1.getRowType();
            int n = oldInputType.getFieldCount();
            if (oldOrdinal < n) {
                oldInput = oldInput1;
                break;
            }
            RelNode newInput = this.getNewForOldRel(oldInput1);
            newOrdinal += newInput.getRowType().getFieldCount();
            oldOrdinal -= n;
        }
        assert (oldInput != null);
        RelDataType oldInputType = oldInput.getRowType();
        return newOrdinal += this.calculateFlattenedOffset(oldInputType, oldOrdinal);
    }

    private Mappings.TargetMapping getNewForOldInputMapping(RelNode oldRel) {
        RelNode newRel = this.getNewForOldRel(oldRel);
        return Mappings.target(new Function1<Integer, Integer>(){

            public Integer apply(Integer oldInput) {
                return RelStructuredTypeFlattener.this.getNewForOldInput(oldInput);
            }
        }, oldRel.getRowType().getFieldCount(), newRel.getRowType().getFieldCount());
    }

    private int calculateFlattenedOffset(RelDataType rowType, int ordinal) {
        int offset = 0;
        if (SqlTypeUtil.needsNullIndicator(rowType)) {
            ++offset;
        }
        List<RelDataTypeField> oldFields = rowType.getFieldList();
        for (int i = 0; i < ordinal; ++i) {
            RelDataType oldFieldType = oldFields.get(i).getType();
            if (oldFieldType.isStruct()) {
                RelDataType flattened = SqlTypeUtil.flattenRecordType(this.rexBuilder.getTypeFactory(), oldFieldType, null);
                List<RelDataTypeField> fields = flattened.getFieldList();
                offset += fields.size();
                continue;
            }
            ++offset;
        }
        return offset;
    }

    protected RexNode flattenFieldAccesses(RexNode exp) {
        RewriteRexShuttle shuttle = new RewriteRexShuttle();
        return exp.accept(shuttle);
    }

    public void rewriteRel(TableModificationRel rel) {
        TableModificationRel newRel = new TableModificationRel(rel.getCluster(), rel.getTable(), rel.getCatalogReader(), this.getNewForOldRel(rel.getChild()), rel.getOperation(), rel.getUpdateColumnList(), true);
        this.setNewForOldRel(rel, newRel);
    }

    public void rewriteRel(AggregateRel rel) {
        RelDataType inputType = rel.getChild().getRowType();
        for (RelDataTypeField field : inputType.getFieldList()) {
            if (!field.getType().isStruct()) continue;
            throw Util.needToImplement("aggregation on structured types");
        }
        this.rewriteGeneric(rel);
    }

    public void rewriteRel(SortRel rel) {
        RelCollation oldCollation = rel.getCollation();
        RelNode oldChild = rel.getChild();
        RelNode newChild = this.getNewForOldRel(oldChild);
        Mappings.TargetMapping mapping = this.getNewForOldInputMapping(oldChild);
        for (RelFieldCollation field : oldCollation.getFieldCollations()) {
            int oldInput = field.getFieldIndex();
            RelDataType sortFieldType = oldChild.getRowType().getFieldList().get(oldInput).getType();
            if (!sortFieldType.isStruct()) continue;
            throw Util.needToImplement("sorting on structured types");
        }
        SortRel newRel = new SortRel(rel.getCluster(), rel.getCluster().traitSetOf(Convention.NONE), newChild, RexUtil.apply(mapping, oldCollation));
        this.setNewForOldRel(rel, newRel);
    }

    public void rewriteRel(FilterRel rel) {
        RelNode newRel = CalcRel.createFilter(this.getNewForOldRel(rel.getChild()), this.flattenFieldAccesses(rel.getCondition()));
        this.setNewForOldRel(rel, newRel);
    }

    public void rewriteRel(JoinRel rel) {
        JoinRel newRel = new JoinRel(rel.getCluster(), this.getNewForOldRel(rel.getLeft()), this.getNewForOldRel(rel.getRight()), this.flattenFieldAccesses(rel.getCondition()), rel.getJoinType(), rel.getVariablesStopped());
        this.setNewForOldRel(rel, newRel);
    }

    public void rewriteRel(CorrelatorRel rel) {
        ArrayList<CorrelatorRel.Correlation> newCorrelations = new ArrayList<CorrelatorRel.Correlation>();
        for (CorrelatorRel.Correlation c : rel.getCorrelations()) {
            RelDataType corrFieldType = rel.getLeft().getRowType().getFieldList().get(c.getOffset()).getType();
            if (corrFieldType.isStruct()) {
                throw Util.needToImplement("correlation on structured type");
            }
            newCorrelations.add(new CorrelatorRel.Correlation(c.getId(), this.getNewForOldInput(c.getOffset())));
        }
        CorrelatorRel newRel = new CorrelatorRel(rel.getCluster(), this.getNewForOldRel(rel.getLeft()), this.getNewForOldRel(rel.getRight()), rel.getCondition(), newCorrelations, rel.getJoinType());
        this.setNewForOldRel(rel, newRel);
    }

    public void rewriteRel(CollectRel rel) {
        this.rewriteGeneric(rel);
    }

    public void rewriteRel(UncollectRel rel) {
        this.rewriteGeneric(rel);
    }

    public void rewriteRel(IntersectRel rel) {
        this.rewriteGeneric(rel);
    }

    public void rewriteRel(MinusRel rel) {
        this.rewriteGeneric(rel);
    }

    public void rewriteRel(UnionRel rel) {
        this.rewriteGeneric(rel);
    }

    public void rewriteRel(OneRowRel rel) {
        this.rewriteGeneric(rel);
    }

    public void rewriteRel(ValuesRel rel) {
        this.rewriteGeneric(rel);
    }

    public void rewriteRel(TableFunctionRel rel) {
        this.rewriteGeneric(rel);
    }

    public void rewriteRel(SamplingRel rel) {
        this.rewriteGeneric(rel);
    }

    public void rewriteRel(ProjectRel rel) {
        ArrayList<RexNode> flattenedExpList = new ArrayList<RexNode>();
        ArrayList<String> flattenedFieldNameList = new ArrayList<String>();
        List<String> fieldNames = rel.getRowType().getFieldNames();
        this.flattenProjections(rel.getProjects(), fieldNames, "", flattenedExpList, flattenedFieldNameList);
        RelNode newRel = CalcRel.createProject(this.getNewForOldRel(rel.getChild()), flattenedExpList, flattenedFieldNameList);
        this.setNewForOldRel(rel, newRel);
    }

    public void rewriteRel(CalcRel rel) {
        RelNode newChild = this.getNewForOldRel(rel.getChild());
        RelOptCluster cluster = rel.getCluster();
        RexProgramBuilder programBuilder = new RexProgramBuilder(newChild.getRowType(), cluster.getRexBuilder());
        RexProgram program = rel.getProgram();
        for (RexNode expr : program.getExprList()) {
            programBuilder.registerInput(this.flattenFieldAccesses(expr));
        }
        ArrayList<RexNode> flattenedExpList = new ArrayList<RexNode>();
        ArrayList<String> flattenedFieldNameList = new ArrayList<String>();
        List<String> fieldNames = rel.getRowType().getFieldNames();
        this.flattenProjections(program.getProjectList(), fieldNames, "", flattenedExpList, flattenedFieldNameList);
        int i = -1;
        for (RexNode flattenedExp : flattenedExpList) {
            programBuilder.addProject(flattenedExp, (String)flattenedFieldNameList.get(++i));
        }
        RexLocalRef conditionRef = program.getCondition();
        if (conditionRef != null) {
            programBuilder.addCondition(new RexLocalRef(this.getNewForOldInput(conditionRef.getIndex()), conditionRef.getType()));
        }
        RexProgram newProgram = programBuilder.getProgram();
        CalcRel newRel = new CalcRel(cluster, rel.getTraitSet(), newChild, newProgram.getOutputRowType(), newProgram, Collections.<RelCollation>emptyList());
        this.setNewForOldRel(rel, newRel);
    }

    public void rewriteRel(SelfFlatteningRel rel) {
        rel.flattenRel(this);
    }

    public void rewriteGeneric(RelNode rel) {
        RelNode newRel = rel.copy(rel.getTraitSet(), rel.getInputs());
        List<RelNode> oldInputs = rel.getInputs();
        for (int i = 0; i < oldInputs.size(); ++i) {
            newRel.replaceInput(i, this.getNewForOldRel(oldInputs.get(i)));
        }
        this.setNewForOldRel(rel, newRel);
    }

    private void flattenProjections(List<? extends RexNode> exps, List<String> fieldNames, String prefix, List<RexNode> flattenedExps, List<String> flattenedFieldNames) {
        for (int i = 0; i < exps.size(); ++i) {
            String fieldName;
            RexNode exp = exps.get(i);
            String string = fieldName = fieldNames == null || fieldNames.get(i) == null ? "$" + i : fieldNames.get(i);
            if (!prefix.equals("")) {
                fieldName = prefix + "$" + fieldName;
            }
            this.flattenProjection(exp, fieldName, flattenedExps, flattenedFieldNames);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void flattenProjection(RexNode exp, String fieldName, List<RexNode> flattenedExps, List<String> flattenedFieldNames) {
        if (exp.getType().isStruct()) {
            if (exp instanceof RexInputRef) {
                RexInputRef inputRef = (RexInputRef)exp;
                int newOffset = this.getNewForOldInput(inputRef.getIndex());
                RelDataType flattenedType = SqlTypeUtil.flattenRecordType(this.rexBuilder.getTypeFactory(), exp.getType(), null);
                List<RelDataTypeField> fieldList = flattenedType.getFieldList();
                int n = fieldList.size();
                for (int j = 0; j < n; ++j) {
                    RelDataTypeField field = fieldList.get(j);
                    flattenedExps.add(new RexInputRef(newOffset + j, field.getType()));
                    flattenedFieldNames.add(fieldName);
                }
                return;
            } else if (this.isConstructor(exp) || exp.isA(SqlKind.CAST)) {
                RexCall call = (RexCall)exp;
                if (exp.isA(SqlKind.NEW_SPECIFICATION)) {
                    flattenedExps.add(this.rexBuilder.makeLiteral(false));
                    flattenedFieldNames.add(fieldName);
                } else if (exp.isA(SqlKind.CAST) && RexLiteral.isNullLiteral((RexNode)((RexCall)exp).operands.get(0))) {
                    this.flattenNullLiteral(exp.getType(), flattenedExps, flattenedFieldNames);
                    return;
                }
                this.flattenProjections(call.getOperands(), Collections.nCopies(call.getOperands().size(), null), fieldName, flattenedExps, flattenedFieldNames);
                return;
            } else {
                if (!(exp instanceof RexCall)) throw Util.needToImplement(exp);
                int j = 0;
                for (RelDataTypeField field : exp.getType().getFieldList()) {
                    flattenedExps.add(this.rexBuilder.makeFieldAccess(exp, field.getIndex()));
                    flattenedFieldNames.add(fieldName + "$" + j++);
                }
            }
            return;
        } else {
            exp = this.flattenFieldAccesses(exp);
            flattenedExps.add(exp);
            flattenedFieldNames.add(fieldName);
        }
    }

    private void flattenNullLiteral(RelDataType type, List<RexNode> flattenedExps, List<String> flattenedFieldNames) {
        RelDataType flattenedType = SqlTypeUtil.flattenRecordType(this.rexBuilder.getTypeFactory(), type, null);
        for (RelDataTypeField field : flattenedType.getFieldList()) {
            flattenedExps.add(this.rexBuilder.makeCast(field.getType(), this.rexBuilder.constantNull()));
            flattenedFieldNames.add(field.getName());
        }
    }

    private boolean isConstructor(RexNode rexNode) {
        if (!(rexNode instanceof RexCall)) {
            return false;
        }
        RexCall call = (RexCall)rexNode;
        return call.getOperator().getName().equalsIgnoreCase("row") || call.isA(SqlKind.NEW_SPECIFICATION);
    }

    public void rewriteRel(TableAccessRel rel) {
        RelNode newRel = rel.getTable().toRel(this.toRelContext);
        this.setNewForOldRel(rel, newRel);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RewriteRexShuttle
    extends RexShuttle {
        private RewriteRexShuttle() {
        }

        @Override
        public RexNode visitInputRef(RexInputRef input) {
            int oldIndex = input.getIndex();
            int newIndex = RelStructuredTypeFlattener.this.getNewForOldInput(oldIndex);
            RelDataType fieldType = this.removeDistinct(input.getType());
            RexInputRef newInput = new RexInputRef(newIndex, fieldType);
            return newInput;
        }

        private RelDataType removeDistinct(RelDataType type) {
            if (type.getSqlTypeName() != SqlTypeName.DISTINCT) {
                return type;
            }
            return type.getFieldList().get(0).getType();
        }

        @Override
        public RexNode visitFieldAccess(RexFieldAccess fieldAccess) {
            int iInput = 0;
            RelDataType fieldType = this.removeDistinct(fieldAccess.getType());
            while (true) {
                RexNode refExp = fieldAccess.getReferenceExpr();
                int ordinal = fieldAccess.getField().getIndex();
                iInput += RelStructuredTypeFlattener.this.calculateFlattenedOffset(refExp.getType(), ordinal);
                if (refExp instanceof RexInputRef) {
                    RexInputRef inputRef = (RexInputRef)refExp;
                    return new RexInputRef(iInput += RelStructuredTypeFlattener.this.getNewForOldInput(inputRef.getIndex()), fieldType);
                }
                if (refExp instanceof RexCorrelVariable) {
                    return fieldAccess;
                }
                if (refExp.isA(SqlKind.CAST)) {
                    RexCall cast = (RexCall)refExp;
                    refExp = cast.getOperands().get(0);
                }
                if (refExp.isA(SqlKind.NEW_SPECIFICATION)) {
                    return (RexNode)((RexCall)refExp).operands.get(fieldAccess.getField().getIndex());
                }
                if (!(refExp instanceof RexFieldAccess)) {
                    throw Util.needToImplement(refExp);
                }
                fieldAccess = (RexFieldAccess)refExp;
            }
        }

        @Override
        public RexNode visitCall(RexCall rexCall) {
            if (rexCall.isA(SqlKind.CAST)) {
                RexNode input = rexCall.getOperands().get(0).accept(this);
                RelDataType targetType = this.removeDistinct(rexCall.getType());
                return RelStructuredTypeFlattener.this.rexBuilder.makeCast(targetType, input);
            }
            if (!rexCall.isA(SqlKind.COMPARISON)) {
                return super.visitCall(rexCall);
            }
            RexNode lhs = rexCall.getOperands().get(0);
            if (!lhs.getType().isStruct()) {
                return super.visitCall(rexCall);
            }
            return this.flattenComparison(RelStructuredTypeFlattener.this.rexBuilder, rexCall.getOperator(), rexCall.getOperands());
        }

        private RexNode flattenComparison(RexBuilder rexBuilder, SqlOperator op, List<RexNode> exprs) {
            ArrayList flattenedExps = new ArrayList();
            RelStructuredTypeFlattener.this.flattenProjections(exprs, null, "", flattenedExps, new ArrayList());
            int n = flattenedExps.size() / 2;
            boolean negate = false;
            if (op.getKind() == SqlKind.NOT_EQUALS) {
                negate = true;
                op = SqlStdOperatorTable.EQUALS;
            }
            if (n > 1 && op.getKind() != SqlKind.EQUALS) {
                throw Util.needToImplement("inequality comparison for row types");
            }
            RexNode conjunction = null;
            for (int i = 0; i < n; ++i) {
                RexNode comparison = rexBuilder.makeCall(op, (RexNode)flattenedExps.get(i), (RexNode)flattenedExps.get(i + n));
                conjunction = conjunction == null ? comparison : rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, conjunction, comparison);
            }
            if (negate) {
                return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, conjunction);
            }
            return conjunction;
        }
    }

    private class RewriteRelVisitor
    extends RelVisitor {
        private final ReflectiveVisitDispatcher<RelStructuredTypeFlattener, RelNode> dispatcher = ReflectUtil.createDispatcher(RelStructuredTypeFlattener.class, RelNode.class);

        private RewriteRelVisitor() {
        }

        public void visit(RelNode p, int ordinal, RelNode parent) {
            super.visit(p, ordinal, parent);
            RelStructuredTypeFlattener.this.currentRel = p;
            String visitMethodName = "rewriteRel";
            boolean found = this.dispatcher.invokeVisitor(RelStructuredTypeFlattener.this, RelStructuredTypeFlattener.this.currentRel, "rewriteRel");
            RelStructuredTypeFlattener.this.currentRel = null;
            if (!found && p.getInputs().size() == 0) {
                RelStructuredTypeFlattener.this.rewriteGeneric(p);
            }
            if (!found) {
                throw Util.newInternal("no 'rewriteRel' method found for class " + p.getClass().getName());
            }
        }
    }

    public static interface SelfFlatteningRel
    extends RelNode {
        public void flattenRel(RelStructuredTypeFlattener var1);
    }
}

