/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.util;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;

public abstract class StringChunker {
    private static final int DEFAULT_CHUNK_SIZE = 32000;
    private static final Logger LOGGER = Logger.getLogger("org.eigenbase.util.StringChunker");

    public static String[] slice(String input, int maxLen) {
        if ("".equals(input)) {
            return new String[]{input};
        }
        String[] results = new String[StringChunker.countChunks(input.length(), maxLen)];
        int offset = 0;
        int rowNum = 0;
        while (offset < input.length()) {
            String temp;
            results[rowNum] = temp = input.substring(offset, Math.min(offset + maxLen, input.length()));
            offset += maxLen;
            ++rowNum;
        }
        return results;
    }

    public static String[] slice(String input) {
        return StringChunker.slice(input, 32000);
    }

    public static final int countChunks(int wholeSize, int chunkSize) {
        if (wholeSize == 0) {
            wholeSize = 1;
        }
        int result = wholeSize / chunkSize;
        if (wholeSize % chunkSize != 0) {
            ++result;
        }
        return result;
    }

    public static int writeChunks(String[] chunks, PreparedStatement ps, int startIdx) throws SQLException {
        int idx = startIdx;
        for (String chunk : chunks) {
            ps.setInt(1, idx);
            ps.setString(2, chunk);
            ps.executeUpdate();
            ++idx;
        }
        return idx - startIdx;
    }

    public static int writeChunks(String[] chunks, PreparedStatement ps) throws SQLException {
        return StringChunker.writeChunks(chunks, ps, 0);
    }

    public static String readChunks(ResultSet rs, int columnIndex) throws SQLException {
        int chunkCount = 0;
        StringBuilder sb = new StringBuilder(32000);
        String chunk = null;
        while (rs.next()) {
            chunk = rs.getString(columnIndex);
            sb.append(chunk);
            ++chunkCount;
        }
        return sb.toString();
    }

    public static String readChunks(ResultSet rs) throws SQLException {
        return StringChunker.readChunks(rs, 1);
    }
}

