/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupBody;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.function.ProcessingContext;
import org.pentaho.reporting.engine.classic.core.layout.DefaultRenderComponentFactory;
import org.pentaho.reporting.engine.classic.core.layout.FileModelPrinter;
import org.pentaho.reporting.engine.classic.core.layout.InlineSubreportMarker;
import org.pentaho.reporting.engine.classic.core.layout.ModelPrinter;
import org.pentaho.reporting.engine.classic.core.layout.RenderComponentFactory;
import org.pentaho.reporting.engine.classic.core.layout.Renderer;
import org.pentaho.reporting.engine.classic.core.layout.build.LayoutModelBuilder;
import org.pentaho.reporting.engine.classic.core.layout.build.RenderModelBuilder;
import org.pentaho.reporting.engine.classic.core.layout.build.ReportRenderModelBuilder;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.output.ContentProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.LayoutPagebreakHandler;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessor;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.output.ValidateSafeToStoreStateStep;
import org.pentaho.reporting.engine.classic.core.layout.process.ApplyAutoCommitStep;
import org.pentaho.reporting.engine.classic.core.layout.process.ApplyCachedValuesStep;
import org.pentaho.reporting.engine.classic.core.layout.process.ApplyCommitStep;
import org.pentaho.reporting.engine.classic.core.layout.process.CanvasMajorAxisLayoutStep;
import org.pentaho.reporting.engine.classic.core.layout.process.CanvasMinorAxisLayoutStep;
import org.pentaho.reporting.engine.classic.core.layout.process.CommitStep;
import org.pentaho.reporting.engine.classic.core.layout.process.ComputeStaticPropertiesProcessStep;
import org.pentaho.reporting.engine.classic.core.layout.process.InfiniteMajorAxisLayoutStep;
import org.pentaho.reporting.engine.classic.core.layout.process.InfiniteMinorAxisLayoutStep;
import org.pentaho.reporting.engine.classic.core.layout.process.ParagraphLineBreakStep;
import org.pentaho.reporting.engine.classic.core.layout.process.RollbackStep;
import org.pentaho.reporting.engine.classic.core.layout.process.TableValidationStep;
import org.pentaho.reporting.engine.classic.core.layout.process.ValidateModelStep;
import org.pentaho.reporting.engine.classic.core.states.PerformanceMonitorContext;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;
import org.pentaho.reporting.engine.classic.core.states.process.ProcessState;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.libraries.base.util.ArgumentNullException;
import org.pentaho.reporting.libraries.base.util.PerformanceLoggingStopWatch;

public abstract class AbstractRenderer
implements Renderer {
    private static final Log logger = LogFactory.getLog(AbstractRenderer.class);
    private RenderModelBuilder renderModelBuilder;
    private ValidateModelStep validateModelStep;
    private ComputeStaticPropertiesProcessStep staticPropertiesStep;
    private ParagraphLineBreakStep paragraphLineBreakStep;
    private InfiniteMinorAxisLayoutStep minorAxisLayoutStep;
    private CanvasMinorAxisLayoutStep canvasMinorAxisLayoutStep;
    private InfiniteMajorAxisLayoutStep majorAxisLayoutStep;
    private CanvasMajorAxisLayoutStep canvasMajorAxisLayoutStep;
    private ValidateSafeToStoreStateStep validateSafeToStoreStateStep;
    private TableValidationStep tableValidationStep;
    private CommitStep commitStep;
    private ApplyCommitStep applyCommitStep;
    private RollbackStep rollbackStep;
    private ApplyAutoCommitStep applyAutoCommitStep;
    private OutputProcessor outputProcessor;
    private int pagebreaks;
    private boolean dirty;
    private ReportStateKey lastStateKey;
    private ApplyCachedValuesStep applyCachedValuesStep;
    private boolean readOnly;
    private boolean paranoidChecks;
    private boolean wrapProgressMarkerInSection;
    private Renderer.LayoutResult lastValidateResult;
    private PerformanceLoggingStopWatch validateStopWatch;
    private PerformanceLoggingStopWatch paginateStopWatch;
    private PerformanceMonitorContext performanceMonitorContext;

    protected AbstractRenderer(OutputProcessor outputProcessor) {
        this.outputProcessor = outputProcessor;
        this.validateModelStep = new ValidateModelStep();
        this.staticPropertiesStep = new ComputeStaticPropertiesProcessStep();
        this.paragraphLineBreakStep = new ParagraphLineBreakStep();
        this.minorAxisLayoutStep = new InfiniteMinorAxisLayoutStep();
        this.canvasMinorAxisLayoutStep = new CanvasMinorAxisLayoutStep();
        this.majorAxisLayoutStep = new InfiniteMajorAxisLayoutStep();
        this.canvasMajorAxisLayoutStep = new CanvasMajorAxisLayoutStep();
        this.validateSafeToStoreStateStep = new ValidateSafeToStoreStateStep();
        this.applyCachedValuesStep = new ApplyCachedValuesStep();
        this.commitStep = new CommitStep();
        this.applyAutoCommitStep = new ApplyAutoCommitStep();
        this.applyCommitStep = new ApplyCommitStep();
        this.rollbackStep = new RollbackStep();
        this.tableValidationStep = new TableValidationStep();
    }

    protected void initialize() {
        this.renderModelBuilder = this.createRenderModelBuilder();
    }

    protected ReportRenderModelBuilder createRenderModelBuilder() {
        return new ReportRenderModelBuilder(this.createComponentFactory());
    }

    protected RenderComponentFactory createComponentFactory() {
        return new DefaultRenderComponentFactory();
    }

    @Override
    public LayoutModelBuilder getNormalFlowLayoutModelBuilder() {
        return this.renderModelBuilder.getNormalFlowLayoutModelBuilder();
    }

    @Override
    public int getPageCount() {
        return 0;
    }

    protected RenderModelBuilder getRenderModelBuilder() {
        return this.renderModelBuilder;
    }

    protected LogicalPageBox getPageBox() {
        return this.renderModelBuilder.getPageBox();
    }

    @Override
    public boolean isSafeToStore() {
        LogicalPageBox pageBox = this.getPageBox();
        if (pageBox == null) {
            return true;
        }
        return this.validateSafeToStoreStateStep.isSafeToStore(pageBox);
    }

    protected OutputProcessorMetaData getMetaData() {
        return this.getOutputProcessor().getMetaData();
    }

    @Override
    public void setStateKey(ReportStateKey stateKey) {
        this.renderModelBuilder.updateStateKey(stateKey);
    }

    @Override
    public OutputProcessor getOutputProcessor() {
        return this.outputProcessor;
    }

    protected boolean isWidowOrphanDefinitionsEncountered() {
        return this.staticPropertiesStep.isWidowOrphanDefinitionsEncountered();
    }

    @Override
    public void startReport(ReportDefinition report, ProcessingContext processingContext, PerformanceMonitorContext performanceMonitorContext) {
        ArgumentNullException.validate((String)"report", (Object)report);
        ArgumentNullException.validate((String)"processingContext", (Object)processingContext);
        ArgumentNullException.validate((String)"performanceMonitorContext", (Object)performanceMonitorContext);
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        this.performanceMonitorContext = performanceMonitorContext;
        this.performanceMonitorContext.addChangeListener(new CloseListener());
        this.validateStopWatch = performanceMonitorContext.createStopWatch("pentaho.report.processing.layout.validate");
        this.paginateStopWatch = performanceMonitorContext.createStopWatch("pentaho.report.processing.layout.processpage");
        this.majorAxisLayoutStep.initializePerformanceMonitoring(performanceMonitorContext);
        this.canvasMajorAxisLayoutStep.initializePerformanceMonitoring(performanceMonitorContext);
        this.minorAxisLayoutStep.initializePerformanceMonitoring(performanceMonitorContext);
        this.canvasMinorAxisLayoutStep.initializePerformanceMonitoring(performanceMonitorContext);
        this.outputProcessor.processingStarted(report, processingContext);
        this.initializeRendererOnStartReport(processingContext);
        this.renderModelBuilder.startReport(report, processingContext);
        this.markDirty();
    }

    protected void initializeRendererOnStartReport(ProcessingContext processingContext) {
        OutputProcessorMetaData metaData = this.getMetaData();
        this.paranoidChecks = "true".equals(metaData.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.layout.ParanoidChecks")) && !processingContext.getOutputProcessorMetaData().isFeatureSupported(OutputProcessorFeature.DESIGNTIME);
        this.wrapProgressMarkerInSection = "true".equals(metaData.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.legacy.WrapProgressMarkerInSection"));
        this.staticPropertiesStep.initialize(metaData, processingContext);
        this.canvasMinorAxisLayoutStep.initialize(metaData, processingContext);
        this.minorAxisLayoutStep.initialize(metaData);
        this.canvasMajorAxisLayoutStep.initialize(metaData);
        this.majorAxisLayoutStep.initialize(metaData);
    }

    @Override
    public void startSubReport(ReportDefinition report, InstanceID insertationPoint) {
        if (this.readOnly) {
            throw new IllegalStateException("Renderer is marked read-only");
        }
        this.renderModelBuilder.startSubReport(report, insertationPoint);
    }

    @Override
    public void startGroup(Group group, Integer predictedStateCount) {
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        this.renderModelBuilder.startGroup(group, 5);
    }

    @Override
    public void startGroupBody(GroupBody groupBody, Integer predictedStateCount) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Group-Body: Predicted size: " + predictedStateCount));
        }
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        this.renderModelBuilder.startGroupBody(groupBody, predictedStateCount);
        this.markDirty();
    }

    @Override
    public void startSection(Renderer.SectionType type) {
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        this.renderModelBuilder.startSection(type);
    }

    @Override
    public InlineSubreportMarker[] endSection() {
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        RenderModelBuilder.SectionResult result = this.renderModelBuilder.endSection();
        if (!result.isEmpty()) {
            this.markDirty();
        }
        return result.getSubreportMarkers();
    }

    @Override
    public void endGroupBody() {
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        this.renderModelBuilder.endGroupBody();
        this.markDirty();
    }

    @Override
    public void endGroup() {
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        this.renderModelBuilder.endGroup();
        this.markDirty();
    }

    @Override
    public void endSubReport() {
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        this.renderModelBuilder.endSubReport();
        this.markDirty();
    }

    @Override
    public void endReport() {
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        this.renderModelBuilder.endReport();
        this.markDirty();
    }

    @Override
    public void addEmptyRootLevelBand() throws ReportProcessingException {
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        this.renderModelBuilder.addEmptyRootLevelBand();
    }

    @Override
    public void addProgressBox() throws ReportProcessingException {
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        if (this.wrapProgressMarkerInSection) {
            this.renderModelBuilder.startSection(Renderer.SectionType.NORMALFLOW);
            this.renderModelBuilder.addProgressBox();
            this.renderModelBuilder.endSection();
        } else {
            this.renderModelBuilder.addProgressBox();
        }
    }

    @Override
    public void add(Band band, ExpressionRuntime runtime) throws ReportProcessingException {
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        this.renderModelBuilder.add(runtime, band);
    }

    public void addToNormalFlow(Band band, ExpressionRuntime runtime) throws ReportProcessingException {
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        this.renderModelBuilder.addToNormalFlow(runtime, band);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Renderer.LayoutResult validatePages() throws ContentProcessingException {
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        try {
            this.validateStopWatch.start();
            LogicalPageBox pageBox = this.getPageBox();
            if (pageBox == null) {
                this.lastValidateResult = Renderer.LayoutResult.LAYOUT_UNVALIDATABLE;
                Renderer.LayoutResult layoutResult = Renderer.LayoutResult.LAYOUT_UNVALIDATABLE;
                return layoutResult;
            }
            if (!this.dirty && this.lastValidateResult != null) {
                Renderer.LayoutResult layoutResult = this.lastValidateResult;
                return layoutResult;
            }
            this.setLastStateKey(null);
            this.setPagebreaks(0);
            if (!this.validateModelStep.isLayoutable(pageBox)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Content-Ref# " + pageBox.getContentRefCount()));
                }
                this.lastValidateResult = Renderer.LayoutResult.LAYOUT_UNVALIDATABLE;
                Renderer.LayoutResult layoutResult = Renderer.LayoutResult.LAYOUT_UNVALIDATABLE;
                return layoutResult;
            }
            this.tableValidationStep.validate(pageBox);
            this.paragraphLineBreakStep.compute(pageBox);
            this.staticPropertiesStep.compute(pageBox);
            this.minorAxisLayoutStep.compute(pageBox);
            this.canvasMinorAxisLayoutStep.compute(pageBox);
            this.majorAxisLayoutStep.compute(pageBox);
            this.canvasMajorAxisLayoutStep.compute(pageBox);
            if (!this.preparePagination(pageBox)) {
                Renderer.LayoutResult layoutResult = Renderer.LayoutResult.LAYOUT_UNVALIDATABLE;
                return layoutResult;
            }
            this.applyCachedValuesStep.compute(pageBox);
            if (this.isPageFinished()) {
                this.lastValidateResult = Renderer.LayoutResult.LAYOUT_PAGEBREAK;
                Renderer.LayoutResult layoutResult = Renderer.LayoutResult.LAYOUT_PAGEBREAK;
                return layoutResult;
            }
            this.lastValidateResult = Renderer.LayoutResult.LAYOUT_NO_PAGEBREAK;
            Renderer.LayoutResult layoutResult = Renderer.LayoutResult.LAYOUT_NO_PAGEBREAK;
            return layoutResult;
        }
        finally {
            this.validateStopWatch.stop(true);
        }
    }

    protected boolean preparePagination(LogicalPageBox pageBox) {
        return true;
    }

    protected void clearDirty() {
        this.dirty = false;
    }

    protected abstract boolean isPageFinished();

    @Override
    public void processIncrementalUpdate(boolean performOutput) throws ContentProcessingException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processPage(LayoutPagebreakHandler handler, Object commitMarker, boolean performOutput) throws ContentProcessingException {
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        try {
            this.paginateStopWatch.start();
            LogicalPageBox pageBox = this.getPageBox();
            if (pageBox == null) {
                boolean bl = false;
                return bl;
            }
            if (!this.dirty) {
                boolean bl = false;
                return bl;
            }
            this.setLastStateKey(null);
            this.setPagebreaks(0);
            if (!this.validateModelStep.isLayoutable(pageBox)) {
                logger.debug((Object)"Not layoutable");
                boolean bl = false;
                return bl;
            }
            boolean repeat = true;
            while (repeat) {
                if (handler != null) {
                    handler.pageFinished();
                }
                if (this.outputProcessor.getMetaData().isFeatureSupported(OutputProcessorFeature.PAGEBREAKS)) {
                    this.createRollbackInformation();
                    this.applyRollbackInformation();
                    this.performParanoidModelCheck();
                }
                this.tableValidationStep.validate(pageBox);
                this.paragraphLineBreakStep.compute(pageBox);
                this.staticPropertiesStep.compute(pageBox);
                this.minorAxisLayoutStep.compute(pageBox);
                this.canvasMinorAxisLayoutStep.compute(pageBox);
                this.majorAxisLayoutStep.compute(pageBox);
                this.canvasMajorAxisLayoutStep.compute(pageBox);
                if (!this.preparePagination(pageBox)) {
                    boolean bl = this.pagebreaks > 0;
                    return bl;
                }
                this.applyCachedValuesStep.compute(pageBox);
                repeat = this.performPagination(handler, performOutput);
            }
            this.clearDirty();
            boolean bl = this.pagebreaks > 0;
            return bl;
        }
        finally {
            this.validateStopWatch.stop(this.isOpen());
            this.paginateStopWatch.stop(this.isOpen());
        }
    }

    protected abstract boolean performPagination(LayoutPagebreakHandler var1, boolean var2) throws ContentProcessingException;

    protected void debugPrint(LogicalPageBox pageBox) {
    }

    @Override
    public ReportStateKey getLastStateKey() {
        return this.lastStateKey;
    }

    protected void setLastStateKey(ReportStateKey lastStateKey) {
        this.lastStateKey = lastStateKey;
    }

    protected void setPagebreaks(int pagebreaks) {
        this.pagebreaks = pagebreaks;
    }

    @Override
    public int getPagebreaks() {
        return this.pagebreaks;
    }

    @Override
    public boolean isOpen() {
        LogicalPageBox pageBox = this.getPageBox();
        if (pageBox == null) {
            return false;
        }
        return pageBox.isOpen();
    }

    @Override
    public boolean isValid() {
        return !this.readOnly;
    }

    @Override
    public Renderer deriveForStorage() {
        try {
            AbstractRenderer renderer = (AbstractRenderer)this.clone();
            renderer.readOnly = false;
            renderer.renderModelBuilder = this.renderModelBuilder.deriveForStorage();
            return renderer;
        }
        catch (CloneNotSupportedException cne) {
            throw new InvalidReportStateException("Failed to derive Renderer", cne);
        }
    }

    @Override
    public Renderer deriveForPagebreak() {
        try {
            AbstractRenderer renderer = (AbstractRenderer)this.clone();
            renderer.readOnly = true;
            renderer.renderModelBuilder = this.renderModelBuilder.deriveForPageBreak();
            return renderer;
        }
        catch (CloneNotSupportedException cne) {
            throw new InvalidReportStateException("Failed to derive Renderer", cne);
        }
    }

    public void performParanoidModelCheck() {
        if (this.paranoidChecks) {
            this.renderModelBuilder.performParanoidModelCheck();
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public void addPagebreak() {
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        this.renderModelBuilder.addPageBreak();
    }

    @Override
    public boolean clearPendingPageStart(LayoutPagebreakHandler layoutPagebreakHandler) {
        return false;
    }

    @Override
    public boolean isCurrentPageEmpty() {
        return false;
    }

    @Override
    public boolean isPageStartPending() {
        return false;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void createRollbackInformation() {
        LogicalPageBox pageBox = this.getPageBox();
        if (pageBox != null) {
            this.commitStep.compute(pageBox);
        }
    }

    @Override
    public void applyRollbackInformation() {
        LogicalPageBox pageBox = this.getPageBox();
        if (pageBox != null) {
            this.applyCommitStep.compute(pageBox);
        }
    }

    public void validateAfterCommit() {
        if (this.paranoidChecks) {
            this.renderModelBuilder.validateAfterCommit();
        }
    }

    @Override
    public void rollback() {
        this.readOnly = false;
        LogicalPageBox pageBox = this.getPageBox();
        if (pageBox != null) {
            this.rollbackStep.compute(pageBox);
            this.renderModelBuilder.restoreStateAfterRollback();
            this.validateAfterCommit();
        }
    }

    @Override
    public void applyAutoCommit() {
        LogicalPageBox pageBox = this.getPageBox();
        if (pageBox != null) {
            this.applyAutoCommitStep.compute(pageBox);
        }
    }

    @Override
    public boolean isPendingPageHack() {
        return false;
    }

    protected void markDirty() {
        this.dirty = true;
        this.lastValidateResult = null;
    }

    @Override
    public void print() {
        if (this.renderModelBuilder.getPageBox() == null) {
            logger.info((Object)"Printing impossible - Page-Box empty");
        } else {
            ModelPrinter.INSTANCE.print(this.renderModelBuilder.getPageBox());
        }
    }

    @Override
    public void newPageStarted() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("================================ CLEAR HEADER AND FOOTER ==================================: " + this.getPageCount()));
        }
        LogicalPageBox pageBox = this.getPageBox();
        pageBox.getFooterArea().clear();
        pageBox.getRepeatFooterArea().clear();
        pageBox.getHeaderArea().clear();
        pageBox.getWatermarkArea().clear();
    }

    public void printLayoutStateToFile(ProcessState state, boolean print, boolean rollback) {
        String fileName = "test-output/" + state.getSequenceCounter();
        fileName = fileName + (print ? "-print" : "-paginate");
        fileName = fileName + (rollback ? "-rb" : "");
        fileName = fileName + ".xml";
        FileModelPrinter.print(fileName, this.getPageBox());
    }

    protected PerformanceLoggingStopWatch getValidateStopWatch() {
        return this.validateStopWatch;
    }

    protected PerformanceLoggingStopWatch getPaginateStopWatch() {
        return this.paginateStopWatch;
    }

    protected PerformanceMonitorContext getPerformanceMonitorContext() {
        return this.performanceMonitorContext;
    }

    protected void close() {
        this.majorAxisLayoutStep.close();
        this.canvasMajorAxisLayoutStep.close();
        this.minorAxisLayoutStep.close();
        this.canvasMinorAxisLayoutStep.close();
        this.validateStopWatch.close();
        this.paginateStopWatch.close();
    }

    private class CloseListener
    implements ChangeListener {
        private CloseListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            AbstractRenderer.this.close();
        }
    }
}

