/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.output.crosstab;

import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.CrosstabCell;
import org.pentaho.reporting.engine.classic.core.CrosstabCellBody;
import org.pentaho.reporting.engine.classic.core.CrosstabColumnGroup;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.layout.Renderer;
import org.pentaho.reporting.engine.classic.core.layout.build.LayoutModelBuilder;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBoxNonAutoIterator;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableCellRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableSectionRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.output.DefaultOutputFunction;
import org.pentaho.reporting.engine.classic.core.layout.output.crosstab.CrosstabTableCell;
import org.pentaho.reporting.engine.classic.core.layout.output.crosstab.RenderedCrosstabLayout;
import org.pentaho.reporting.engine.classic.core.layout.style.SimpleStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ResolverStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TableLayout;
import org.pentaho.reporting.engine.classic.core.style.resolver.SimpleStyleResolver;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public final class CrosstabOutputHelper {
    private CrosstabOutputHelper() {
    }

    public static TableSectionRenderBox findTableHeaderSection(RenderNode node) {
        RenderBox tableBox = null;
        while (node != null) {
            if (node.getNodeType() == 266242) {
                tableBox = (RenderBox)node;
                break;
            }
            node = node.getParent();
        }
        if (tableBox == null) {
            return null;
        }
        RenderBoxNonAutoIterator it = new RenderBoxNonAutoIterator(tableBox);
        while (it.hasNext()) {
            TableSectionRenderBox sectionRenderBox;
            RenderNode next = it.next();
            if (next.getLayoutNodeType() != 270338 || (sectionRenderBox = (TableSectionRenderBox)next).getDisplayRole() != TableSectionRenderBox.Role.HEADER) continue;
            return sectionRenderBox;
        }
        return null;
    }

    public static TableSectionRenderBox findTableSection(RenderNode node) {
        while (node != null) {
            if (node.getNodeType() == 270338) {
                return (TableSectionRenderBox)node;
            }
            node = node.getParent();
        }
        return null;
    }

    public static RenderNode findNode(TableSectionRenderBox node, InstanceID id) {
        if (id == null) {
            return null;
        }
        if (node == null) {
            return null;
        }
        return node.findNodeById(id);
    }

    public static Element createTableCell(int colSpan, int rowSpan, boolean pagebreakBefore, boolean pagebreakAfter) {
        CrosstabTableCell b = new CrosstabTableCell(colSpan, rowSpan);
        b.getStyle().setStyleProperty(BandStyleKeys.PAGEBREAK_BEFORE, pagebreakBefore);
        b.getStyle().setStyleProperty(BandStyleKeys.PAGEBREAK_AFTER, pagebreakAfter);
        SimpleStyleResolver resolver = new SimpleStyleResolver();
        ResolverStyleSheet resolverTarget = new ResolverStyleSheet();
        resolver.resolve(b, resolverTarget);
        b.setComputedStyle(new SimpleStyleSheet(resolverTarget));
        return b;
    }

    public static Band createTableRow() {
        return CrosstabOutputHelper.createTableBand("table-row");
    }

    public static Band createTable(TableLayout tableLayout) {
        Band b = new Band();
        b.getStyle().setStyleProperty(BandStyleKeys.LAYOUT, "table");
        b.getStyle().setStyleProperty(ElementStyleKeys.INVISIBLE_CONSUMES_SPACE, true);
        b.getStyle().setStyleProperty(BandStyleKeys.TABLE_LAYOUT, (Object)tableLayout);
        SimpleStyleResolver resolver = new SimpleStyleResolver();
        ResolverStyleSheet resolverTarget = new ResolverStyleSheet();
        resolver.resolve(b, resolverTarget);
        b.setComputedStyle(new SimpleStyleSheet(resolverTarget));
        return b;
    }

    public static Band createTableBand(String layout) {
        Band b = new Band();
        b.getStyle().setStyleProperty(BandStyleKeys.LAYOUT, layout);
        b.getStyle().setStyleProperty(ElementStyleKeys.INVISIBLE_CONSUMES_SPACE, true);
        SimpleStyleResolver resolver = new SimpleStyleResolver();
        ResolverStyleSheet resolverTarget = new ResolverStyleSheet();
        resolver.resolve(b, resolverTarget);
        b.setComputedStyle(new SimpleStyleSheet(resolverTarget));
        return b;
    }

    public static boolean isLastColumnGroup(ReportEvent event) {
        int gidx = event.getState().getCurrentGroupIndex();
        Group group = event.getReport().getGroup(gidx);
        return group.getBody() instanceof CrosstabCellBody;
    }

    public static boolean closeCrosstabTable(DefaultOutputFunction outputFunction) {
        RenderedCrosstabLayout crosstabLayout = outputFunction.getCurrentRenderedCrosstabLayout();
        if (crosstabLayout.isCrosstabTableOpen()) {
            outputFunction.getRenderer().getNormalFlowLayoutModelBuilder().finishBox();
            outputFunction.getRenderer().getNormalFlowLayoutModelBuilder().finishBox();
            crosstabLayout.setCrosstabTableOpen(false);
            return true;
        }
        return false;
    }

    public static void printCrosstabSummary(DefaultOutputFunction outputFunction, ReportEvent event) throws ReportProcessingException {
        int gidx = event.getState().getCurrentGroupIndex() + 1;
        Group rawGroup = event.getReport().getGroup(gidx);
        if (!(rawGroup instanceof CrosstabColumnGroup)) {
            return;
        }
        CrosstabColumnGroup group = (CrosstabColumnGroup)rawGroup;
        if (!group.isPrintSummary()) {
            return;
        }
        CrosstabCellBody dataBody = event.getReport().getCrosstabCellBody();
        CrosstabCell element = dataBody.findElement(null, group.getField());
        if (element == null) {
            return;
        }
        RenderedCrosstabLayout crosstabLayout = outputFunction.getCurrentRenderedCrosstabLayout();
        LayoutModelBuilder layoutModelBuilder = outputFunction.getRenderer().getNormalFlowLayoutModelBuilder();
        if (crosstabLayout.isCrosstabHeaderOpen()) {
            CrosstabOutputHelper.expandColumnHeaderSpan(crosstabLayout, layoutModelBuilder, gidx);
            if (crosstabLayout.isGenerateColumnTitleHeaders()) {
                layoutModelBuilder.startSubFlow(crosstabLayout.getColumnTitleHeaderSubflowId(gidx));
                CrosstabOutputHelper.createAutomaticCell(layoutModelBuilder);
                crosstabLayout.setColumnTitleHeaderCellId(gidx - crosstabLayout.getFirstColGroupIndex(), layoutModelBuilder.dangerousRawAccess().getInstanceId());
                outputFunction.getRenderer().add(group.getTitleHeader(), outputFunction.getRuntime());
                layoutModelBuilder.finishBox();
                layoutModelBuilder.suspendSubFlow();
            }
            layoutModelBuilder.startSubFlow(crosstabLayout.getColumnHeaderSubflowId(gidx));
            CrosstabOutputHelper.createAutomaticCell(layoutModelBuilder);
            crosstabLayout.setColumnHeaderCellId(gidx - crosstabLayout.getFirstColGroupIndex(), layoutModelBuilder.dangerousRawAccess().getInstanceId());
            outputFunction.getRenderer().add(group.getSummaryHeader(), outputFunction.getRuntime());
            layoutModelBuilder.finishBox();
            layoutModelBuilder.suspendSubFlow();
            if (crosstabLayout.isGenerateMeasureHeaders()) {
                layoutModelBuilder.startSubFlow(crosstabLayout.getMeasureHeaderSubflowId());
                CrosstabOutputHelper.createAutomaticCell(layoutModelBuilder);
                outputFunction.getRenderer().add(dataBody.getHeader(), outputFunction.getRuntime());
                layoutModelBuilder.finishBox();
                layoutModelBuilder.suspendSubFlow();
            }
        }
        CrosstabOutputHelper.createAutomaticCell(layoutModelBuilder);
        layoutModelBuilder.legacyFlagNotEmpty();
        outputFunction.getRenderer().startSection(Renderer.SectionType.NORMALFLOW);
        outputFunction.getRenderer().add(element, outputFunction.getRuntime());
        outputFunction.addSubReportMarkers(outputFunction.getRenderer().endSection());
        layoutModelBuilder.finishBox();
    }

    public static void expandColumnHeaderSpan(RenderedCrosstabLayout crosstabLayout, LayoutModelBuilder layoutModelBuilder, int gidx) {
        TableSectionRenderBox section = CrosstabOutputHelper.findTableHeaderSection(layoutModelBuilder.dangerousRawAccess());
        int i = crosstabLayout.getFirstColGroupIndex();
        int count = 0;
        while (i < gidx) {
            InstanceID columnHeaderId;
            RenderNode columnHeaderCell;
            TableCellRenderBox cellBox;
            if (crosstabLayout.isGenerateColumnTitleHeaders()) {
                InstanceID columnTitleHeaderId = crosstabLayout.getColumnTitleHeaderCellId(i - crosstabLayout.getFirstColGroupIndex());
                RenderNode columnTitleHeaderCell = CrosstabOutputHelper.findNode(section, columnTitleHeaderId);
                if (columnTitleHeaderCell instanceof TableCellRenderBox) {
                    cellBox = (TableCellRenderBox)columnTitleHeaderCell;
                    cellBox.update(cellBox.getRowSpan(), cellBox.getColSpan() + 1);
                } else {
                    throw new IllegalStateException("Unable to find node for previous column title header. Aborting report processing.");
                }
            }
            if (!((columnHeaderCell = CrosstabOutputHelper.findNode(section, columnHeaderId = crosstabLayout.getColumnHeaderCellId(i - crosstabLayout.getFirstColGroupIndex()))) instanceof TableCellRenderBox)) {
                throw new IllegalStateException("Unable to find node for previous column title header. Aborting report processing.");
            }
            cellBox = (TableCellRenderBox)columnHeaderCell;
            cellBox.update(cellBox.getRowSpan(), cellBox.getColSpan() + 1);
            ++i;
            ++count;
        }
    }

    public static void createAutomaticCell(LayoutModelBuilder layoutModelBuilder, int colSpan, int rowSpan, Element element) {
        boolean pagebreakBefore = element.getComputedStyle().getBooleanStyleProperty(BandStyleKeys.PAGEBREAK_BEFORE);
        boolean pagebreakAfter = element.getComputedStyle().getBooleanStyleProperty(BandStyleKeys.PAGEBREAK_AFTER);
        CrosstabOutputHelper.createAutomaticCell(layoutModelBuilder, colSpan, rowSpan, pagebreakBefore, pagebreakAfter);
    }

    public static void createAutomaticCell(LayoutModelBuilder layoutModelBuilder) {
        CrosstabOutputHelper.createAutomaticCell(layoutModelBuilder, 1, 1, false, false);
    }

    public static void createAutomaticCell(LayoutModelBuilder layoutModelBuilder, int colSpan, int rowSpan) {
        CrosstabOutputHelper.createAutomaticCell(layoutModelBuilder, colSpan, rowSpan, false, false);
    }

    private static void createAutomaticCell(LayoutModelBuilder layoutModelBuilder, int colSpan, int rowSpan, boolean pagebreakBefore, boolean pagebreakAfter) {
        Element tableCell = CrosstabOutputHelper.createTableCell(colSpan, rowSpan, pagebreakBefore, pagebreakAfter);
        layoutModelBuilder.startBox(tableCell);
    }

    public static RenderNode findParentNode(RenderNode renderNode, InstanceID crosstabId) {
        while (renderNode != null) {
            if (renderNode.getInstanceId() == crosstabId) {
                return renderNode;
            }
            renderNode = renderNode.getParent();
        }
        return null;
    }
}

