/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata;

import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.filter.MessageFormatSupport;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionPropertyCore;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionPropertyMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ResourceReference;
import org.pentaho.reporting.libraries.docbundle.BundleUtilities;
import org.pentaho.reporting.libraries.formula.parser.ParseException;
import org.pentaho.reporting.libraries.formula.util.FormulaUtil;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class DefaultExpressionPropertyCore
implements ExpressionPropertyCore {
    private static final ResourceReference[] EMPTY_RESOURCES = new ResourceReference[0];
    private static final String[] EMPTY_FIELDS = new String[0];
    private static final String[] EMPTY = EMPTY_FIELDS;

    @Override
    public String[] getReferencedFields(ExpressionPropertyMetaData metaData, Expression expression, Object attributeValue) {
        if (expression == null) {
            throw new NullPointerException();
        }
        String propertyRole = metaData.getPropertyRole();
        if (attributeValue == null) {
            return EMPTY;
        }
        if ("Field".equals(propertyRole)) {
            if (attributeValue instanceof String[]) {
                String[] vals = (String[])attributeValue;
                return (String[])vals.clone();
            }
            return new String[]{String.valueOf(attributeValue)};
        }
        if ("Message".equals(propertyRole)) {
            String message = String.valueOf(attributeValue);
            MessageFormatSupport messageFormatSupport = new MessageFormatSupport();
            messageFormatSupport.setFormatString(message);
            return messageFormatSupport.getFields();
        }
        if ("Formula".equals(propertyRole)) {
            String formula = String.valueOf(attributeValue);
            try {
                String[] objects = FormulaUtil.getReferences((String)formula);
                ArrayList<String> list = new ArrayList<String>();
                for (int i = 0; i < objects.length; ++i) {
                    String object = objects[i];
                    if (!(object instanceof String)) continue;
                    list.add(object);
                }
                return list.toArray(new String[list.size()]);
            }
            catch (ParseException e) {
                return EMPTY;
            }
        }
        return EMPTY;
    }

    @Override
    public String[] getReferencedGroups(ExpressionPropertyMetaData metaData, Expression expression, Object attributeValue) {
        if (expression == null) {
            throw new NullPointerException();
        }
        if (attributeValue == null) {
            return EMPTY;
        }
        String propertyRole = metaData.getPropertyRole();
        if ("Group".equals(propertyRole)) {
            if (attributeValue instanceof String[]) {
                String[] attrVal = (String[])attributeValue;
                return (String[])attrVal.clone();
            }
            return new String[]{String.valueOf(attributeValue)};
        }
        return EMPTY;
    }

    @Override
    public String[] getReferencedElements(ExpressionPropertyMetaData metaData, Expression expression, Object attributeValue) {
        if (expression == null) {
            throw new NullPointerException();
        }
        if (attributeValue == null) {
            return EMPTY;
        }
        String propertyRole = metaData.getPropertyRole();
        if ("ElementName".equals(propertyRole)) {
            if (attributeValue instanceof String[]) {
                String[] attrVal = (String[])attributeValue;
                return (String[])attrVal.clone();
            }
            return new String[]{String.valueOf(attributeValue)};
        }
        return EMPTY;
    }

    @Override
    public ResourceReference[] getReferencedResources(ExpressionPropertyMetaData metaData, Expression expression, Object attributeValue, Element reportElement, ResourceManager resourceManager) {
        if (expression == null) {
            throw new NullPointerException();
        }
        if (reportElement == null) {
            throw new NullPointerException();
        }
        if (resourceManager == null) {
            throw new NullPointerException();
        }
        String propertyRole = metaData.getPropertyRole();
        if ("Content".equals(propertyRole)) {
            ResourceKey contentBase = reportElement.getContentBase();
            ResourceKey elementSource = reportElement.getDefinitionSource();
            if (attributeValue instanceof ResourceKey) {
                ResourceKey path = (ResourceKey)attributeValue;
                boolean linked = BundleUtilities.isSameBundle((ResourceKey)elementSource, (ResourceKey)path);
                return new ResourceReference[]{new ResourceReference(path, linked)};
            }
            if (attributeValue instanceof String && contentBase != null) {
                try {
                    ResourceKey path = resourceManager.deriveKey(contentBase, String.valueOf(attributeValue));
                    boolean linked = !BundleUtilities.isSameBundle((ResourceKey)elementSource, (ResourceKey)path);
                    return new ResourceReference[]{new ResourceReference(path, linked)};
                }
                catch (ResourceKeyCreationException rce) {}
            } else if (attributeValue != null) {
                try {
                    ResourceKey path = resourceManager.createKey(attributeValue);
                    boolean linked = !BundleUtilities.isSameBundle((ResourceKey)elementSource, (ResourceKey)path);
                    return new ResourceReference[]{new ResourceReference(path, linked)};
                }
                catch (ResourceKeyCreationException rce) {
                    // empty catch block
                }
            }
        }
        return EMPTY_RESOURCES;
    }

    @Override
    public String[] getExtraCalculationFields(ExpressionPropertyMetaData metaData) {
        return EMPTY_FIELDS;
    }
}

