/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.helper;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.driver.PrinterDriver;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.helper.PrinterEncoding;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.helper.PrinterSpecification;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.helper.PropertyPrinterSpecificationLoader;
import org.pentaho.reporting.libraries.base.config.DefaultConfiguration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class PrinterSpecificationManager {
    private static final Log logger = LogFactory.getLog(PrinterSpecificationManager.class);
    private HashMap printerModels;
    private static PrinterSpecification generic;

    public PrinterSpecificationManager() {
        PrinterSpecification generic = PrinterSpecificationManager.getGenericPrinter();
        this.printerModels = new HashMap();
        this.printerModels.put(generic.getName(), generic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String resourceName) {
        if (resourceName == null) {
            throw new NullPointerException();
        }
        InputStream in = ObjectUtilities.getResourceRelativeAsStream((String)resourceName, PrinterDriver.class);
        if (in == null) {
            logger.error((Object)("Printer definition is missing: " + resourceName));
            return;
        }
        try {
            try {
                this.load(in);
            }
            finally {
                in.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)("Unable to load printer definition file " + resourceName), (Throwable)e);
        }
    }

    public void load(InputStream in) throws IOException {
        if (in == null) {
            throw new NullPointerException();
        }
        DefaultConfiguration encodingConfig = new DefaultConfiguration();
        encodingConfig.load(in);
        PropertyPrinterSpecificationLoader loader = new PropertyPrinterSpecificationLoader();
        PrinterEncoding[] encodings = loader.loadEncodings(encodingConfig);
        PrinterSpecification[] printers = loader.loadPrinters(encodingConfig, encodings);
        if (printers.length > 0) {
            this.printerModels.remove(PrinterSpecificationManager.getGenericPrinter().getName());
        }
        for (int i = 0; i < printers.length; ++i) {
            this.addPrinter(printers[i]);
        }
    }

    private void addPrinter(PrinterSpecification printer) {
        if (printer == null) {
            throw new NullPointerException();
        }
        this.printerModels.put(printer.getName(), printer);
    }

    public String[] getPrinterNames() {
        return this.printerModels.keySet().toArray(new String[this.printerModels.size()]);
    }

    public PrinterSpecification getPrinter(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        return (PrinterSpecification)this.printerModels.get(name);
    }

    public static synchronized PrinterSpecification getGenericPrinter() {
        if (generic == null) {
            generic = new GenericPrinterSpecification();
        }
        return generic;
    }

    private static class GenericPrinterSpecification
    implements PrinterSpecification {
        private PrinterEncoding genericEncoding = new PrinterEncoding("ASCII", "ASCII", "ASCII", new byte[]{0, 0});

        protected GenericPrinterSpecification() {
        }

        @Override
        public String getDisplayName() {
            return "Generic";
        }

        @Override
        public PrinterEncoding getEncoding(String encoding) {
            return this.genericEncoding;
        }

        @Override
        public String getName() {
            return "Generic";
        }

        @Override
        public boolean isEncodingSupported(String encoding) {
            return true;
        }

        @Override
        public boolean isFeatureAvailable(String operationName) {
            return true;
        }
    }
}

