/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.elements;

import java.io.IOException;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.filter.DataSource;
import org.pentaho.reporting.engine.classic.core.filter.EmptyDataSource;
import org.pentaho.reporting.engine.classic.core.filter.templates.Template;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterException;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterState;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.elements.AbstractElementWriteHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.ArrayClassFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.ClassFactoryCollector;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.ObjectDescription;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.ObjectFactoryException;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.URLClassFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.datasource.DataSourceCollector;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.datasource.DefaultDataSourceFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.elements.DefaultElementFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.objects.BandLayoutClassFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.objects.DefaultClassFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.stylekey.DefaultStyleKeyFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.stylekey.PageableLayoutStyleKeyFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.templates.DefaultTemplateCollection;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.templates.TemplateCollector;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.templates.TemplateDescription;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.DataSourceWriter;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.ReportWriter;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.ReportWriterContext;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.ReportWriterException;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.TemplateWriter;
import org.pentaho.reporting.libraries.docbundle.WriteableDocumentBundle;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class LegacyElementWriteHandler
extends AbstractElementWriteHandler {
    @Override
    public void writeElement(WriteableDocumentBundle bundle, BundleWriterState state, XmlWriter xmlWriter, Element element) throws IOException, BundleWriterException {
        if (bundle == null) {
            throw new NullPointerException();
        }
        if (state == null) {
            throw new NullPointerException();
        }
        if (xmlWriter == null) {
            throw new NullPointerException();
        }
        if (element == null) {
            throw new NullPointerException();
        }
        AttributeList attList = this.createMainAttributes(element, xmlWriter);
        attList.addNamespaceDeclaration("ext", "http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext");
        xmlWriter.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/bundle/layout/1.0", "legacy", attList, false);
        this.writeElementBody(bundle, state, element, xmlWriter);
        ReportWriter writer = new ReportWriter(state.getMasterReport(), "UTF-8");
        writer.addClassFactoryFactory(new URLClassFactory());
        writer.addClassFactoryFactory(new DefaultClassFactory());
        writer.addClassFactoryFactory(new BandLayoutClassFactory());
        writer.addClassFactoryFactory(new ArrayClassFactory());
        writer.addStyleKeyFactory(new DefaultStyleKeyFactory());
        writer.addStyleKeyFactory(new PageableLayoutStyleKeyFactory());
        writer.addTemplateCollection(new DefaultTemplateCollection());
        writer.addElementFactory(new DefaultElementFactory());
        writer.addDataSourceFactory(new DefaultDataSourceFactory());
        DataSource datasource = element.getDataSource();
        if (!(datasource instanceof EmptyDataSource)) {
            if (datasource instanceof Template) {
                this.writeLegacyTemplate(xmlWriter, writer, (Template)datasource);
            } else {
                this.writeLegacyDataSource(xmlWriter, writer, datasource);
            }
        }
        xmlWriter.writeCloseTag();
    }

    private void writeLegacyTemplate(XmlWriter xmlWriter, ReportWriterContext writerContext, Template template) throws BundleWriterException, IOException {
        TemplateCollector tc = writerContext.getTemplateCollector();
        TemplateDescription templateDescription = tc.getDescription(template);
        if (templateDescription == null) {
            throw new BundleWriterException("Unknown template type: " + template);
        }
        TemplateDescription parentTemplate = (TemplateDescription)templateDescription.getInstance();
        try {
            templateDescription.setParameterFromObject(template);
            TemplateWriter templateWriter = new TemplateWriter(writerContext, xmlWriter, templateDescription, parentTemplate);
            templateWriter.write();
        }
        catch (ObjectFactoryException ofe) {
            throw new BundleWriterException("Error while preparing the template", ofe);
        }
        catch (ReportWriterException e) {
            throw new BundleWriterException("Failed to write legacy template " + template, e);
        }
    }

    private void writeLegacyDataSource(XmlWriter xmlWriter, ReportWriterContext writerContext, DataSource datasource) throws BundleWriterException, IOException {
        ClassFactoryCollector classFactoryCollector = writerContext.getClassFactoryCollector();
        ObjectDescription od = classFactoryCollector.getDescriptionForClass(datasource.getClass());
        if (od == null) {
            od = classFactoryCollector.getSuperClassObjectDescription(datasource.getClass(), null);
        }
        if (od == null) {
            throw new BundleWriterException("Unable to resolve DataSource: " + datasource.getClass());
        }
        DataSourceCollector dataSourceCollector = writerContext.getDataSourceCollector();
        String dsname = dataSourceCollector.getDataSourceName(od);
        if (dsname == null) {
            throw new BundleWriterException("No name for DataSource " + datasource);
        }
        xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "datasource", "type", dsname, false);
        try {
            DataSourceWriter dsWriter = new DataSourceWriter(writerContext, datasource, od, xmlWriter);
            dsWriter.write();
        }
        catch (ReportWriterException e) {
            throw new BundleWriterException("Failed to write legacy DataSource " + datasource, e);
        }
        xmlWriter.writeCloseTag();
    }
}

