/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base;

import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.AbstractObjectDescription;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.ObjectFactoryException;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class URLObjectDescription
extends AbstractObjectDescription {
    private static final Log logger = LogFactory.getLog(URLObjectDescription.class);

    public URLObjectDescription() {
        super(URL.class);
        this.setParameterDefinition("value", String.class);
    }

    @Override
    public Object createObject() {
        String o = (String)this.getParameter("value");
        String baseURL = this.getConfig().getConfigProperty("content-base");
        try {
            if (baseURL != null) {
                try {
                    URL bURL = new URL(baseURL);
                    return new URL(bURL, o);
                }
                catch (Exception e) {
                    logger.warn((Object)("BaseURL is invalid: " + baseURL));
                }
            }
            return new URL(o);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void setParameterFromObject(Object o) throws ObjectFactoryException {
        if (!(o instanceof URL)) {
            throw new ObjectFactoryException("Is no instance of java.net.URL");
        }
        URL comp = (URL)o;
        String baseURL = this.getConfig().getConfigProperty("content-base");
        try {
            URL bURL = new URL(baseURL);
            if (ObjectUtilities.equal((Object)bURL, (Object)comp)) {
                this.setParameter("value", null);
            } else {
                this.setParameter("value", IOUtils.getInstance().createRelativeURL(comp, bURL));
            }
        }
        catch (Exception e) {
            logger.warn((Object)"BaseURL is invalid: ", (Throwable)e);
            this.setParameter("value", comp.toExternalForm());
        }
    }
}

