/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.simple.readhandlers;

import java.awt.Color;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.elementfactory.ContentElementFactory;
import org.pentaho.reporting.engine.classic.core.elementfactory.HorizontalLineElementFactory;
import org.pentaho.reporting.engine.classic.core.elementfactory.VerticalLineElementFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.PropertyAttributes;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.ReportElementReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.ReportParserUtil;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.AbstractPropertyXmlReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.StyleExpressionHandler;
import org.pentaho.reporting.engine.classic.core.util.ShapeTransform;
import org.pentaho.reporting.libraries.xmlns.common.ParserUtil;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class LineReadHandler
extends AbstractPropertyXmlReadHandler
implements ReportElementReadHandler {
    private static final Log logger = LogFactory.getLog(LineReadHandler.class);
    private Element element;
    private static final String NAME_ATT = "name";
    private static final String COLOR_ATT = "color";
    private ArrayList styleExpressionHandlers = new ArrayList();

    @Override
    protected void startParsing(PropertyAttributes atts) throws SAXException {
        boolean relativeSizes;
        float x1 = ReportParserUtil.parseRelativeFloat(atts.getValue(this.getUri(), "x1"), "Element x1 not specified", this.getLocator());
        float y1 = ReportParserUtil.parseRelativeFloat(atts.getValue(this.getUri(), "y1"), "Element y1 not specified", this.getLocator());
        float x2 = ReportParserUtil.parseRelativeFloat(atts.getValue(this.getUri(), "x2"), "Element x2 not specified", this.getLocator());
        float y2 = ReportParserUtil.parseRelativeFloat(atts.getValue(this.getUri(), "y2"), "Element y2 not specified", this.getLocator());
        if (x1 == x2 && y1 == y2) {
            logger.warn((Object)"creating a horizontal line with 'x1 == x2 && y1 == y2' is deprecated. Use relative coordinates instead.");
            Stroke stroke = this.readStroke(atts);
            String name = atts.getValue(this.getUri(), NAME_ATT);
            Color c = ReportParserUtil.parseColor(atts.getValue(this.getUri(), COLOR_ATT));
            HorizontalLineElementFactory elementFactory = new HorizontalLineElementFactory();
            elementFactory.setName(name);
            elementFactory.setColor(c);
            elementFactory.setStroke(stroke);
            elementFactory.setX(new Float(0.0f));
            elementFactory.setY(new Float(y2));
            elementFactory.setMinimumWidth(new Float(-100.0f));
            elementFactory.setMinimumHeight(new Float(0.0f));
            elementFactory.setShouldDraw(Boolean.TRUE);
            this.element = elementFactory.createElement();
            return;
        }
        boolean bl = relativeSizes = x1 < 0.0f || y1 < 0.0f || x2 < 0.0f || y2 < 0.0f;
        if (!relativeSizes) {
            this.createSimpleLine(atts, x1, y1, x2, y2);
        } else {
            this.createRelativeLine(atts, x1, y1, x2, y2);
        }
    }

    private void createRelativeLine(PropertyAttributes atts, float x1, float y1, float x2, float y2) throws SAXException {
        Stroke stroke = this.readStroke(atts);
        String name = atts.getValue(this.getUri(), NAME_ATT);
        Color c = ReportParserUtil.parseColor(atts.getValue(this.getUri(), COLOR_ATT), null);
        String widthValue = atts.getValue(this.getUri(), "width");
        float width = widthValue != null ? ReportParserUtil.parseRelativeFloat(widthValue, "Width is invalid", this.getLocator()) : this.computeDimension(name, x1, x2);
        String heightValue = atts.getValue(this.getUri(), "height");
        float height = heightValue != null ? ReportParserUtil.parseRelativeFloat(heightValue, "Height is invalid", this.getLocator()) : this.computeDimension(name, y1, y2);
        Rectangle2D.Float bounds = new Rectangle2D.Float(this.computePosition(name, x1, x2), this.computePosition(name, y1, y2), width, height);
        this.createLineElementFromBounds(x1, y1, x2, y2, stroke, name, c, bounds);
    }

    private void createLineElementFromBounds(float x1, float y1, float x2, float y2, Stroke stroke, String name, Color c, Rectangle2D bounds) {
        if (x1 == x2) {
            VerticalLineElementFactory elementFactory = new VerticalLineElementFactory();
            elementFactory.setName(name);
            elementFactory.setColor(c);
            elementFactory.setStroke(stroke);
            elementFactory.setX(new Float(bounds.getX()));
            elementFactory.setY(new Float(bounds.getY()));
            elementFactory.setMinimumWidth(new Float(bounds.getWidth()));
            elementFactory.setMinimumHeight(new Float(bounds.getHeight()));
            elementFactory.setScale(Boolean.TRUE);
            elementFactory.setKeepAspectRatio(Boolean.FALSE);
            elementFactory.setShouldDraw(Boolean.TRUE);
            this.element = elementFactory.createElement();
        } else if (y1 == y2) {
            HorizontalLineElementFactory elementFactory = new HorizontalLineElementFactory();
            elementFactory.setName(name);
            elementFactory.setColor(c);
            elementFactory.setStroke(stroke);
            elementFactory.setX(new Float(bounds.getX()));
            elementFactory.setY(new Float(bounds.getY()));
            elementFactory.setMinimumWidth(new Float(bounds.getWidth()));
            elementFactory.setMinimumHeight(new Float(bounds.getHeight()));
            elementFactory.setScale(Boolean.TRUE);
            elementFactory.setKeepAspectRatio(Boolean.FALSE);
            elementFactory.setShouldDraw(Boolean.TRUE);
            this.element = elementFactory.createElement();
        } else {
            Line2D.Float line = new Line2D.Float(Math.abs(x1), Math.abs(y1), Math.abs(x2), Math.abs(y2));
            Rectangle2D shapeBounds = line.getBounds2D();
            Shape transformedShape = ShapeTransform.translateShape(line, -shapeBounds.getX(), -shapeBounds.getY());
            ContentElementFactory elementFactory = new ContentElementFactory();
            elementFactory.setName(name);
            elementFactory.setColor(c);
            elementFactory.setStroke(stroke);
            elementFactory.setX(new Float(shapeBounds.getX()));
            elementFactory.setY(new Float(shapeBounds.getY()));
            elementFactory.setMinimumWidth(new Float(shapeBounds.getWidth()));
            elementFactory.setMinimumHeight(new Float(shapeBounds.getHeight()));
            elementFactory.setContent(transformedShape);
            elementFactory.setScale(Boolean.TRUE);
            elementFactory.setKeepAspectRatio(Boolean.FALSE);
            elementFactory.setShouldDraw(Boolean.TRUE);
            this.element = elementFactory.createElement();
        }
    }

    private float computePosition(String name, float x1, float x2) {
        boolean x2Relative;
        boolean x1Relative;
        if (x1 == 0.0f) {
            x2Relative = x1Relative = x2 < 0.0f;
        } else if (x2 == 0.0f) {
            x2Relative = x1Relative = x1 < 0.0f;
        } else {
            x1Relative = x1 < 0.0f;
            boolean bl = x2Relative = x2 < 0.0f;
        }
        if (x1Relative && x2Relative) {
            return Math.max(x2, x1);
        }
        if (!x1Relative && !x2Relative) {
            return Math.min(x2, x1);
        }
        logger.warn((Object)("Mixing relative and absolute positions in '" + name + "'. " + "The definition is ambigous. (" + x1 + ", " + x2 + ')'));
        if (x1Relative) {
            return x2;
        }
        return x1;
    }

    private float computeDimension(String name, float x1, float x2) {
        boolean x2Relative;
        boolean x1Relative;
        if (x1 == 0.0f) {
            x2Relative = x1Relative = x2 < 0.0f;
        } else if (x2 == 0.0f) {
            x2Relative = x1Relative = x1 < 0.0f;
        } else {
            x1Relative = x1 < 0.0f;
            boolean bl = x2Relative = x2 < 0.0f;
        }
        if (x1Relative && x2Relative) {
            return Math.min(x2, x1) - Math.max(x2, x1);
        }
        if (!x1Relative && !x2Relative) {
            return Math.max(x2, x1) - Math.min(x2, x1);
        }
        logger.warn((Object)("Mixing relative and absolute sizes in '" + name + "'. " + "The definition is ambigous. (" + x1 + ", " + x2 + ')'));
        if (x1Relative) {
            return x1;
        }
        return x2;
    }

    private void createSimpleLine(PropertyAttributes atts, float x1, float y1, float x2, float y2) throws SAXException {
        Stroke stroke = this.readStroke(atts);
        String name = atts.getValue(this.getUri(), NAME_ATT);
        Color c = ReportParserUtil.parseColor(atts.getValue(this.getUri(), COLOR_ATT), null);
        String widthValue = atts.getValue(this.getUri(), "width");
        float width = widthValue != null ? ReportParserUtil.parseRelativeFloat(widthValue, "Width is invalid", this.getLocator()) : Math.max(x2, x1) - Math.min(x2, x1);
        String heightValue = atts.getValue(this.getUri(), "height");
        float height = heightValue != null ? ReportParserUtil.parseRelativeFloat(heightValue, "Height is invalid", this.getLocator()) : Math.max(y2, y1) - Math.min(y2, y1);
        Rectangle2D.Float bounds = new Rectangle2D.Float(Math.min(x1, x2), Math.min(y1, y2), width, height);
        this.createLineElementFromBounds(x1, y1, x2, y2, stroke, name, c, bounds);
    }

    private Stroke readStroke(PropertyAttributes atts) throws ParseException {
        String strokeStyle = atts.getValue(this.getUri(), "stroke-style");
        String weightAttr = atts.getValue(this.getUri(), "weight");
        float weight = 1.0f;
        if (weightAttr != null) {
            weight = ParserUtil.parseFloat((String)weightAttr, (String)"Weight is given, but no number.", (Locator)this.getLocator());
        }
        return ReportParserUtil.parseStroke(strokeStyle, weight);
    }

    @Override
    protected XmlReadHandler getHandlerForChild(String uri, String tagName, PropertyAttributes attrs) throws SAXException {
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if ("style-expression".equals(tagName)) {
            StyleExpressionHandler handler = new StyleExpressionHandler();
            this.styleExpressionHandlers.add(handler);
            return handler;
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        for (int i = 0; i < this.styleExpressionHandlers.size(); ++i) {
            StyleExpressionHandler handler = (StyleExpressionHandler)((Object)this.styleExpressionHandlers.get(i));
            if (handler.getKey() == null) continue;
            this.element.setStyleExpression(handler.getKey(), handler.getExpression());
        }
    }

    public Object getObject() {
        return this.element;
    }
}

