/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.parameters;

import java.lang.reflect.Array;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.ReportEnvironmentDataRow;
import org.pentaho.reporting.engine.classic.core.parameters.AbstractParameter;
import org.pentaho.reporting.engine.classic.core.parameters.CompoundDataRow;
import org.pentaho.reporting.engine.classic.core.parameters.ComputedParameterValues;
import org.pentaho.reporting.engine.classic.core.parameters.DefaultParameterValues;
import org.pentaho.reporting.engine.classic.core.parameters.ListParameter;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterContext;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterValues;
import org.pentaho.reporting.libraries.base.util.FormattedMessage;
import org.pentaho.reporting.libraries.base.util.PerformanceLoggingStopWatch;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class DefaultListParameter
extends AbstractParameter
implements ListParameter {
    private String queryName;
    private String keyColumn;
    private String textColumn;
    private boolean strictValueCheck;
    private boolean allowMultiSelection;

    public DefaultListParameter(String query, String keyColumn, String textColumn, String name, boolean allowMultiSelection, boolean strictValueCheck, Class valueType) {
        super(name, valueType);
        if (query == null) {
            throw new NullPointerException();
        }
        if (keyColumn == null) {
            throw new NullPointerException();
        }
        if (textColumn == null) {
            throw new NullPointerException();
        }
        this.queryName = query;
        this.keyColumn = keyColumn;
        this.textColumn = textColumn;
        this.allowMultiSelection = allowMultiSelection;
        this.strictValueCheck = strictValueCheck;
    }

    @Override
    public boolean isAllowMultiSelection() {
        return this.allowMultiSelection;
    }

    public String getKeyColumn() {
        return this.keyColumn;
    }

    public String getTextColumn() {
        return this.textColumn;
    }

    public String getQueryName() {
        return this.queryName;
    }

    @Override
    public boolean isStrictValueCheck() {
        return this.strictValueCheck;
    }

    @Override
    public ParameterValues getValues(ParameterContext context) throws ReportDataFactoryException {
        if (context == null) {
            throw new NullPointerException();
        }
        DataRow parameterData = context.getParameterData();
        ReportEnvironmentDataRow envDataRow = new ReportEnvironmentDataRow(context.getReportEnvironment());
        DataFactory dataFactory = context.getDataFactory();
        PerformanceLoggingStopWatch sw = context.getPerformanceMonitorContext().createStopWatch("pentaho.report.parameter.query", new FormattedMessage("query={%s}", new Object[]{this.getQueryName()}));
        try {
            sw.start();
            TableModel tableModel = dataFactory.queryData(this.getQueryName(), new CompoundDataRow(envDataRow, parameterData));
            String formula = this.getParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "display-value-formula", context);
            if (StringUtils.isEmpty((String)formula, (boolean)true)) {
                DefaultParameterValues defaultParameterValues = new DefaultParameterValues(tableModel, this.getKeyColumn(), this.getTextColumn());
                return defaultParameterValues;
            }
            ComputedParameterValues computedParameterValues = new ComputedParameterValues(tableModel, this.getKeyColumn(), this.getTextColumn(), formula, context);
            return computedParameterValues;
        }
        finally {
            sw.close();
        }
    }

    public void setParameterAutoSelectFirstValue(boolean autoSelect) {
        this.setParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "autofill-selection", String.valueOf(autoSelect));
    }

    public boolean isParameterAutoSelectFirstValue() {
        return "true".equals(this.getParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "autofill-selection"));
    }

    private boolean isParameterAutoSelectFirstValue(ParameterContext parameterContext) {
        if ("true".equals(this.getParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "autofill-selection", parameterContext))) {
            return true;
        }
        return "true".equals(parameterContext.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.ParameterAutoFillsSelection"));
    }

    @Override
    public Object getDefaultValue(ParameterContext context) throws ReportDataFactoryException {
        ParameterValues values;
        Object o = super.getDefaultValue(context);
        if (o != null) {
            return o;
        }
        if (this.isParameterAutoSelectFirstValue(context) && (values = this.getValues(context)).getRowCount() > 0) {
            if (this.allowMultiSelection) {
                Class valueType1 = this.getValueType();
                Object array = valueType1.isArray() ? Array.newInstance(valueType1.getComponentType(), 1) : Array.newInstance(valueType1, 1);
                Array.set(array, 0, values.getKeyValue(0));
                return array;
            }
            return values.getKeyValue(0);
        }
        if (this.allowMultiSelection) {
            Class valueType1 = this.getValueType();
            if (valueType1.isArray()) {
                return Array.newInstance(valueType1.getComponentType(), 0);
            }
            return Array.newInstance(valueType1, 0);
        }
        return null;
    }
}

