/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.util;

import java.util.Map;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.CompoundDataFactory;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.RootLevelBand;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.ExpressionCollection;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionRegistry;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterDefinition;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;

public abstract class AbstractStructureVisitor {
    protected AbstractStructureVisitor() {
    }

    protected void inspect(AbstractReportDefinition reportDefinition) {
        if (reportDefinition instanceof MasterReport) {
            MasterReport mr = (MasterReport)reportDefinition;
            ReportParameterDefinition parameters = mr.getParameterDefinition();
            ParameterDefinitionEntry[] entries = parameters.getParameterDefinitions();
            for (int i = 0; i < entries.length; ++i) {
                ParameterDefinitionEntry entry = entries[i];
                this.inspectParameter(reportDefinition, parameters, entry);
            }
        }
        CompoundDataFactory dataFactory = CompoundDataFactory.normalize(reportDefinition.getDataFactory(), false);
        int size = dataFactory.size();
        for (int i = 0; i < size; ++i) {
            this.inspectDataSource(reportDefinition, dataFactory.getReference(i));
        }
        ExpressionCollection expressions = reportDefinition.getExpressions();
        Expression[] expressionsArray = expressions.getExpressions();
        for (int i = 0; i < expressionsArray.length; ++i) {
            Expression expression = expressionsArray[i];
            this.inspectExpression(reportDefinition, expression);
        }
        this.inspectElement(reportDefinition);
        this.traverseSection(reportDefinition);
    }

    protected void traverseSection(Section section) {
        this.traverseSectionWithSubReports(section);
    }

    protected void traverseSectionWithSubReports(Section section) {
        int count = section.getElementCount();
        for (int i = 0; i < count; ++i) {
            Element element = section.getElement(i);
            if (element instanceof SubReport) {
                this.inspect((SubReport)element);
                continue;
            }
            if (element instanceof Section) {
                this.inspectElement(element);
                this.traverseSection((Section)element);
                if (!(element instanceof RootLevelBand)) continue;
                RootLevelBand rlb = (RootLevelBand)((Object)element);
                for (int sr = 0; sr < rlb.getSubReportCount(); ++sr) {
                    this.inspect(rlb.getSubReport(sr));
                }
                continue;
            }
            this.inspectElement(element);
        }
    }

    protected void traverseSectionWithoutSubReports(Section section) {
        int count = section.getElementCount();
        for (int i = 0; i < count; ++i) {
            Element element = section.getElement(i);
            if (element instanceof SubReport) {
                this.inspectElement(element);
                continue;
            }
            if (element instanceof Section) {
                this.inspectElement(element);
                this.traverseSection((Section)element);
                continue;
            }
            this.inspectElement(element);
        }
    }

    protected void inspectElement(ReportElement element) {
    }

    protected void traverseAttributeExpressions(ReportElement element) {
        String[] attrExprNamespaces = element.getAttributeExpressionNamespaces();
        for (int i = 0; i < attrExprNamespaces.length; ++i) {
            String attrExprNamespace = attrExprNamespaces[i];
            String[] names = element.getAttributeExpressionNames(attrExprNamespace);
            for (int j = 0; j < names.length; ++j) {
                String name = names[j];
                Expression expression = element.getAttributeExpression(attrExprNamespace, name);
                if (expression == null) continue;
                String expressionName = expression.getClass().getName();
                if (!ExpressionRegistry.getInstance().isExpressionRegistered(expressionName)) {
                    this.inspectAttributeExpression(element, attrExprNamespace, name, expression, null);
                    continue;
                }
                ExpressionMetaData metaData = ExpressionRegistry.getInstance().getExpressionMetaData(expressionName);
                this.inspectAttributeExpression(element, attrExprNamespace, name, expression, metaData);
            }
        }
    }

    protected void inspectAttributeExpression(ReportElement element, String attributeNamespace, String attributeName, Expression expression, ExpressionMetaData expressionMetaData) {
    }

    protected void traverseStyleExpressions(ReportElement element) {
        Map<StyleKey, Expression> map = element.getStyleExpressions();
        for (Map.Entry<StyleKey, Expression> entry : map.entrySet()) {
            StyleKey styleKey = entry.getKey();
            Expression expression = entry.getValue();
            if (expression == null) continue;
            String expressionName = expression.getClass().getName();
            if (!ExpressionRegistry.getInstance().isExpressionRegistered(expressionName)) {
                this.inspectStyleExpression(element, styleKey, expression, null);
                continue;
            }
            ExpressionMetaData metaData = ExpressionRegistry.getInstance().getExpressionMetaData(expressionName);
            this.inspectStyleExpression(element, styleKey, expression, metaData);
        }
    }

    protected void inspectStyleExpression(ReportElement element, StyleKey styleKey, Expression expression, ExpressionMetaData expressionMetaData) {
    }

    protected void inspectExpression(AbstractReportDefinition report, Expression expression) {
    }

    protected void inspectParameter(AbstractReportDefinition report, ReportParameterDefinition definition, ParameterDefinitionEntry parameter) {
    }

    protected void inspectDataSource(AbstractReportDefinition report, DataFactory dataFactory) {
    }
}

