/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.util.beans;

import java.lang.reflect.Array;
import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.ValueConverter;
import org.pentaho.reporting.libraries.base.util.CSVQuoter;
import org.pentaho.reporting.libraries.base.util.CSVTokenizer;

public class ArrayValueConverter
implements ValueConverter {
    private ValueConverter elementConverter;
    private Class elementType;

    public ArrayValueConverter(Class arrayClass, ValueConverter elementConverter) {
        if (elementConverter == null) {
            throw new NullPointerException("elementConverter must not be null");
        }
        if (arrayClass == null) {
            throw new NullPointerException("arrayClass must not be null");
        }
        this.elementType = arrayClass;
        this.elementConverter = elementConverter;
    }

    @Override
    public String toAttributeValue(Object o) throws BeanException {
        if (o == null) {
            throw new NullPointerException("Value must not be null");
        }
        if (!o.getClass().isArray()) {
            throw new BeanException("Value must be a array");
        }
        int size = Array.getLength(o);
        StringBuilder buffer = new StringBuilder(size * 25);
        CSVQuoter quoter = new CSVQuoter(',', '\"');
        for (int i = 0; i < size; ++i) {
            Object o1;
            if (i != 0) {
                buffer.append(',');
            }
            if ((o1 = Array.get(o, i)) == null) continue;
            String original = this.elementConverter.toAttributeValue(o1);
            if (original.length() == 0) {
                buffer.append("\"\"");
                continue;
            }
            buffer.append(quoter.doQuoting(original));
        }
        return buffer.toString();
    }

    @Override
    public Object toPropertyValue(String s) throws BeanException {
        if (s == null) {
            throw new NullPointerException();
        }
        CSVTokenizer tokenizer = new CSVTokenizer(s, false);
        ArrayList<Object> elements = new ArrayList<Object>();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token == null || token.length() == 0) {
                elements.add(null);
                continue;
            }
            elements.add(this.elementConverter.toPropertyValue(token));
        }
        Object retval = Array.newInstance(this.elementType, elements.size());
        for (int i = 0; i < elements.size(); ++i) {
            Object o = elements.get(i);
            Array.set(retval, i, o);
        }
        return retval;
    }
}

