/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.util.beans;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanUtility;
import org.pentaho.reporting.engine.classic.core.util.beans.ValueConverter;

public class GenericValueConverter
implements ValueConverter {
    private PropertyDescriptor propertyDescriptor;
    private PropertyEditor propertyEditor;

    public GenericValueConverter(PropertyDescriptor pd) throws IntrospectionException {
        if (pd == null) {
            throw new NullPointerException("PropertyDescriptor must not be null.");
        }
        if (pd.getPropertyEditorClass() == null) {
            throw new IntrospectionException("Property has no editor.");
        }
        this.propertyDescriptor = pd;
        this.propertyEditor = this.createPropertyEditor(pd);
    }

    private PropertyEditor createPropertyEditor(PropertyDescriptor pi) throws IntrospectionException {
        Class<?> c = pi.getPropertyEditorClass();
        try {
            return (PropertyEditor)c.newInstance();
        }
        catch (Exception e) {
            throw new IntrospectionException("Unable to create PropertyEditor.");
        }
    }

    @Override
    public String toAttributeValue(Object o) throws BeanException {
        if (o == null) {
            throw new NullPointerException();
        }
        Class aClass = BeanUtility.getPropertyType(this.propertyDescriptor);
        if (!aClass.isInstance(o)) {
            throw new BeanException("Failed to convert object of type " + o.getClass() + ": Not a " + aClass.getName());
        }
        this.propertyEditor.setValue(o);
        return this.propertyEditor.getAsText();
    }

    @Override
    public Object toPropertyValue(String s) {
        if (s == null) {
            throw new NullPointerException();
        }
        this.propertyEditor.setAsText(s);
        return this.propertyEditor.getValue();
    }
}

