/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.streaming.StreamTask;
import org.apache.cassandra.streaming.messages.OutgoingFileMessage;
import org.apache.cassandra.utils.Pair;

public class StreamTransferTask
extends StreamTask {
    private final ScheduledExecutorService timeoutExecutor = Executors.newSingleThreadScheduledExecutor();
    private final AtomicInteger sequenceNumber = new AtomicInteger(0);
    private final Map<Integer, OutgoingFileMessage> files = new ConcurrentHashMap<Integer, OutgoingFileMessage>();
    private final Map<Integer, ScheduledFuture> timeoutTasks = new ConcurrentHashMap<Integer, ScheduledFuture>();
    private long totalSize;

    public StreamTransferTask(StreamSession session, UUID cfId) {
        super(session, cfId);
    }

    public void addTransferFile(SSTableReader sstable, long estimatedKeys, List<Pair<Long, Long>> sections) {
        assert (sstable != null && this.cfId.equals(sstable.metadata.cfId));
        OutgoingFileMessage message = new OutgoingFileMessage(sstable, this.sequenceNumber.getAndIncrement(), estimatedKeys, sections);
        this.files.put(message.header.sequenceNumber, message);
        this.totalSize += message.header.size();
    }

    public synchronized void complete(int sequenceNumber) {
        OutgoingFileMessage file = this.files.remove(sequenceNumber);
        if (file != null) {
            file.sstable.releaseReference();
            if (this.files.isEmpty()) {
                this.timeoutExecutor.shutdownNow();
                this.session.taskCompleted(this);
            }
        }
    }

    @Override
    public void abort() {
        for (OutgoingFileMessage file : this.files.values()) {
            file.sstable.releaseReference();
        }
        this.timeoutExecutor.shutdownNow();
    }

    @Override
    public int getTotalNumberOfFiles() {
        return this.files.size();
    }

    @Override
    public long getTotalSize() {
        return this.totalSize;
    }

    public Collection<OutgoingFileMessage> getFileMessages() {
        return new ArrayList<OutgoingFileMessage>(this.files.values());
    }

    public OutgoingFileMessage createMessageForRetry(int sequenceNumber) {
        ScheduledFuture future = this.timeoutTasks.get(sequenceNumber);
        future.cancel(false);
        return this.files.get(sequenceNumber);
    }

    public synchronized ScheduledFuture scheduleTimeout(final int sequenceNumber, long time, TimeUnit unit) {
        if (this.timeoutExecutor.isShutdown()) {
            return null;
        }
        ScheduledFuture<?> future = this.timeoutExecutor.schedule(new Runnable(){

            @Override
            public void run() {
                StreamTransferTask.this.complete(sequenceNumber);
                StreamTransferTask.this.timeoutTasks.remove(sequenceNumber);
            }
        }, time, unit);
        this.timeoutTasks.put(sequenceNumber, future);
        return future;
    }
}

