/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.injection.bean;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.injection.bean.BeanInjectionInfo;
import org.pentaho.di.core.injection.bean.BeanLevelInfo;

public class BeanInjector {
    private final BeanInjectionInfo info;

    public BeanInjector(BeanInjectionInfo info) {
        this.info = info;
    }

    public Object getProperty(Object root, String propName) throws Exception {
        ArrayList extractedIndexes = new ArrayList();
        BeanInjectionInfo.Property prop = this.info.getProperties().get(propName);
        if (prop == null) {
            throw new RuntimeException("Property not found");
        }
        Object obj = root;
        int arrIndex = 0;
        for (int i = 1; i < prop.path.size(); ++i) {
            BeanLevelInfo s = prop.path.get(i);
            if ((obj = s.field.get(obj)) == null) {
                return null;
            }
            if (!s.array) continue;
            int index = (Integer)extractedIndexes.get(arrIndex++);
            if (Array.getLength(obj) <= index) {
                return null;
            }
            if ((obj = Array.get(obj, index)) != null) continue;
            return null;
        }
        return obj;
    }

    public boolean hasProperty(Object root, String propName) {
        BeanInjectionInfo.Property prop = this.info.getProperties().get(propName);
        return prop != null;
    }

    public void setProperty(Object root, String propName, List<RowMetaAndData> data, String dataName) throws KettleException {
        BeanInjectionInfo.Property prop = this.info.getProperties().get(propName);
        if (prop == null) {
            throw new KettleException("Property '" + propName + "' not found for injection to " + root.getClass());
        }
        if (prop.pathArraysCount == 0) {
            try {
                this.setProperty(root, prop, 0, data.get(0), dataName);
            }
            catch (Exception ex) {
                throw new KettleException("Error inject property '" + propName + "' into " + root.getClass(), (Throwable)ex);
            }
        } else if (prop.pathArraysCount == 1) {
            try {
                for (int i = 0; i < data.size(); ++i) {
                    this.setProperty(root, prop, i, data.get(i), dataName);
                }
            }
            catch (Exception ex) {
                throw new KettleException("Error inject property '" + propName + "' into " + root.getClass(), (Throwable)ex);
            }
        } else if (prop.pathArraysCount > 1) {
            throw new KettleException("Property '" + propName + "' has more than one array in path for injection to " + root.getClass());
        }
    }

    private void setProperty(Object root, BeanInjectionInfo.Property prop, int index, RowMetaAndData data, String dataName) throws Exception {
        Object obj = root;
        for (int i = 1; i < prop.path.size(); ++i) {
            Object value;
            Object existArray;
            BeanLevelInfo s = prop.path.get(i);
            if (i < prop.path.size() - 1) {
                Object next;
                if (s.array) {
                    existArray = this.extendArray(s, obj, index + 1);
                    Object next2 = Array.get(existArray, index);
                    if (next2 == null) {
                        for (Constructor<?> c : s.leafClass.getConstructors()) {
                            if (c.getParameterTypes().length == 0) {
                                next2 = s.leafClass.newInstance();
                                break;
                            }
                            if (c.getParameterTypes().length != 1 || !c.getParameterTypes()[0].isAssignableFrom(this.info.clazz)) continue;
                            next2 = c.newInstance(root);
                            break;
                        }
                        if (next2 == null) {
                            throw new KettleException("Empty constructor not found for " + s.leafClass);
                        }
                        Array.set(existArray, index, next2);
                    }
                    obj = next2;
                    continue;
                }
                if (s.field != null) {
                    next = s.field.get(obj);
                    if (next == null) {
                        next = s.leafClass.newInstance();
                        s.field.set(obj, next);
                    }
                    obj = next;
                    continue;
                }
                if (s.getter != null) {
                    next = s.getter.invoke(obj, new Object[0]);
                    if (next == null) {
                        if (s.setter == null) {
                            throw new KettleException("No setter defined for " + root.getClass());
                        }
                        next = s.leafClass.newInstance();
                        s.setter.invoke(obj, next);
                    }
                    obj = next;
                    continue;
                }
                throw new KettleException("No field or getter defined for " + root.getClass());
            }
            if (s.array) {
                if (s.field != null) {
                    existArray = this.extendArray(s, obj, index + 1);
                    Object value2 = data.getAsJavaType(dataName, s.leafClass);
                    if (value2 == null) continue;
                    Array.set(existArray, index, value2);
                    continue;
                }
                if (s.setter == null || (value = data.getAsJavaType(dataName, s.leafClass)) == null) continue;
                if (s.setter.getParameterTypes().length == 2) {
                    s.setter.invoke(obj, index, value);
                    continue;
                }
                s.setter.invoke(obj, value);
                continue;
            }
            if (s.field != null) {
                value = data.getAsJavaType(dataName, s.leafClass);
                if (value == null) continue;
                s.field.set(obj, value);
                continue;
            }
            if (s.setter != null) {
                value = data.getAsJavaType(dataName, s.leafClass);
                if (value == null) continue;
                if (s.setter.getParameterTypes().length == 2) {
                    s.setter.invoke(obj, index, value);
                    continue;
                }
                s.setter.invoke(obj, value);
                continue;
            }
            throw new KettleException("No field or setter defined for " + root.getClass());
        }
    }

    private Object extendArray(BeanLevelInfo s, Object obj, int newSize) throws Exception {
        int existSize;
        Object existArray = s.field.get(obj);
        if (existArray == null) {
            existArray = Array.newInstance(s.leafClass, newSize);
            s.field.set(obj, existArray);
        }
        if ((existSize = Array.getLength(existArray)) < newSize) {
            Object newSized = Array.newInstance(s.leafClass, newSize);
            System.arraycopy(existArray, 0, newSized, 0, existSize);
            existArray = newSized;
            s.field.set(obj, existArray);
        }
        return existArray;
    }
}

