/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.setvariables;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleJobException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntrySetVariables
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntrySetVariables.class;
    public boolean replaceVars = true;
    public String[] variableName = null;
    public String[] variableValue = null;
    public int[] variableType;
    public String filename;
    public int fileVariableType;
    public static final int VARIABLE_TYPE_JVM = 0;
    public static final int VARIABLE_TYPE_CURRENT_JOB = 1;
    public static final int VARIABLE_TYPE_PARENT_JOB = 2;
    public static final int VARIABLE_TYPE_ROOT_JOB = 3;
    private static final String[] variableTypeCode = new String[]{"JVM", "CURRENT_JOB", "PARENT_JOB", "ROOT_JOB"};
    private static final String[] variableTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"JobEntrySetVariables.VariableType.JVM", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntrySetVariables.VariableType.CurrentJob", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntrySetVariables.VariableType.ParentJob", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntrySetVariables.VariableType.RootJob", (String[])new String[0])};

    public JobEntrySetVariables(String n) {
        super(n, "");
    }

    public JobEntrySetVariables() {
        this("");
    }

    public void allocate(int nrFields) {
        this.variableName = new String[nrFields];
        this.variableValue = new String[nrFields];
        this.variableType = new int[nrFields];
    }

    @Override
    public Object clone() {
        JobEntrySetVariables je = (JobEntrySetVariables)super.clone();
        if (this.variableName != null) {
            int nrFields = this.variableName.length;
            je.allocate(nrFields);
            System.arraycopy(this.variableName, 0, je.variableName, 0, nrFields);
            System.arraycopy(this.variableValue, 0, je.variableValue, 0, nrFields);
            System.arraycopy(this.variableType, 0, je.variableType, 0, nrFields);
        }
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"replacevars", (boolean)this.replaceVars));
        retval.append("      ").append(XMLHandler.addTagValue((String)"filename", (String)this.filename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"file_variable_type", (String)JobEntrySetVariables.getVariableTypeCode(this.fileVariableType)));
        retval.append("      <fields>").append(Const.CR);
        if (this.variableName != null) {
            for (int i = 0; i < this.variableName.length; ++i) {
                retval.append("        <field>").append(Const.CR);
                retval.append("          ").append(XMLHandler.addTagValue((String)"variable_name", (String)this.variableName[i]));
                retval.append("          ").append(XMLHandler.addTagValue((String)"variable_value", (String)this.variableValue[i]));
                retval.append("          ").append(XMLHandler.addTagValue((String)"variable_type", (String)JobEntrySetVariables.getVariableTypeCode(this.variableType[i])));
                retval.append("        </field>").append(Const.CR);
            }
        }
        retval.append("      </fields>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.replaceVars = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"replacevars"));
            this.filename = XMLHandler.getTagValue((Node)entrynode, (String)"filename");
            this.fileVariableType = JobEntrySetVariables.getVariableType(XMLHandler.getTagValue((Node)entrynode, (String)"file_variable_type"));
            Node fields = XMLHandler.getSubNode((Node)entrynode, (String)"fields");
            int nrFields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrFields);
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.variableName[i] = XMLHandler.getTagValue((Node)fnode, (String)"variable_name");
                this.variableValue[i] = XMLHandler.getTagValue((Node)fnode, (String)"variable_value");
                this.variableType[i] = JobEntrySetVariables.getVariableType(XMLHandler.getTagValue((Node)fnode, (String)"variable_type"));
            }
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JobEntrySetVariables.Meta.UnableLoadXML", (String[])new String[]{xe.getMessage()}), (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.replaceVars = rep.getJobEntryAttributeBoolean(id_jobentry, "replacevars");
            this.filename = rep.getJobEntryAttributeString(id_jobentry, "filename");
            this.fileVariableType = JobEntrySetVariables.getVariableType(rep.getJobEntryAttributeString(id_jobentry, "file_variable_type"));
            int argnr = rep.countNrJobEntryAttributes(id_jobentry, "variable_name");
            this.allocate(argnr);
            for (int a = 0; a < argnr; ++a) {
                this.variableName[a] = rep.getJobEntryAttributeString(id_jobentry, a, "variable_name");
                this.variableValue[a] = rep.getJobEntryAttributeString(id_jobentry, a, "variable_value");
                this.variableType[a] = JobEntrySetVariables.getVariableType(rep.getJobEntryAttributeString(id_jobentry, a, "variable_type"));
            }
        }
        catch (KettleException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntrySetVariables.Meta.UnableLoadRep", (String[])new String[]{String.valueOf(id_jobentry), dbe.getMessage()}), (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "replacevars", this.replaceVars);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "filename", this.filename);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "file_variable_type", JobEntrySetVariables.getVariableTypeCode(this.fileVariableType));
            if (this.variableName != null) {
                for (int i = 0; i < this.variableName.length; ++i) {
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "variable_name", this.variableName[i]);
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "variable_value", this.variableValue[i]);
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "variable_type", JobEntrySetVariables.getVariableTypeCode(this.variableType[i]));
                }
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntrySetVariables.Meta.UnableSaveRep", (String[])new String[]{String.valueOf(id_job), dbe.getMessage()}), (Throwable)dbe);
        }
    }

    @Override
    public Result execute(Result result, int nr) throws KettleException {
        result.setResult(true);
        result.setNrErrors(0L);
        try {
            int i;
            ArrayList<String> variables = new ArrayList<String>();
            ArrayList<String> variableValues = new ArrayList<String>();
            ArrayList<Integer> variableTypes = new ArrayList<Integer>();
            String realFilename = this.environmentSubstitute(this.filename);
            try {
                if (!Const.isEmpty((String)realFilename)) {
                    Properties properties = new Properties();
                    InputStream is = KettleVFS.getInputStream((String)realFilename);
                    InputStreamReader isr = new InputStreamReader(is, "UTF-8");
                    BufferedReader reader = new BufferedReader(isr);
                    properties.load(reader);
                    for (Object key : properties.keySet()) {
                        variables.add((String)key);
                        variableValues.add((String)properties.get(key));
                        variableTypes.add(this.fileVariableType);
                    }
                }
            }
            catch (Exception e) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntrySetVariables.Error.UnableReadPropertiesFile", (String[])new String[]{realFilename}));
            }
            for (i = 0; i < this.variableName.length; ++i) {
                variables.add(this.variableName[i]);
                variableValues.add(this.variableValue[i]);
                variableTypes.add(this.variableType[i]);
            }
            for (i = 0; i < variables.size(); ++i) {
                String varname = (String)variables.get(i);
                String value = (String)variableValues.get(i);
                int type = (Integer)variableTypes.get(i);
                if (this.replaceVars) {
                    varname = this.environmentSubstitute(varname);
                    value = this.environmentSubstitute(value);
                }
                switch (type) {
                    case 0: {
                        System.setProperty(varname, value);
                        this.setVariable(varname, value);
                        for (Job parentJobTraverse = this.parentJob; parentJobTraverse != null; parentJobTraverse = parentJobTraverse.getParentJob()) {
                            parentJobTraverse.setVariable(varname, value);
                        }
                        break;
                    }
                    case 3: {
                        this.setVariable(varname, value);
                        for (Job rootJob = this.parentJob; rootJob != null; rootJob = rootJob.getParentJob()) {
                            rootJob.setVariable(varname, value);
                        }
                        break;
                    }
                    case 1: {
                        this.setVariable(varname, value);
                        if (this.parentJob != null) {
                            this.parentJob.setVariable(varname, value);
                            break;
                        }
                        throw new KettleJobException(BaseMessages.getString(PKG, (String)"JobEntrySetVariables.Error.UnableSetVariableCurrentJob", (String[])new String[]{varname}));
                    }
                    case 2: {
                        this.setVariable(varname, value);
                        if (this.parentJob != null) {
                            this.parentJob.setVariable(varname, value);
                            Job gpJob = this.parentJob.getParentJob();
                            if (gpJob != null) {
                                gpJob.setVariable(varname, value);
                                break;
                            }
                            throw new KettleJobException(BaseMessages.getString(PKG, (String)"JobEntrySetVariables.Error.UnableSetVariableParentJob", (String[])new String[]{varname}));
                        }
                        throw new KettleJobException(BaseMessages.getString(PKG, (String)"JobEntrySetVariables.Error.UnableSetVariableCurrentJob", (String[])new String[]{varname}));
                    }
                }
                if (!this.log.isDetailed()) continue;
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntrySetVariables.Log.SetVariableToValue", (String[])new String[]{varname, value}));
            }
        }
        catch (Exception e) {
            result.setResult(false);
            result.setNrErrors(1L);
            this.logError(BaseMessages.getString(PKG, (String)"JobEntrySetVariables.UnExcpectedError", (String[])new String[]{e.getMessage()}));
        }
        return result;
    }

    public void setReplaceVars(boolean replaceVars) {
        this.replaceVars = replaceVars;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    public boolean isReplaceVars() {
        return this.replaceVars;
    }

    public String[] getVariableValue() {
        return this.variableValue;
    }

    public void setVariableName(String[] fieldValue) {
        this.variableName = fieldValue;
    }

    public int[] getVariableType() {
        return this.variableType;
    }

    public static final String getVariableTypeCode(int variableType) {
        return variableTypeCode[variableType];
    }

    public static final String getVariableTypeDescription(int variableType) {
        return variableTypeDesc[variableType];
    }

    public static final int getVariableType(String variableType) {
        int i;
        for (i = 0; i < variableTypeCode.length; ++i) {
            if (!variableTypeCode[i].equalsIgnoreCase(variableType)) continue;
            return i;
        }
        for (i = 0; i < variableTypeDesc.length; ++i) {
            if (!variableTypeDesc[i].equalsIgnoreCase(variableType)) continue;
            return i;
        }
        return 0;
    }

    public void setVariableType(int[] localVariable) {
        this.variableType = localVariable;
    }

    public static final String[] getVariableTypeDescriptions() {
        return variableTypeDesc;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
        boolean res = JobEntryValidatorUtils.andValidator().validate(this, "variableName", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notNullValidator()));
        if (!res) {
            return;
        }
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx, this.getVariables());
        AndValidator.putValidators(ctx, JobEntryValidatorUtils.notNullValidator(), JobEntryValidatorUtils.fileExistsValidator());
        for (int i = 0; i < this.variableName.length; ++i) {
            JobEntryValidatorUtils.andValidator().validate(this, "variableName[" + i + "]", remarks, ctx);
        }
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (this.variableName != null) {
            ResourceReference reference = null;
            for (int i = 0; i < this.variableName.length; ++i) {
                String filename = jobMeta.environmentSubstitute(this.variableName[i]);
                if (reference == null) {
                    reference = new ResourceReference(this);
                    references.add(reference);
                }
                reference.getEntries().add(new ResourceEntry(filename, ResourceEntry.ResourceType.FILE));
            }
        }
        return references;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public int getFileVariableType() {
        return this.fileVariableType;
    }

    public void setFileVariableType(int fileVariableType) {
        this.fileVariableType = fileVariableType;
    }
}

