/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.waitforfile;

import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileType;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntryWaitForFile
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryWaitForFile.class;
    private String filename = null;
    private String maximumTimeout = DEFAULT_MAXIMUM_TIMEOUT;
    private String checkCycleTime = DEFAULT_CHECK_CYCLE_TIME;
    private boolean successOnTimeout = false;
    private boolean fileSizeCheck = false;
    private boolean addFilenameToResult = false;
    private static String DEFAULT_MAXIMUM_TIMEOUT = "0";
    private static String DEFAULT_CHECK_CYCLE_TIME = "60";

    public JobEntryWaitForFile(String n) {
        super(n, "");
    }

    public JobEntryWaitForFile() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntryWaitForFile je = (JobEntryWaitForFile)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(50);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"filename", (String)this.filename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"maximum_timeout", (String)this.maximumTimeout));
        retval.append("      ").append(XMLHandler.addTagValue((String)"check_cycle_time", (String)this.checkCycleTime));
        retval.append("      ").append(XMLHandler.addTagValue((String)"success_on_timeout", (boolean)this.successOnTimeout));
        retval.append("      ").append(XMLHandler.addTagValue((String)"file_size_check", (boolean)this.fileSizeCheck));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_filename_result", (boolean)this.addFilenameToResult));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.filename = XMLHandler.getTagValue((Node)entrynode, (String)"filename");
            this.maximumTimeout = XMLHandler.getTagValue((Node)entrynode, (String)"maximum_timeout");
            this.checkCycleTime = XMLHandler.getTagValue((Node)entrynode, (String)"check_cycle_time");
            this.successOnTimeout = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"success_on_timeout"));
            this.fileSizeCheck = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"file_size_check"));
            this.addFilenameToResult = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"add_filename_result"));
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException("Unable to load job entry of type 'wait for file' from XML node", (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.filename = rep.getJobEntryAttributeString(id_jobentry, "filename");
            this.maximumTimeout = rep.getJobEntryAttributeString(id_jobentry, "maximum_timeout");
            this.checkCycleTime = rep.getJobEntryAttributeString(id_jobentry, "check_cycle_time");
            this.successOnTimeout = rep.getJobEntryAttributeBoolean(id_jobentry, "success_on_timeout");
            this.fileSizeCheck = rep.getJobEntryAttributeBoolean(id_jobentry, "file_size_check");
            this.addFilenameToResult = rep.getJobEntryAttributeBoolean(id_jobentry, "add_filename_result");
        }
        catch (KettleException dbe) {
            throw new KettleException("Unable to load job entry of type 'wait for file' from the repository for id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "filename", this.filename);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "maximum_timeout", this.maximumTimeout);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "check_cycle_time", this.checkCycleTime);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "success_on_timeout", this.successOnTimeout);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "file_size_check", this.fileSizeCheck);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "add_filename_result", this.addFilenameToResult);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save job entry of type 'wait for file' to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public String getRealFilename() {
        return this.environmentSubstitute(this.getFilename());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setResult(false);
        long timeStart = System.currentTimeMillis() / 1000L;
        if (this.filename != null) {
            FileObject fileObject = null;
            String realFilename = this.getRealFilename();
            try {
                fileObject = KettleVFS.getFileObject((String)realFilename, (VariableSpace)this);
                long iMaximumTimeout = Const.toInt((String)this.getRealMaximumTimeout(), (int)Const.toInt((String)DEFAULT_MAXIMUM_TIMEOUT, (int)0));
                long iCycleTime = Const.toInt((String)this.getRealCheckCycleTime(), (int)Const.toInt((String)DEFAULT_CHECK_CYCLE_TIME, (int)0));
                if (iMaximumTimeout < 0L) {
                    iMaximumTimeout = Const.toInt((String)DEFAULT_MAXIMUM_TIMEOUT, (int)0);
                    if (this.log.isBasic()) {
                        this.logBasic("Maximum timeout invalid, reset to " + iMaximumTimeout);
                    }
                }
                if (iCycleTime < 1L) {
                    iCycleTime = Const.toInt((String)DEFAULT_CHECK_CYCLE_TIME, (int)1);
                    if (this.log.isBasic()) {
                        this.logBasic("Check cycle time invalid, reset to " + iCycleTime);
                    }
                }
                if (iMaximumTimeout == 0L) {
                    if (this.log.isBasic()) {
                        this.logBasic("Waiting indefinitely for file [" + realFilename + "]");
                    }
                } else if (this.log.isBasic()) {
                    this.logBasic("Waiting " + iMaximumTimeout + " seconds for file [" + realFilename + "]");
                }
                boolean continueLoop = true;
                while (continueLoop && !this.parentJob.isStopped()) {
                    fileObject = KettleVFS.getFileObject((String)realFilename, (VariableSpace)this);
                    if (fileObject.exists()) {
                        if (this.log.isBasic()) {
                            this.logBasic("Detected file [" + realFilename + "] within timeout");
                        }
                        result.setResult(true);
                        continueLoop = false;
                        if (!this.addFilenameToResult || fileObject.getType() != FileType.FILE) continue;
                        ResultFile resultFile = new ResultFile(0, fileObject, this.parentJob.getJobname(), this.toString());
                        resultFile.setComment(BaseMessages.getString(PKG, (String)"JobWaitForFile.FilenameAdded", (String[])new String[0]));
                        result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                        continue;
                    }
                    long now = System.currentTimeMillis() / 1000L;
                    if (iMaximumTimeout > 0L && now > timeStart + iMaximumTimeout) {
                        continueLoop = false;
                        if (this.isSuccessOnTimeout()) {
                            if (this.log.isBasic()) {
                                this.logBasic("Didn't detect file [" + realFilename + "] before timeout, success");
                            }
                            result.setResult(true);
                        } else {
                            if (this.log.isBasic()) {
                                this.logBasic("Didn't detect file [" + realFilename + "] before timeout, failure");
                            }
                            result.setResult(false);
                        }
                    }
                    long sleepTime = 0L;
                    sleepTime = iMaximumTimeout == 0L ? iCycleTime : (now + iCycleTime < timeStart + iMaximumTimeout ? iCycleTime : iCycleTime - (now + iCycleTime - (timeStart + iMaximumTimeout)));
                    try {
                        if (sleepTime <= 0L) continue;
                        if (this.log.isDetailed()) {
                            this.logDetailed("Sleeping " + sleepTime + " seconds before next check for file [" + realFilename + "]");
                        }
                        Thread.sleep(sleepTime * 1000L);
                    }
                    catch (InterruptedException e) {
                        result.setResult(false);
                        continueLoop = false;
                    }
                }
                if (!this.parentJob.isStopped() && fileObject.exists() && this.isFileSizeCheck()) {
                    long oldSize = -1L;
                    long newSize = fileObject.getContent().getSize();
                    if (this.log.isDetailed()) {
                        this.logDetailed("File [" + realFilename + "] is " + newSize + " bytes long");
                    }
                    if (this.log.isBasic()) {
                        this.logBasic("Waiting until file [" + realFilename + "] stops growing for " + iCycleTime + " seconds");
                    }
                    while (oldSize != newSize && !this.parentJob.isStopped()) {
                        try {
                            if (this.log.isDetailed()) {
                                this.logDetailed("Sleeping " + iCycleTime + " seconds, waiting for file [" + realFilename + "] to stop growing");
                            }
                            Thread.sleep(iCycleTime * 1000L);
                        }
                        catch (InterruptedException e) {
                            result.setResult(false);
                            continueLoop = false;
                        }
                        oldSize = newSize;
                        newSize = fileObject.getContent().getSize();
                        if (!this.log.isDetailed()) continue;
                        this.logDetailed("File [" + realFilename + "] is " + newSize + " bytes long");
                    }
                    if (this.log.isBasic()) {
                        this.logBasic("Stopped waiting for file [" + realFilename + "] to stop growing");
                    }
                }
                if (!this.parentJob.isStopped()) return result;
                result.setResult(false);
                return result;
            }
            catch (Exception e) {
                this.logBasic("Exception while waiting for file [" + realFilename + "] to stop growing", e);
                return result;
            }
            finally {
                if (fileObject != null) {
                    try {
                        fileObject.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        this.logError("No filename is defined.");
        return result;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    public boolean isSuccessOnTimeout() {
        return this.successOnTimeout;
    }

    public void setSuccessOnTimeout(boolean successOnTimeout) {
        this.successOnTimeout = successOnTimeout;
    }

    public String getCheckCycleTime() {
        return this.checkCycleTime;
    }

    public String getRealCheckCycleTime() {
        return this.environmentSubstitute(this.getCheckCycleTime());
    }

    public void setCheckCycleTime(String checkCycleTime) {
        this.checkCycleTime = checkCycleTime;
    }

    public String getMaximumTimeout() {
        return this.maximumTimeout;
    }

    public String getRealMaximumTimeout() {
        return this.environmentSubstitute(this.getMaximumTimeout());
    }

    public void setMaximumTimeout(String maximumTimeout) {
        this.maximumTimeout = maximumTimeout;
    }

    public boolean isFileSizeCheck() {
        return this.fileSizeCheck;
    }

    public void setFileSizeCheck(boolean fileSizeCheck) {
        this.fileSizeCheck = fileSizeCheck;
    }

    public boolean isAddFilenameToResult() {
        return this.addFilenameToResult;
    }

    public void setAddFilenameToResult(boolean addFilenameToResult) {
        this.addFilenameToResult = addFilenameToResult;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (!Const.isEmpty((String)this.filename)) {
            String realFileName = jobMeta.environmentSubstitute(this.filename);
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(realFileName, ResourceEntry.ResourceType.FILE));
            references.add(reference);
        }
        return references;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
        JobEntryValidatorUtils.andValidator().validate(this, "filename", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "maximumTimeout", remarks, AndValidator.putValidators(JobEntryValidatorUtils.integerValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "checkCycleTime", remarks, AndValidator.putValidators(JobEntryValidatorUtils.integerValidator()));
    }
}

