/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.symmetriccrypto.secretkeygenerator;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBinary;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.symmetriccrypto.secretkeygenerator.SecretKeyGenerator;
import org.pentaho.di.trans.steps.symmetriccrypto.secretkeygenerator.SecretKeyGeneratorData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class SecretKeyGeneratorMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = SecretKeyGeneratorMeta.class;
    private String[] algorithm;
    private String[] scheme;
    private String[] secretKeyLength;
    private String[] secretKeyCount;
    private String secretKeyFieldName;
    private String secretKeyLengthFieldName;
    private String algorithmFieldName;
    private boolean outputKeyInBinary;

    public String[] getAlgorithm() {
        return this.algorithm;
    }

    public String[] getScheme() {
        return this.scheme;
    }

    public String getSecretKeyFieldName() {
        return this.secretKeyFieldName;
    }

    public void setSecretKeyFieldName(String secretKeyFieldName) {
        this.secretKeyFieldName = secretKeyFieldName;
    }

    public String getSecretKeyLengthFieldName() {
        return this.secretKeyLengthFieldName;
    }

    public void setOutputKeyInBinary(boolean outputKeyInBinary) {
        this.outputKeyInBinary = outputKeyInBinary;
    }

    public boolean isOutputKeyInBinary() {
        return this.outputKeyInBinary;
    }

    public void setSecretKeyLengthFieldName(String secretKeyLengthFieldName) {
        this.secretKeyLengthFieldName = secretKeyLengthFieldName;
    }

    public String getAlgorithmFieldName() {
        return this.algorithmFieldName;
    }

    public void setAlgorithmFieldName(String algorithmFieldName) {
        this.algorithmFieldName = algorithmFieldName;
    }

    public void setFieldAlgorithm(String[] fieldName) {
        this.algorithm = fieldName;
    }

    public void setScheme(String[] scheme) {
        this.scheme = scheme;
    }

    public String[] getSecretKeyLength() {
        return this.secretKeyLength;
    }

    public String[] getSecretKeyCount() {
        return this.secretKeyCount;
    }

    public void setFieldType(String[] fieldType) {
        this.secretKeyLength = fieldType;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    public void allocate(int count) {
        this.algorithm = new String[count];
        this.scheme = new String[count];
        this.secretKeyLength = new String[count];
        this.secretKeyCount = new String[count];
    }

    @Override
    public Object clone() {
        SecretKeyGeneratorMeta retval = (SecretKeyGeneratorMeta)super.clone();
        int count = this.algorithm.length;
        retval.allocate(count);
        System.arraycopy(this.algorithm, 0, retval.algorithm, 0, count);
        System.arraycopy(this.scheme, 0, retval.scheme, 0, count);
        System.arraycopy(this.secretKeyLength, 0, retval.secretKeyLength, 0, count);
        System.arraycopy(this.secretKeyCount, 0, retval.secretKeyCount, 0, count);
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int count = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(count);
            for (int i = 0; i < count; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.algorithm[i] = XMLHandler.getTagValue((Node)fnode, (String)"algorithm");
                this.scheme[i] = XMLHandler.getTagValue((Node)fnode, (String)"scheme");
                this.secretKeyLength[i] = XMLHandler.getTagValue((Node)fnode, (String)"secretKeyLen");
                this.secretKeyCount[i] = XMLHandler.getTagValue((Node)fnode, (String)"secretKeyCount");
            }
            this.secretKeyFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"secretKeyFieldName");
            this.secretKeyLengthFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"secretKeyLengthFieldName");
            this.algorithmFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"algorithmFieldName");
            this.outputKeyInBinary = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"outputKeyInBinary"));
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to read step information from XML", (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        int count = 0;
        this.allocate(count);
        for (int i = 0; i < count; ++i) {
            this.algorithm[i] = "field" + i;
            this.scheme[i] = "";
            this.secretKeyLength[i] = "";
            this.secretKeyCount[i] = "";
        }
        this.secretKeyFieldName = BaseMessages.getString(PKG, (String)"SecretKeyGeneratorMeta.secretKeyField", (String[])new String[0]);
        this.secretKeyLengthFieldName = BaseMessages.getString(PKG, (String)"SecretKeyGeneratorMeta.secretKeyLengthField", (String[])new String[0]);
        this.algorithmFieldName = BaseMessages.getString(PKG, (String)"SecretKeyGeneratorMeta.algorithmField", (String[])new String[0]);
        this.outputKeyInBinary = false;
    }

    @Override
    public void getFields(RowMetaInterface row, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        Object v = this.isOutputKeyInBinary() ? new ValueMetaBinary(this.secretKeyFieldName) : new ValueMetaString(this.secretKeyFieldName);
        v.setOrigin(name);
        row.addValueMeta((ValueMetaInterface)v);
        if (!Const.isEmpty((String)this.getAlgorithmFieldName())) {
            v = new ValueMetaString(this.algorithmFieldName);
            v.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)v);
        }
        if (!Const.isEmpty((String)this.getSecretKeyLengthFieldName())) {
            v = new ValueMetaInteger(this.secretKeyLengthFieldName);
            v.setLength(10, 0);
            v.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)v);
        }
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(200);
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.algorithm.length; ++i) {
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"algorithm", (String)this.algorithm[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"scheme", (String)this.scheme[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"secretKeyLen", (String)this.secretKeyLength[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"secretKeyCount", (String)this.secretKeyCount[i]));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>" + Const.CR);
        retval.append("    " + XMLHandler.addTagValue((String)"secretKeyFieldName", (String)this.secretKeyFieldName));
        retval.append("    " + XMLHandler.addTagValue((String)"secretKeyLengthFieldName", (String)this.secretKeyLengthFieldName));
        retval.append("    " + XMLHandler.addTagValue((String)"algorithmFieldName", (String)this.algorithmFieldName));
        retval.append("    " + XMLHandler.addTagValue((String)"algorithmFieldName", (String)this.algorithmFieldName));
        retval.append("    " + XMLHandler.addTagValue((String)"outputKeyInBinary", (boolean)this.outputKeyInBinary));
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            int nrfields = rep.countNrStepAttributes(id_step, "cctype");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.algorithm[i] = rep.getStepAttributeString(id_step, i, "algorithm");
                this.scheme[i] = rep.getStepAttributeString(id_step, i, "scheme");
                this.secretKeyLength[i] = rep.getStepAttributeString(id_step, i, "secretKeyLen");
                this.secretKeyCount[i] = rep.getStepAttributeString(id_step, i, "secretKeyCount");
            }
            this.secretKeyFieldName = rep.getStepAttributeString(id_step, "secretKeyFieldName");
            this.secretKeyLengthFieldName = rep.getStepAttributeString(id_step, "secretKeyLengthFieldName");
            this.algorithmFieldName = rep.getStepAttributeString(id_step, "algorithmFieldName");
            this.outputKeyInBinary = rep.getStepAttributeBoolean(id_step, "outputKeyInBinary");
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            for (int i = 0; i < this.algorithm.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "algorithm", this.algorithm[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "scheme", this.scheme[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "secretKeyLen", this.secretKeyLength[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "secretKeyCount", this.secretKeyCount[i]);
            }
            rep.saveStepAttribute(id_transformation, id_step, "secretKeyFieldName", this.secretKeyFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "secretKeyLengthFieldName", this.secretKeyLengthFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "algorithmFieldName", this.algorithmFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "outputKeyInBinary", this.outputKeyInBinary);
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        int nrRemarks = remarks.size();
        for (int i = 0; i < this.algorithm.length; ++i) {
            int size;
            int len = Const.toInt((String)transMeta.environmentSubstitute(this.getSecretKeyLength()[i]), (int)-1);
            if (len < 0) {
                CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SecretKeyGeneratorMeta.CheckResult.WrongLen", (String[])new String[]{String.valueOf(i)}), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            if ((size = Const.toInt((String)transMeta.environmentSubstitute(this.getSecretKeyCount()[i]), (int)-1)) >= 0) continue;
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SecretKeyGeneratorMeta.CheckResult.WrongSize", (String[])new String[]{String.valueOf(i)}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (remarks.size() == nrRemarks) {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SecretKeyGeneratorMeta.CheckResult.AllTypesSpecified", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (Const.isEmpty((String)this.getSecretKeyFieldName())) {
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SecretKeyGeneratorMeta.CheckResult.secretKeyFieldMissing", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new SecretKeyGenerator(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new SecretKeyGeneratorData();
    }
}

