/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.synchronizeaftermerge;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.database.OracleDatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseBatchException;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.synchronizeaftermerge.SynchronizeAfterMergeData;
import org.pentaho.di.trans.steps.synchronizeaftermerge.SynchronizeAfterMergeMeta;

public class SynchronizeAfterMerge
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = SynchronizeAfterMergeMeta.class;
    private SynchronizeAfterMergeMeta meta;
    private SynchronizeAfterMergeData data;

    public SynchronizeAfterMerge(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    /*
     * Unable to fully structure code
     */
    private synchronized void lookupValues(Object[] row) throws KettleException {
        operation = this.data.inputRowMeta.getString(row, this.data.indexOfOperationOrderField);
        rowIsSafe = false;
        sendToErrorRow = false;
        errorMessage = null;
        updateCounts = null;
        exceptionsList = null;
        batchProblem = false;
        this.data.lookupFailure = false;
        performInsert = false;
        performUpdate = false;
        performDelete = false;
        lineSkipped = false;
        try {
            if (operation == null) {
                throw new KettleException(BaseMessages.getString(SynchronizeAfterMerge.PKG, (String)"SynchronizeAfterMerge.Log.OperationFieldEmpty", (String[])new String[]{this.meta.getOperationOrderField()}));
            }
            if (this.meta.istablenameInField()) {
                this.data.realTableName = this.data.inputRowMeta.getString(row, this.data.indexOfTableNameField);
                if (Const.isEmpty((String)this.data.realTableName)) {
                    throw new KettleStepException("The name of the table is not specified!");
                }
                this.data.realSchemaTable = this.data.db.getDatabaseMeta().getQuotedSchemaTableCombination(this.data.realSchemaName, this.data.realTableName);
            }
            if (operation.equals(this.data.insertValue)) {
                if (this.log.isRowLevel()) {
                    this.logRowlevel(BaseMessages.getString(SynchronizeAfterMerge.PKG, (String)"SynchronizeAfterMerge.InsertRow", (String[])new String[]{row.toString()}));
                }
                insertRowData = new Object[this.data.valuenrs.length];
                for (i = 0; i < this.data.valuenrs.length; ++i) {
                    insertRowData[i] = row[this.data.valuenrs[i]];
                }
                if (this.meta.istablenameInField()) {
                    this.data.insertStatement = this.data.preparedStatements.get(this.data.realSchemaTable + "insert");
                    if (this.data.insertStatement == null) {
                        sql = this.data.db.getInsertStatement(this.data.realSchemaName, this.data.realTableName, this.data.insertRowMeta);
                        if (this.log.isDebug()) {
                            this.logDebug("Preparation of the insert SQL statement: " + sql);
                        }
                        this.data.insertStatement = this.data.db.prepareSQL(sql);
                        this.data.preparedStatements.put(this.data.realSchemaTable + "insert", this.data.insertStatement);
                    }
                }
                if (this.data.specialErrorHandling && this.data.supportsSavepoints) {
                    this.data.savepoint = this.data.db.setSavepoint();
                }
                this.data.db.setValues(this.data.insertRowMeta, insertRowData, this.data.insertStatement);
                this.data.db.insertRow(this.data.insertStatement, this.data.batchMode);
                performInsert = true;
                if (!this.data.batchMode) {
                    this.incrementLinesOutput();
                }
                if (this.log.isRowLevel()) {
                    this.logRowlevel("Written row: " + this.data.insertRowMeta.getString(insertRowData));
                }
            } else {
                lookupRow = new Object[this.data.keynrs.length];
                lookupIndex = 0;
                for (i = 0; i < this.meta.getKeyStream().length; ++i) {
                    if (this.data.keynrs[i] >= 0) {
                        lookupRow[lookupIndex] = row[this.data.keynrs[i]];
                        ++lookupIndex;
                    }
                    if (this.data.keynrs2[i] < 0) continue;
                    lookupRow[lookupIndex] = row[this.data.keynrs2[i]];
                    ++lookupIndex;
                }
                updateorDelete = false;
                if (this.meta.isPerformLookup()) {
                    if (this.meta.istablenameInField()) {
                        this.data.lookupStatement = this.data.preparedStatements.get(this.data.realSchemaTable + "lookup");
                        if (this.data.lookupStatement == null) {
                            sql = this.getLookupStatement(this.data.inputRowMeta);
                            if (this.log.isDebug()) {
                                this.logDebug("Preparating SQL for insert: " + sql);
                            }
                            this.data.lookupStatement = this.data.db.prepareSQL(sql);
                            this.data.preparedStatements.put(this.data.realSchemaTable + "lookup", this.data.lookupStatement);
                        }
                    }
                    this.data.db.setValues(this.data.lookupParameterRowMeta, lookupRow, this.data.lookupStatement);
                    if (this.log.isRowLevel()) {
                        this.logRowlevel(BaseMessages.getString(SynchronizeAfterMerge.PKG, (String)"SynchronizeAfterMerge.Log.ValuesSetForLookup", (String[])new String[]{this.data.lookupParameterRowMeta.getString(lookupRow)}));
                    }
                    add = this.data.db.getLookup(this.data.lookupStatement);
                    this.incrementLinesInput();
                    if (add == null) {
                        if (this.data.stringErrorKeyNotFound == null) {
                            this.data.stringErrorKeyNotFound = BaseMessages.getString(SynchronizeAfterMerge.PKG, (String)"SynchronizeAfterMerge.Exception.KeyCouldNotFound", (String[])new String[0]) + this.data.lookupParameterRowMeta.getString(lookupRow);
                            this.data.stringFieldnames = "";
                            for (i = 0; i < this.data.lookupParameterRowMeta.size(); ++i) {
                                if (i > 0) {
                                    this.data.stringFieldnames = this.data.stringFieldnames + ", ";
                                }
                                this.data.stringFieldnames = this.data.stringFieldnames + this.data.lookupParameterRowMeta.getValueMeta(i).getName();
                            }
                        }
                        this.data.lookupFailure = true;
                        throw new KettleDatabaseException(BaseMessages.getString(SynchronizeAfterMerge.PKG, (String)"SynchronizeAfterMerge.Exception.KeyCouldNotFound", (String[])new String[]{this.data.lookupParameterRowMeta.getString(lookupRow)}));
                    }
                    if (this.log.isRowLevel()) {
                        this.logRowlevel(BaseMessages.getString(SynchronizeAfterMerge.PKG, (String)"SynchronizeAfterMerge.Log.FoundRowForUpdate", (String[])new String[]{this.data.insertRowMeta.getString(row)}));
                    }
                    for (i = 0; i < this.data.valuenrs.length; ++i) {
                        if (!this.meta.getUpdate()[i].booleanValue() || (valueMeta = this.data.inputRowMeta.getValueMeta(this.data.valuenrs[i])).compare(rowvalue = row[this.data.valuenrs[i]], retMeta = this.data.db.getReturnRowMeta().getValueMeta(i), retvalue = add[i]) == 0) continue;
                        updateorDelete = true;
                    }
                }
                if (operation.equals(this.data.updateValue)) {
                    if (!this.meta.isPerformLookup() || updateorDelete) {
                        if (this.meta.istablenameInField()) {
                            this.data.updateStatement = this.data.preparedStatements.get(this.data.realSchemaTable + "update");
                            if (this.data.updateStatement == null) {
                                sql = this.getUpdateStatement(this.data.inputRowMeta);
                                this.data.updateStatement = this.data.db.prepareSQL(sql);
                                this.data.preparedStatements.put(this.data.realSchemaTable + "update", this.data.updateStatement);
                                if (this.log.isDebug()) {
                                    this.logDebug("Preparation of the Update SQL statement : " + sql);
                                }
                            }
                        }
                        updateRow = new Object[this.data.updateParameterRowMeta.size()];
                        j = 0;
                        for (i = 0; i < this.data.valuenrs.length; ++i) {
                            if (!this.meta.getUpdate()[i].booleanValue()) continue;
                            updateRow[j] = row[this.data.valuenrs[i]];
                            ++j;
                        }
                        for (i = 0; i < lookupRow.length; ++i) {
                            updateRow[j + i] = lookupRow[i];
                        }
                        if (this.data.specialErrorHandling && this.data.supportsSavepoints) {
                            this.data.savepoint = this.data.db.setSavepoint();
                        }
                        this.data.db.setValues(this.data.updateParameterRowMeta, updateRow, this.data.updateStatement);
                        if (this.log.isRowLevel()) {
                            this.logRowlevel(BaseMessages.getString(SynchronizeAfterMerge.PKG, (String)"SynchronizeAfterMerge.Log.SetValuesForUpdate", (String[])new String[]{this.data.updateParameterRowMeta.getString(updateRow), this.data.inputRowMeta.getString(row)}));
                        }
                        this.data.db.insertRow(this.data.updateStatement, this.data.batchMode);
                        performUpdate = true;
                        this.incrementLinesUpdated();
                    } else {
                        this.incrementLinesSkipped();
                        lineSkipped = true;
                    }
                } else if (operation.equals(this.data.deleteValue)) {
                    if (this.meta.istablenameInField()) {
                        this.data.deleteStatement = this.data.preparedStatements.get(this.data.realSchemaTable + "delete");
                        if (this.data.deleteStatement == null) {
                            sql = this.getDeleteStatement(this.data.inputRowMeta);
                            this.data.deleteStatement = this.data.db.prepareSQL(sql);
                            this.data.preparedStatements.put(this.data.realSchemaTable + "delete", this.data.deleteStatement);
                            if (this.log.isDebug()) {
                                this.logDebug("Preparation of the Delete SQL statement : " + sql);
                            }
                        }
                    }
                    deleteRow = new Object[this.data.deleteParameterRowMeta.size()];
                    deleteIndex = 0;
                    for (i = 0; i < this.meta.getKeyStream().length; ++i) {
                        if (this.data.keynrs[i] >= 0) {
                            deleteRow[deleteIndex] = row[this.data.keynrs[i]];
                            ++deleteIndex;
                        }
                        if (this.data.keynrs2[i] < 0) continue;
                        deleteRow[deleteIndex] = row[this.data.keynrs2[i]];
                        ++deleteIndex;
                    }
                    if (this.data.specialErrorHandling && this.data.supportsSavepoints) {
                        this.data.savepoint = this.data.db.setSavepoint();
                    }
                    this.data.db.setValues(this.data.deleteParameterRowMeta, deleteRow, this.data.deleteStatement);
                    if (this.log.isRowLevel()) {
                        this.logRowlevel(BaseMessages.getString(SynchronizeAfterMerge.PKG, (String)"SynchronizeAfterMerge.Log.SetValuesForDelete", (String[])new String[]{this.data.deleteParameterRowMeta.getString(deleteRow), this.data.inputRowMeta.getString(row)}));
                    }
                    this.data.db.insertRow(this.data.deleteStatement, this.data.batchMode);
                    performDelete = true;
                    this.incrementLinesUpdated();
                } else {
                    this.incrementLinesSkipped();
                    lineSkipped = true;
                }
            }
            if (performInsert || performUpdate || performDelete || this.data.batchBuffer.size() > 0 && lineSkipped) {
                tableName = this.data.realSchemaTable;
                if (performInsert) {
                    tableName = tableName + "insert";
                } else if (performUpdate) {
                    tableName = tableName + "update";
                }
                if (performDelete) {
                    tableName = tableName + "delete";
                }
                if ((commitCounter = this.data.commitCounterMap.get(tableName)) == null) {
                    commitCounter = 0;
                }
                this.data.commitCounterMap.put(tableName, commitCounter + 1);
                if (this.data.specialErrorHandling && this.data.supportsSavepoints && this.data.releaseSavepoint) {
                    this.data.db.releaseSavepoint(this.data.savepoint);
                }
                if (commitCounter > 0 && commitCounter % this.data.commitSize == 0) {
                    if (this.data.batchMode) {
                        try {
                            if (performInsert) {
                                this.data.insertStatement.executeBatch();
                                this.data.db.commit();
                                this.data.insertStatement.clearBatch();
                            }
                            if (performUpdate) {
                                this.data.updateStatement.executeBatch();
                                this.data.db.commit();
                                this.data.updateStatement.clearBatch();
                            }
                            if (!performDelete) ** GOTO lbl204
                            this.data.deleteStatement.executeBatch();
                            this.data.db.commit();
                            this.data.deleteStatement.clearBatch();
                        }
                        catch (SQLException ex) {
                            throw Database.createKettleDatabaseBatchException((String)BaseMessages.getString(SynchronizeAfterMerge.PKG, (String)"SynchronizeAfterMerge.Error.UpdatingBatch", (String[])new String[0]), (SQLException)ex);
                        }
                        catch (Exception ex) {
                            throw new KettleDatabaseException("Unexpected error inserting row", (Throwable)ex);
                        }
                    } else {
                        this.data.db.commit();
                    }
lbl204:
                    // 5 sources

                    this.data.commitCounterMap.put(tableName, 0);
                    rowIsSafe = true;
                } else {
                    rowIsSafe = false;
                }
            }
        }
        catch (KettleDatabaseBatchException be) {
            errorMessage = be.toString();
            batchProblem = true;
            sendToErrorRow = true;
            updateCounts = be.getUpdateCounts();
            exceptionsList = be.getExceptionsList();
            if (this.data.insertStatement != null) {
                this.data.db.clearBatch(this.data.insertStatement);
            }
            if (this.data.updateStatement != null) {
                this.data.db.clearBatch(this.data.updateStatement);
            }
            if (this.data.deleteStatement != null) {
                this.data.db.clearBatch(this.data.deleteStatement);
            }
            if (this.getStepMeta().isDoingErrorHandling()) {
                this.data.db.commit(true);
            }
            this.data.db.rollback();
            msg = new StringBuilder("Error batch inserting rows into table [" + this.data.realTableName + "].");
            msg.append(Const.CR);
            msg.append("Errors encountered (first 10):").append(Const.CR);
            for (x = 0; x < be.getExceptionsList().size() && x < 10; ++x) {
                exception = (Exception)be.getExceptionsList().get(x);
                if (exception.getMessage() == null) continue;
                msg.append(exception.getMessage()).append(Const.CR);
            }
            throw new KettleException(msg.toString(), (Throwable)be);
        }
        catch (KettleDatabaseException dbe) {
            if (this.getStepMeta().isDoingErrorHandling()) {
                if (this.log.isRowLevel()) {
                    this.logRowlevel("Written row to error handling : " + this.getInputRowMeta().getString(row));
                }
                if (this.data.specialErrorHandling && this.data.supportsSavepoints && (this.data.savepoint != null || !this.data.lookupFailure)) {
                    this.data.db.rollback(this.data.savepoint);
                    if (this.data.releaseSavepoint) {
                        this.data.db.releaseSavepoint(this.data.savepoint);
                    }
                }
                sendToErrorRow = true;
                errorMessage = dbe.toString();
            }
            this.setErrors(this.getErrors() + 1L);
            this.data.db.rollback();
            throw new KettleException("Error inserting row into table [" + this.data.realTableName + "] with values: " + this.data.inputRowMeta.getString(row), (Throwable)dbe);
        }
        if (this.data.batchMode) {
            if (sendToErrorRow) {
                if (batchProblem) {
                    this.data.batchBuffer.add(row);
                    this.processBatchException(errorMessage, updateCounts, exceptionsList);
                } else {
                    this.putError(this.data.inputRowMeta, row, 1L, errorMessage, null, "SUYNC002");
                }
            } else {
                if (!lineSkipped) {
                    this.data.batchBuffer.add(row);
                }
                if (rowIsSafe) {
                    for (i = 0; i < this.data.batchBuffer.size(); ++i) {
                        rowb = this.data.batchBuffer.get(i);
                        this.putRow(this.data.outputRowMeta, rowb);
                        if (!this.data.inputRowMeta.getString(rowb, this.data.indexOfOperationOrderField).equals(this.data.insertValue)) continue;
                        this.incrementLinesOutput();
                    }
                    this.data.batchBuffer.clear();
                }
                if (lineSkipped) {
                    this.putRow(this.data.outputRowMeta, row);
                }
            }
        } else if (sendToErrorRow) {
            if (this.data.lookupFailure) {
                this.putError(this.data.inputRowMeta, row, 1L, this.data.stringErrorKeyNotFound, this.data.stringFieldnames, "SUYNC001");
            } else {
                this.putError(this.data.inputRowMeta, row, 1L, errorMessage, null, "SUYNC001");
            }
        }
    }

    private void processBatchException(String errorMessage, int[] updateCounts, List<Exception> exceptionsList) throws KettleException {
        if (updateCounts != null) {
            int errNr = 0;
            for (int i = 0; i < updateCounts.length; ++i) {
                Object[] row = this.data.batchBuffer.get(i);
                if (updateCounts[i] > 0) {
                    this.putRow(this.data.outputRowMeta, row);
                    this.incrementLinesOutput();
                    continue;
                }
                String exMessage = errorMessage;
                if (errNr < exceptionsList.size()) {
                    SQLException se = (SQLException)exceptionsList.get(errNr);
                    ++errNr;
                    exMessage = se.toString();
                }
                this.putError(this.data.outputRowMeta, row, 1L, exMessage, null, "SUYNC002");
            }
        } else {
            for (int i = 0; i < this.data.batchBuffer.size(); ++i) {
                Object[] row = this.data.batchBuffer.get(i);
                this.putError(this.data.outputRowMeta, row, 1L, errorMessage, null, "SUYNC003");
            }
        }
        this.data.batchBuffer.clear();
    }

    public String getLookupStatement(RowMetaInterface rowMeta) throws KettleDatabaseException {
        int i;
        this.data.lookupParameterRowMeta = new RowMeta();
        this.data.lookupReturnRowMeta = new RowMeta();
        DatabaseMeta databaseMeta = this.meta.getDatabaseMeta();
        String sql = "SELECT ";
        for (i = 0; i < this.meta.getUpdateLookup().length; ++i) {
            if (i != 0) {
                sql = sql + ", ";
            }
            sql = sql + databaseMeta.quoteField(this.meta.getUpdateLookup()[i]);
            this.data.lookupReturnRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getUpdateStream()[i]).clone());
        }
        sql = sql + " FROM " + this.data.realSchemaTable + " WHERE ";
        for (i = 0; i < this.meta.getKeyLookup().length; ++i) {
            if (i != 0) {
                sql = sql + " AND ";
            }
            sql = sql + databaseMeta.quoteField(this.meta.getKeyLookup()[i]);
            if ("BETWEEN".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                sql = sql + " BETWEEN ? AND ? ";
                this.data.lookupParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream()[i]));
                this.data.lookupParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream2()[i]));
                continue;
            }
            if ("IS NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i]) || "IS NOT NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                sql = sql + " " + this.meta.getKeyCondition()[i] + " ";
                continue;
            }
            sql = sql + " " + this.meta.getKeyCondition()[i] + " ? ";
            this.data.lookupParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream()[i]));
        }
        return sql;
    }

    public String getUpdateStatement(RowMetaInterface rowMeta) throws KettleDatabaseException {
        int i;
        DatabaseMeta databaseMeta = this.meta.getDatabaseMeta();
        this.data.updateParameterRowMeta = new RowMeta();
        String sql = "UPDATE " + this.data.realSchemaTable + Const.CR;
        sql = sql + "SET ";
        boolean comma = false;
        for (i = 0; i < this.meta.getUpdateLookup().length; ++i) {
            if (!this.meta.getUpdate()[i].booleanValue()) continue;
            if (comma) {
                sql = sql + ",   ";
            } else {
                comma = true;
            }
            sql = sql + databaseMeta.quoteField(this.meta.getUpdateLookup()[i]);
            sql = sql + " = ?" + Const.CR;
            this.data.updateParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getUpdateStream()[i]).clone());
        }
        sql = sql + "WHERE ";
        for (i = 0; i < this.meta.getKeyLookup().length; ++i) {
            if (i != 0) {
                sql = sql + "AND   ";
            }
            sql = sql + databaseMeta.quoteField(this.meta.getKeyLookup()[i]);
            if ("BETWEEN".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                sql = sql + " BETWEEN ? AND ? ";
                this.data.updateParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream()[i]));
                this.data.updateParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream2()[i]));
                continue;
            }
            if ("IS NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i]) || "IS NOT NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                sql = sql + " " + this.meta.getKeyCondition()[i] + " ";
                continue;
            }
            sql = sql + " " + this.meta.getKeyCondition()[i] + " ? ";
            this.data.updateParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream()[i]).clone());
        }
        return sql;
    }

    public String getDeleteStatement(RowMetaInterface rowMeta) throws KettleDatabaseException {
        DatabaseMeta databaseMeta = this.meta.getDatabaseMeta();
        this.data.deleteParameterRowMeta = new RowMeta();
        String sql = "DELETE FROM " + this.data.realSchemaTable + Const.CR;
        sql = sql + "WHERE ";
        for (int i = 0; i < this.meta.getKeyLookup().length; ++i) {
            if (i != 0) {
                sql = sql + "AND   ";
            }
            sql = sql + databaseMeta.quoteField(this.meta.getKeyLookup()[i]);
            if ("BETWEEN".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                sql = sql + " BETWEEN ? AND ? ";
                this.data.deleteParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream()[i]));
                this.data.deleteParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream2()[i]));
                continue;
            }
            if ("IS NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i]) || "IS NOT NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                sql = sql + " " + this.meta.getKeyCondition()[i] + " ";
                continue;
            }
            sql = sql + " " + this.meta.getKeyCondition()[i] + " ? ";
            this.data.deleteParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream()[i]));
        }
        return sql;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (SynchronizeAfterMergeMeta)smi;
        this.data = (SynchronizeAfterMergeData)sdi;
        Object[] nextRow = this.getRow();
        if (nextRow == null) {
            this.finishStep();
            return false;
        }
        if (this.first) {
            int i;
            this.first = false;
            this.data.inputRowMeta = this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
            if (this.meta.istablenameInField()) {
                if (this.data.indexOfTableNameField < 0) {
                    this.data.indexOfTableNameField = this.data.inputRowMeta.indexOfValue(this.meta.gettablenameField());
                    if (this.data.indexOfTableNameField < 0) {
                        String message = "It was not possible to find table [" + this.meta.gettablenameField() + "] in the input fields.";
                        this.logError(message);
                        throw new KettleStepException(message);
                    }
                }
            } else {
                this.data.realTableName = this.environmentSubstitute(this.meta.getTableName());
                if (Const.isEmpty((String)this.data.realTableName)) {
                    throw new KettleStepException("The table name is not specified (or the input field is empty)");
                }
                this.data.realSchemaTable = this.data.db.getDatabaseMeta().getQuotedSchemaTableCombination(this.data.realSchemaName, this.data.realTableName);
            }
            if (this.data.indexOfOperationOrderField < 0) {
                this.data.indexOfOperationOrderField = this.data.inputRowMeta.indexOfValue(this.meta.getOperationOrderField());
                if (this.data.indexOfOperationOrderField < 0) {
                    String message = "It was not possible to find operation field [" + this.meta.getOperationOrderField() + "] in the input stream!";
                    this.logError(message);
                    throw new KettleStepException(message);
                }
            }
            this.data.insertValue = this.environmentSubstitute(this.meta.getOrderInsert());
            this.data.updateValue = this.environmentSubstitute(this.meta.getOrderUpdate());
            this.data.deleteValue = this.environmentSubstitute(this.meta.getOrderDelete());
            this.data.insertRowMeta = new RowMeta();
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"SynchronizeAfterMerge.Log.CheckingRow", (String[])new String[0]) + Arrays.toString(nextRow));
            }
            this.data.keynrs = new int[this.meta.getKeyStream().length];
            this.data.keynrs2 = new int[this.meta.getKeyStream().length];
            for (i = 0; i < this.meta.getKeyStream().length; ++i) {
                this.data.keynrs[i] = this.data.inputRowMeta.indexOfValue(this.meta.getKeyStream()[i]);
                if (this.data.keynrs[i] < 0 && !"IS NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i]) && !"IS NOT NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"SynchronizeAfterMerge.Exception.FieldRequired", (String[])new String[]{this.meta.getKeyStream()[i]}));
                }
                this.data.keynrs2[i] = this.data.inputRowMeta.indexOfValue(this.meta.getKeyStream2()[i]);
                if (this.data.keynrs2[i] < 0 && "BETWEEN".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"SynchronizeAfterMerge.Exception.FieldRequired", (String[])new String[]{this.meta.getKeyStream2()[i]}));
                }
                if (!this.log.isDebug()) continue;
                this.logDebug(BaseMessages.getString(PKG, (String)"SynchronizeAfterMerge.Log.FieldHasDataNumbers", (String[])new String[]{this.meta.getKeyStream()[i]}) + this.data.keynrs[i]);
            }
            for (i = 0; i < this.meta.getUpdateLookup().length; ++i) {
                ValueMetaInterface insValue = this.data.insertRowMeta.searchValueMeta(this.meta.getUpdateLookup()[i]);
                if (insValue != null) {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"SynchronizeAfterMerge.Error.SameColumnInsertedTwice", (String[])new String[]{insValue.getName()}));
                }
                ValueMetaInterface insertValue = this.data.inputRowMeta.searchValueMeta(this.meta.getUpdateStream()[i]).clone();
                insertValue.setName(this.meta.getUpdateLookup()[i]);
                this.data.insertRowMeta.addValueMeta(insertValue);
            }
            this.data.valuenrs = new int[this.meta.getUpdateLookup().length];
            for (i = 0; i < this.meta.getUpdateLookup().length; ++i) {
                this.data.valuenrs[i] = this.data.inputRowMeta.indexOfValue(this.meta.getUpdateStream()[i]);
                if (this.data.valuenrs[i] < 0) {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"SynchronizeAfterMerge.Exception.FieldRequired", (String[])new String[]{this.meta.getUpdateStream()[i]}));
                }
                if (!this.log.isDebug()) continue;
                this.logDebug(BaseMessages.getString(PKG, (String)"SynchronizeAfterMerge.Log.FieldHasDataNumbers", (String[])new String[]{this.meta.getUpdateStream()[i]}) + this.data.valuenrs[i]);
            }
            if (!this.meta.istablenameInField()) {
                if (this.meta.isPerformLookup()) {
                    this.data.lookupStatement = this.data.preparedStatements.get(this.data.realSchemaTable + "lookup");
                    if (this.data.lookupStatement == null) {
                        String sql = this.getLookupStatement(this.data.inputRowMeta);
                        if (this.log.isDebug()) {
                            this.logDebug("Preparation of the lookup SQL statement : " + sql);
                        }
                        this.data.lookupStatement = this.data.db.prepareSQL(sql);
                        this.data.preparedStatements.put(this.data.realSchemaTable + "lookup", this.data.lookupStatement);
                    }
                }
                this.data.insertStatement = this.data.preparedStatements.get(this.data.realSchemaTable + "insert");
                if (this.data.insertStatement == null) {
                    String sql = this.data.db.getInsertStatement(this.data.realSchemaName, this.data.realTableName, this.data.insertRowMeta);
                    if (this.log.isDebug()) {
                        this.logDebug("Preparation of the Insert SQL statement : " + sql);
                    }
                    this.data.insertStatement = this.data.db.prepareSQL(sql);
                    this.data.preparedStatements.put(this.data.realSchemaTable + "insert", this.data.insertStatement);
                }
                this.data.updateStatement = this.data.preparedStatements.get(this.data.realSchemaTable + "update");
                if (this.data.updateStatement == null) {
                    String sql = this.getUpdateStatement(this.data.inputRowMeta);
                    this.data.updateStatement = this.data.db.prepareSQL(sql);
                    this.data.preparedStatements.put(this.data.realSchemaTable + "update", this.data.updateStatement);
                    if (this.log.isDebug()) {
                        this.logDebug("Preparation of the Update SQL statement : " + sql);
                    }
                }
                this.data.deleteStatement = this.data.preparedStatements.get(this.data.realSchemaTable + "delete");
                if (this.data.deleteStatement == null) {
                    String sql = this.getDeleteStatement(this.data.inputRowMeta);
                    this.data.deleteStatement = this.data.db.prepareSQL(sql);
                    this.data.preparedStatements.put(this.data.realSchemaTable + "delete", this.data.deleteStatement);
                    if (this.log.isDebug()) {
                        this.logDebug("Preparation of the Delete SQL statement : " + sql);
                    }
                }
            }
        }
        try {
            this.lookupValues(nextRow);
            if (!this.data.batchMode) {
                this.putRow(this.data.outputRowMeta, nextRow);
            }
            if (this.checkFeedback(this.getLinesRead()) && this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"SynchronizeAfterMerge.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
            }
        }
        catch (KettleException e) {
            this.logError("Because of an error, this step can't continue: ", e);
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (SynchronizeAfterMergeMeta)smi;
        this.data = (SynchronizeAfterMergeData)sdi;
        if (super.init(smi, sdi)) {
            try {
                this.data.realSchemaName = this.environmentSubstitute(this.meta.getSchemaName());
                if (this.meta.istablenameInField() && Const.isEmpty((String)this.meta.gettablenameField())) {
                    this.logError(BaseMessages.getString(PKG, (String)"SynchronizeAfterMerge.Log.Error.TableFieldnameEmpty", (String[])new String[0]));
                    return false;
                }
                this.data.databaseMeta = this.meta.getDatabaseMeta();
                if (this.data.databaseMeta.getDatabaseInterface() instanceof OracleDatabaseMeta) {
                    this.data.releaseSavepoint = false;
                }
                this.data.commitSize = Integer.parseInt(this.environmentSubstitute("" + this.meta.getCommitSize()));
                this.data.batchMode = this.data.commitSize > 0 && this.meta.useBatchUpdate();
                this.data.specialErrorHandling = this.getStepMeta().isDoingErrorHandling() && this.meta.getDatabaseMeta().supportsErrorHandlingOnBatchUpdates();
                this.data.supportsSavepoints = this.meta.getDatabaseMeta().getDatabaseInterface().useSafePoints();
                if (this.data.batchMode && this.data.specialErrorHandling) {
                    this.data.batchMode = false;
                    if (this.log.isBasic()) {
                        this.logBasic(BaseMessages.getString(PKG, (String)"SynchronizeAfterMerge.Log.BatchModeDisabled", (String[])new String[0]));
                    }
                }
                if (this.meta.getDatabaseMeta() == null) {
                    this.logError(BaseMessages.getString(PKG, (String)"SynchronizeAfterMerge.Init.ConnectionMissing", (String[])new String[]{this.getStepname()}));
                    return false;
                }
                this.data.db = new Database((LoggingObjectInterface)this, this.meta.getDatabaseMeta());
                this.data.db.shareVariablesWith((VariableSpace)this);
                if (this.getTransMeta().isUsingUniqueConnections()) {
                    Trans trans = this.getTrans();
                    synchronized (trans) {
                        this.data.db.connect(this.getTrans().getTransactionId(), this.getPartitionID());
                    }
                } else {
                    this.data.db.connect(this.getPartitionID());
                }
                this.data.db.setCommit(this.meta.getCommitSize());
                return true;
            }
            catch (KettleException ke) {
                this.logError(BaseMessages.getString(PKG, (String)"SynchronizeAfterMerge.Log.ErrorOccurredDuringStepInitialize", (String[])new String[0]) + ke.getMessage());
            }
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.finishStep();
        super.dispose(smi, sdi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishStep() {
        if (this.data.db != null && this.data.db.getConnection() != null) {
            try {
                if (!this.data.db.getConnection().isClosed()) {
                    for (String schemaTable : this.data.preparedStatements.keySet()) {
                        Integer batchCounter = this.data.commitCounterMap.get(schemaTable);
                        if (batchCounter == null) {
                            batchCounter = 0;
                        }
                        PreparedStatement insertStatement = this.data.preparedStatements.get(schemaTable);
                        this.data.db.emptyAndCommit(insertStatement, this.data.batchMode, batchCounter.intValue());
                    }
                    for (int i = 0; i < this.data.batchBuffer.size(); ++i) {
                        Object[] row = this.data.batchBuffer.get(i);
                        this.putRow(this.data.outputRowMeta, row);
                        if (!this.data.inputRowMeta.getString(row, this.data.indexOfOperationOrderField).equals(this.data.insertValue)) continue;
                        this.incrementLinesOutput();
                    }
                    this.data.batchBuffer.clear();
                }
            }
            catch (KettleDatabaseBatchException be) {
                if (this.getStepMeta().isDoingErrorHandling()) {
                    try {
                        this.processBatchException(be.toString(), be.getUpdateCounts(), be.getExceptionsList());
                    }
                    catch (KettleException e) {
                        this.logError("Unexpected error processing batch error", e);
                        this.setErrors(1L);
                        this.stopAll();
                    }
                } else {
                    this.logError("Unexpected batch update error committing the database connection.", be);
                    this.setErrors(1L);
                    this.stopAll();
                }
            }
            catch (Exception dbe) {
                this.logError("Unexpected error committing the database connection.", dbe);
                this.logError(Const.getStackTracker((Throwable)dbe));
                this.setErrors(1L);
                this.stopAll();
            }
            finally {
                this.setOutputDone();
                if (this.getErrors() > 0L) {
                    try {
                        this.data.db.rollback();
                    }
                    catch (KettleDatabaseException e) {
                        this.logError("Unexpected error rolling back the database connection.", e);
                    }
                }
                this.data.db.disconnect();
            }
        }
    }
}

