/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.transexecutor;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LoggingRegistry;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.DelegationListener;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransExecutionConfiguration;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.TransStepUtil;
import org.pentaho.di.trans.steps.transexecutor.TransExecutorData;
import org.pentaho.di.trans.steps.transexecutor.TransExecutorMeta;
import org.pentaho.di.trans.steps.transexecutor.TransExecutorParameters;

public class TransExecutor
extends BaseStep
implements StepInterface {
    private static final Class<?> PKG = TransExecutorMeta.class;
    private TransExecutorMeta meta;
    private TransExecutorData data;

    public TransExecutor(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        try {
            this.meta = (TransExecutorMeta)smi;
            this.setData((TransExecutorData)sdi);
            TransExecutorData transExecutorData = this.getData();
            Object[] row = this.getRow();
            if (row == null) {
                this.executeTransformation();
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                this.initOnFirstProcessingIteration();
            }
            if (transExecutorData.getExecutorStepOutputRowMeta() != null) {
                this.putRowTo(transExecutorData.getExecutorStepOutputRowMeta(), row, transExecutorData.getExecutorStepOutputRowSet());
            }
            if (transExecutorData.groupSize < 0) {
                long now;
                if (transExecutorData.groupFieldIndex >= 0) {
                    Object groupFieldData = row[transExecutorData.groupFieldIndex];
                    if (transExecutorData.prevGroupFieldData != null && transExecutorData.groupFieldMeta.compare(transExecutorData.prevGroupFieldData, groupFieldData) != 0) {
                        this.executeTransformation();
                    }
                    transExecutorData.prevGroupFieldData = groupFieldData;
                } else if (transExecutorData.groupTime > 0 && (now = System.currentTimeMillis()) - transExecutorData.groupTimeStart >= (long)transExecutorData.groupTime) {
                    this.executeTransformation();
                }
            }
            transExecutorData.groupBuffer.add(new RowMetaAndData(this.getInputRowMeta(), row));
            if (transExecutorData.groupSize > 0 && transExecutorData.groupBuffer.size() >= transExecutorData.groupSize) {
                this.executeTransformation();
            }
            return true;
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"TransExecutor.UnexpectedError", (String[])new String[0]), (Throwable)e);
        }
    }

    private void initOnFirstProcessingIteration() throws KettleException {
        TransExecutorData transExecutorData = this.getData();
        transExecutorData.setInputRowMeta(this.getInputRowMeta());
        transExecutorData.setExecutionResultsOutputRowMeta((RowMetaInterface)new RowMeta());
        if (this.meta.getExecutionResultTargetStepMeta() != null) {
            this.meta.prepareExecutionResultsFields(transExecutorData.getExecutionResultsOutputRowMeta(), this.meta.getExecutionResultTargetStepMeta());
            transExecutorData.setExecutionResultRowSet(this.findOutputRowSet(this.meta.getExecutionResultTargetStepMeta().getName()));
        }
        transExecutorData.setResultFilesOutputRowMeta((RowMetaInterface)new RowMeta());
        if (this.meta.getResultFilesTargetStepMeta() != null) {
            this.meta.prepareExecutionResultsFileFields(transExecutorData.getResultFilesOutputRowMeta(), this.meta.getResultFilesTargetStepMeta());
            transExecutorData.setResultFilesRowSet(this.findOutputRowSet(this.meta.getResultFilesTargetStepMeta().getName()));
        }
        transExecutorData.setResultRowsOutputRowMeta((RowMetaInterface)new RowMeta());
        if (this.meta.getOutputRowsSourceStepMeta() != null) {
            this.meta.prepareResultsRowsFields(transExecutorData.getResultRowsOutputRowMeta());
            transExecutorData.setResultRowsRowSet(this.findOutputRowSet(this.meta.getOutputRowsSourceStepMeta().getName()));
        }
        if (this.meta.getExecutorsOutputStepMeta() != null) {
            transExecutorData.setExecutorStepOutputRowMeta(this.getInputRowMeta().clone());
            transExecutorData.setExecutorStepOutputRowSet(this.findOutputRowSet(this.meta.getExecutorsOutputStepMeta().getName()));
        }
        transExecutorData.groupFieldIndex = -1;
        if (!Const.isEmpty((String)transExecutorData.groupField)) {
            transExecutorData.groupFieldIndex = this.getInputRowMeta().indexOfValue(transExecutorData.groupField);
            if (transExecutorData.groupFieldIndex < 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"TransExecutor.Exception.GroupFieldNotFound", (String[])new String[]{transExecutorData.groupField}));
            }
            transExecutorData.groupFieldMeta = this.getInputRowMeta().getValueMeta(transExecutorData.groupFieldIndex);
        }
    }

    private void executeTransformation() throws KettleException {
        TransExecutorData transExecutorData = this.getData();
        if (transExecutorData.groupBuffer.isEmpty()) {
            return;
        }
        transExecutorData.groupTimeStart = System.currentTimeMillis();
        this.discardLogLines(transExecutorData);
        Trans executorTrans = this.createInternalTrans();
        transExecutorData.setExecutorTrans(executorTrans);
        this.passParametersToTrans();
        this.getTrans().getActiveSubtransformations().put(this.getStepname(), executorTrans);
        Result result = new Result();
        result.setRows(transExecutorData.groupBuffer);
        executorTrans.setPreviousResult(result);
        try {
            executorTrans.prepareExecution(this.getTrans().getArguments());
            executorTrans.startThreads();
            for (DelegationListener delegationListener : this.getTrans().getDelegationListeners()) {
                delegationListener.transformationDelegationStarted(executorTrans, new TransExecutionConfiguration());
            }
            executorTrans.waitUntilFinished();
            result = executorTrans.getResult();
        }
        catch (KettleException e) {
            this.log.logError("An error occurred executing the transformation: ", (Throwable)e);
            result.setResult(false);
            result.setNrErrors(1L);
        }
        this.collectTransResults(result);
        this.collectExecutionResults(result);
        this.collectExecutionResultFiles(result);
        transExecutorData.groupBuffer.clear();
    }

    @VisibleForTesting
    void discardLogLines(TransExecutorData transExecutorData) {
        Trans executorTrans = transExecutorData.getExecutorTrans();
        if (executorTrans != null) {
            KettleLogStore.discardLines((String)executorTrans.getLogChannelId(), (boolean)false);
            LoggingRegistry.getInstance().removeIncludingChildren(executorTrans.getLogChannelId());
        }
    }

    @VisibleForTesting
    Trans createInternalTrans() throws KettleException {
        Trans executorTrans = new Trans(this.getData().getExecutorTransMeta(), this);
        executorTrans.setParentTrans(this.getTrans());
        executorTrans.setLogLevel(this.getLogLevel());
        executorTrans.setArguments(this.getTrans().getArguments());
        if (this.meta.getParameters().isInheritingAllVariables()) {
            executorTrans.shareVariablesWith(this);
        }
        executorTrans.setInternalKettleVariables(this);
        executorTrans.copyParametersFrom(this.getData().getExecutorTransMeta());
        executorTrans.setPreview(this.getTrans().isPreview());
        TransStepUtil.initServletConfig(this.getTrans(), executorTrans);
        return executorTrans;
    }

    private void passParametersToTrans() throws KettleException {
        TransExecutorParameters parameters = this.meta.getParameters();
        Trans internalTrans = this.getData().getExecutorTrans();
        internalTrans.clearParameters();
        String[] parameterNames = internalTrans.listParameters();
        for (int i = 0; i < parameters.getVariable().length; ++i) {
            String value;
            String variable = parameters.getVariable()[i];
            String fieldName = parameters.getField()[i];
            String inputValue = parameters.getInput()[i];
            if (!Const.isEmpty((String)fieldName)) {
                int idx = this.getInputRowMeta().indexOfValue(fieldName);
                if (idx < 0) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"TransExecutor.Exception.UnableToFindField", (String[])new String[]{fieldName}));
                }
                value = this.getData().groupBuffer.get(0).getString(idx, "");
            } else {
                value = this.environmentSubstitute(inputValue);
            }
            if (Const.indexOfString((String)variable, (String[])parameterNames) < 0) {
                internalTrans.setVariable(variable, Const.NVL((String)value, (String)""));
                continue;
            }
            internalTrans.setParameterValue(variable, Const.NVL((String)value, (String)""));
        }
        internalTrans.activateParameters();
    }

    private void collectTransResults(Result result) throws KettleException {
        if (this.meta.getOutputRowsSourceStepMeta() != null) {
            RowSet rowSet = this.getData().getResultRowsRowSet();
            for (RowMetaAndData metaAndData : result.getRows()) {
                this.putRowTo(metaAndData.getRowMeta(), metaAndData.getData(), rowSet);
            }
        }
    }

    private void collectExecutionResults(Result result) throws KettleException {
        if (this.meta.getExecutionResultTargetStepMeta() != null) {
            Object[] outputRow = RowDataUtil.allocateRowData((int)this.getData().getExecutionResultsOutputRowMeta().size());
            int idx = 0;
            if (!Const.isEmpty((String)this.meta.getExecutionTimeField())) {
                outputRow[idx++] = System.currentTimeMillis() - this.getData().groupTimeStart;
            }
            if (!Const.isEmpty((String)this.meta.getExecutionResultField())) {
                outputRow[idx++] = result.getResult();
            }
            if (!Const.isEmpty((String)this.meta.getExecutionNrErrorsField())) {
                outputRow[idx++] = result.getNrErrors();
            }
            if (!Const.isEmpty((String)this.meta.getExecutionLinesReadField())) {
                outputRow[idx++] = result.getNrLinesRead();
            }
            if (!Const.isEmpty((String)this.meta.getExecutionLinesWrittenField())) {
                outputRow[idx++] = result.getNrLinesWritten();
            }
            if (!Const.isEmpty((String)this.meta.getExecutionLinesInputField())) {
                outputRow[idx++] = result.getNrLinesInput();
            }
            if (!Const.isEmpty((String)this.meta.getExecutionLinesOutputField())) {
                outputRow[idx++] = result.getNrLinesOutput();
            }
            if (!Const.isEmpty((String)this.meta.getExecutionLinesRejectedField())) {
                outputRow[idx++] = result.getNrLinesRejected();
            }
            if (!Const.isEmpty((String)this.meta.getExecutionLinesUpdatedField())) {
                outputRow[idx++] = result.getNrLinesUpdated();
            }
            if (!Const.isEmpty((String)this.meta.getExecutionLinesDeletedField())) {
                outputRow[idx++] = result.getNrLinesDeleted();
            }
            if (!Const.isEmpty((String)this.meta.getExecutionFilesRetrievedField())) {
                outputRow[idx++] = result.getNrFilesRetrieved();
            }
            if (!Const.isEmpty((String)this.meta.getExecutionExitStatusField())) {
                outputRow[idx++] = (long)result.getExitStatus();
            }
            if (!Const.isEmpty((String)this.meta.getExecutionLogTextField())) {
                String channelId = this.getData().getExecutorTrans().getLogChannelId();
                String logText = KettleLogStore.getAppender().getBuffer(channelId, false).toString();
                outputRow[idx++] = logText;
            }
            if (!Const.isEmpty((String)this.meta.getExecutionLogChannelIdField())) {
                outputRow[idx++] = this.getData().getExecutorTrans().getLogChannelId();
            }
            this.putRowTo(this.getData().getExecutionResultsOutputRowMeta(), outputRow, this.getData().getExecutionResultRowSet());
        }
    }

    private void collectExecutionResultFiles(Result result) throws KettleException {
        if (this.meta.getResultFilesTargetStepMeta() != null && result.getResultFilesList() != null) {
            for (ResultFile resultFile : result.getResultFilesList()) {
                Object[] targetRow = RowDataUtil.allocateRowData((int)this.getData().getResultFilesOutputRowMeta().size());
                int idx = 0;
                targetRow[idx++] = resultFile.getFile().getName().toString();
                this.putRowTo(this.getData().getResultFilesOutputRowMeta(), targetRow, this.getData().getResultFilesRowSet());
            }
        }
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (TransExecutorMeta)smi;
        this.setData((TransExecutorData)sdi);
        TransExecutorData transExecutorData = this.getData();
        if (super.init(smi, sdi)) {
            try {
                this.meta.setRepository(this.getTransMeta().getRepository());
                transExecutorData.setExecutorTransMeta(this.loadExecutorTransMeta());
                if (transExecutorData.getExecutorTransMeta() != null) {
                    transExecutorData.groupBuffer = new ArrayList<RowMetaAndData>();
                    transExecutorData.groupSize = !Const.isEmpty((String)this.meta.getGroupSize()) ? Const.toInt((String)this.environmentSubstitute(this.meta.getGroupSize()), (int)-1) : -1;
                    transExecutorData.groupTime = !Const.isEmpty((String)this.meta.getGroupTime()) ? Const.toInt((String)this.environmentSubstitute(this.meta.getGroupTime()), (int)-1) : -1;
                    transExecutorData.groupTimeStart = System.currentTimeMillis();
                    if (!Const.isEmpty((String)this.meta.getGroupField())) {
                        transExecutorData.groupField = this.environmentSubstitute(this.meta.getGroupField());
                    }
                    return true;
                }
                this.logError("No valid transformation was specified nor loaded!");
                return false;
            }
            catch (Exception e) {
                this.logError("Unable to load the transformation executor because of an error : ", e);
            }
        }
        return false;
    }

    @VisibleForTesting
    TransMeta loadExecutorTransMeta() throws KettleException {
        return TransExecutorMeta.loadTransMeta(this.meta, this.meta.getRepository(), this.meta.getMetaStore(), this);
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        TransExecutorData transExecutorData = this.getData();
        transExecutorData.groupBuffer = null;
        super.dispose(smi, sdi);
    }

    @Override
    public void stopRunning(StepMetaInterface stepMetaInterface, StepDataInterface stepDataInterface) throws KettleException {
        if (this.getData().getExecutorTrans() != null) {
            this.getData().getExecutorTrans().stopAll();
        }
    }

    @Override
    public void stopAll() {
        if (this.getData().getExecutorTrans() != null) {
            this.getData().getExecutorTrans().stopAll();
        }
        super.stopAll();
    }

    public Trans getExecutorTrans() {
        return this.getData().getExecutorTrans();
    }

    @VisibleForTesting
    TransExecutorData getData() {
        return this.data;
    }

    private void setData(TransExecutorData data) {
        this.data = data;
    }
}

