/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle.extensionpoints.trans;

import java.io.IOException;
import java.net.URLConnection;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.KettleClientEnvironment;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.ExtensionPoint;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.parameters.UnknownParamException;
import org.pentaho.di.job.Job;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransListener;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.metaverse.analyzer.kettle.extensionpoints.BaseRuntimeExtensionPoint;
import org.pentaho.metaverse.analyzer.kettle.extensionpoints.trans.TransExtensionPointUtil;
import org.pentaho.metaverse.analyzer.kettle.extensionpoints.trans.TransLineageHolderMap;
import org.pentaho.metaverse.api.AnalysisContext;
import org.pentaho.metaverse.api.IAnalysisContext;
import org.pentaho.metaverse.api.IDocument;
import org.pentaho.metaverse.api.IDocumentAnalyzer;
import org.pentaho.metaverse.api.IMetaverseBuilder;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.INamespace;
import org.pentaho.metaverse.api.MetaverseException;
import org.pentaho.metaverse.api.Namespace;
import org.pentaho.metaverse.api.analyzer.kettle.KettleAnalyzerUtil;
import org.pentaho.metaverse.api.model.IExecutionData;
import org.pentaho.metaverse.api.model.IExecutionProfile;
import org.pentaho.metaverse.api.model.LineageHolder;
import org.pentaho.metaverse.impl.MetaverseCompletionService;
import org.pentaho.metaverse.impl.model.ExecutionData;
import org.pentaho.metaverse.impl.model.ExecutionProfile;
import org.pentaho.metaverse.impl.model.ParamInfo;
import org.pentaho.metaverse.messages.Messages;
import org.pentaho.metaverse.util.MetaverseUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtensionPoint(description="Transformation Runtime metadata extractor", extensionPointId="TransformationStartThreads", id="transRuntimeMetaverse")
public class TransformationRuntimeExtensionPoint
extends BaseRuntimeExtensionPoint
implements TransListener {
    private static final Logger log = LoggerFactory.getLogger(TransformationRuntimeExtensionPoint.class);
    private IDocumentAnalyzer documentAnalyzer;

    public void callExtensionPoint(LogChannelInterface logChannelInterface, Object o) throws KettleException {
        if (o != null && o instanceof Trans) {
            Trans trans = (Trans)o;
            if (trans.isPreview() || !this.isRuntimeEnabled()) {
                return;
            }
            trans.addTransListener((TransListener)this);
        }
    }

    public void transStarted(Trans trans) throws KettleException {
        if (trans == null) {
            return;
        }
        ExecutionProfile executionProfile = new ExecutionProfile();
        this.populateExecutionProfile(executionProfile, trans);
        IMetaverseBuilder builder = TransLineageHolderMap.getInstance().getMetaverseBuilder(trans);
        if (this.documentAnalyzer != null) {
            String normalizedPath;
            this.documentAnalyzer.setMetaverseBuilder(builder);
            String clientName = executionProfile.getExecutionEngine().getName();
            Namespace namespace = new Namespace(clientName);
            IMetaverseNode designNode = builder.getMetaverseObjectFactory().createNodeObject(clientName, clientName, "Locator");
            builder.addNode(designNode);
            TransMeta transMeta = trans.getTransMeta();
            String id = TransExtensionPointUtil.getFilename(transMeta);
            IDocument metaverseDocument = builder.getMetaverseObjectFactory().createDocumentObject();
            metaverseDocument.setNamespace((INamespace)namespace);
            metaverseDocument.setContent((Object)transMeta);
            metaverseDocument.setStringID(id);
            metaverseDocument.setName(transMeta.getName());
            metaverseDocument.setExtension("ktr");
            metaverseDocument.setMimeType(URLConnection.getFileNameMap().getContentTypeFor("trans.ktr"));
            metaverseDocument.setContext((IAnalysisContext)new AnalysisContext("runtime"));
            try {
                normalizedPath = KettleAnalyzerUtil.normalizeFilePath((String)id);
            }
            catch (MetaverseException e) {
                normalizedPath = id;
            }
            metaverseDocument.setProperty("name", (Object)trans.getName());
            metaverseDocument.setProperty("path", (Object)normalizedPath);
            metaverseDocument.setProperty("namespace", (Object)namespace.getNamespaceId());
            Runnable analyzerRunner = MetaverseUtil.getAnalyzerRunner(this.documentAnalyzer, metaverseDocument);
            MetaverseCompletionService.getInstance().submit(analyzerRunner, id);
        }
        LineageHolder holder = TransLineageHolderMap.getInstance().getLineageHolder(trans);
        holder.setExecutionProfile((IExecutionProfile)executionProfile);
        holder.setMetaverseBuilder(builder);
    }

    protected void populateExecutionProfile(IExecutionProfile executionProfile, Trans trans) {
        TransMeta transMeta = trans.getTransMeta();
        String filename = trans.getFilename();
        if (filename == null) {
            filename = transMeta.getPathAndName();
        }
        String filePath = null;
        if (trans.getRepository() == null) {
            try {
                filePath = KettleAnalyzerUtil.normalizeFilePath((String)filename);
            }
            catch (Exception e) {
                log.warn("Couldn't normalize file path: " + filename, (Throwable)e);
                filePath = filename;
            }
        } else {
            filePath = filename;
        }
        executionProfile.setPath(filePath);
        executionProfile.setName(transMeta.getName());
        executionProfile.setType("Transformation");
        executionProfile.setDescription(transMeta.getDescription());
        executionProfile.setExecutionEngine(TransformationRuntimeExtensionPoint.getExecutionEngineInfo());
        IExecutionData executionData = executionProfile.getExecutionData();
        executionData.setStartTime((Date)new Timestamp(new Date().getTime()));
        KettleClientEnvironment.ClientType clientType = KettleClientEnvironment.getInstance().getClient();
        executionData.setClientExecutor(clientType == null ? "DI Server" : clientType.name());
        executionData.setExecutorUser(trans.getExecutingUser());
        executionData.setExecutorServer(trans.getExecutingServer());
        List vars = transMeta.getUsedVariables();
        Map variableMap = executionData.getVariables();
        for (String var : vars) {
            String value = trans.getVariable(var);
            if (var == null || value == null) continue;
            variableMap.put(var, value);
        }
        String[] params = trans.listParameters();
        List paramList = executionData.getParameters();
        if (params != null) {
            for (String param : params) {
                try {
                    ParamInfo paramInfo = new ParamInfo(param, trans.getParameterDescription(param), trans.getParameterDefault(param));
                    paramList.add(paramInfo);
                }
                catch (UnknownParamException e) {
                    log.error("Couldn't find transformation parameter: " + param, (Throwable)e);
                }
            }
        }
        String[] args = trans.getArguments();
        List argList = executionData.getArguments();
        if (args != null) {
            argList.addAll(Arrays.asList(args));
        }
    }

    public void transActive(Trans trans) {
    }

    public void transFinished(final Trans trans) throws KettleException {
        if (trans == null) {
            return;
        }
        if (trans.isPreview()) {
            return;
        }
        Thread lineageWorker = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    IExecutionProfile executionProfile;
                    LineageHolder holder = TransLineageHolderMap.getInstance().getLineageHolder(trans);
                    Future lineageTask = holder.getLineageTask();
                    if (lineageTask != null) {
                        try {
                            lineageTask.get();
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (ExecutionException e) {
                            log.warn(Messages.getString("ERROR.CouldNotWriteLineageGraph", trans.getName(), Const.NVL((String)e.getLocalizedMessage(), (String)"Unspecified")));
                            log.debug(Messages.getString("ERROR.ErrorDuringAnalysisStackTrace"), (Throwable)e);
                        }
                    }
                    if ((executionProfile = holder.getExecutionProfile()) == null) {
                        executionProfile = new ExecutionProfile();
                        TransformationRuntimeExtensionPoint.this.populateExecutionProfile(executionProfile, trans);
                    }
                    ExecutionData executionData = (ExecutionData)executionProfile.getExecutionData();
                    Result result = trans.getResult();
                    if (result != null) {
                        executionData.setFailureCount(result.getNrErrors());
                    }
                    try {
                        if (TransformationRuntimeExtensionPoint.this.lineageWriter != null && !"none".equals(TransformationRuntimeExtensionPoint.this.lineageWriter.getOutputStrategy())) {
                            if ("latest".equals(TransformationRuntimeExtensionPoint.this.lineageWriter.getOutputStrategy())) {
                                TransformationRuntimeExtensionPoint.this.lineageWriter.cleanOutput(holder);
                            }
                            TransformationRuntimeExtensionPoint.this.lineageWriter.outputExecutionProfile(holder);
                        }
                    }
                    catch (IOException e) {
                        log.warn(Messages.getString("ERROR.CouldNotWriteExecutionProfile", trans.getName(), Const.NVL((String)e.getLocalizedMessage(), (String)"Unspecified")));
                        log.debug(Messages.getString("ERROR.ErrorDuringAnalysisStackTrace"), (Throwable)e);
                    }
                    try {
                        Job parentJob = trans.getParentJob();
                        Trans parentTrans = trans.getParentTrans();
                        if (parentJob == null && parentTrans == null) {
                            TransformationRuntimeExtensionPoint.this.addRuntimeLineageInfo(holder);
                            if (TransformationRuntimeExtensionPoint.this.lineageWriter != null && !"none".equals(TransformationRuntimeExtensionPoint.this.lineageWriter.getOutputStrategy())) {
                                TransformationRuntimeExtensionPoint.this.lineageWriter.outputLineageGraph(holder);
                            }
                        }
                    }
                    catch (IOException e) {
                        log.warn(Messages.getString("ERROR.CouldNotWriteExecutionProfile", trans.getName(), Const.NVL((String)e.getLocalizedMessage(), (String)"Unspecified")));
                        log.debug(Messages.getString("ERROR.ErrorDuringAnalysisStackTrace"), (Throwable)e);
                    }
                }
                catch (Throwable t) {
                    log.warn(Messages.getString("ERROR.ErrorDuringAnalysis", trans.getName(), Const.NVL((String)t.getLocalizedMessage(), (String)"Unspecified")));
                    log.debug(Messages.getString("ERROR.ErrorDuringAnalysisStackTrace"), t);
                }
            }
        });
        lineageWorker.start();
    }

    public void setDocumentAnalyzer(IDocumentAnalyzer analyzer) {
        this.documentAnalyzer = analyzer;
    }

    public IDocumentAnalyzer getDocumentAnalyzer() {
        return this.documentAnalyzer;
    }
}

