/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.graph;

import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Features;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.GraphQuery;
import com.tinkerpop.blueprints.KeyIndexableGraph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.wrappers.id.IdGraph;

public class SynchronizedGraph
implements Graph {
    protected final IdGraph<KeyIndexableGraph> graph;

    public SynchronizedGraph(IdGraph<KeyIndexableGraph> graph) {
        this.graph = graph;
    }

    public Features getFeatures() {
        return this.graph.getFeatures();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vertex addVertex(Object id) {
        IdGraph<KeyIndexableGraph> idGraph = this.graph;
        synchronized (idGraph) {
            Vertex vertex;
            if (id == null) {
                vertex = this.graph.addVertex(id);
            } else {
                vertex = this.getVertex(id);
                if (vertex == null) {
                    vertex = this.graph.addVertex(id);
                }
            }
            return vertex;
        }
    }

    public Vertex getVertex(Object id) {
        return this.graph.getVertex(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVertex(Vertex vertex) {
        IdGraph<KeyIndexableGraph> idGraph = this.graph;
        synchronized (idGraph) {
            this.graph.removeVertex(vertex);
        }
    }

    public Iterable<Vertex> getVertices() {
        return this.graph.getVertices();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<Vertex> getVertices(String key, Object value) {
        IdGraph<KeyIndexableGraph> idGraph = this.graph;
        synchronized (idGraph) {
            return this.graph.getVertices(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Edge addEdge(Object id, Vertex outVertex, Vertex inVertex, String label) {
        IdGraph<KeyIndexableGraph> idGraph = this.graph;
        synchronized (idGraph) {
            Edge edge;
            if (id == null) {
                edge = this.graph.addEdge(id, outVertex, inVertex, label);
            } else {
                edge = this.getEdge(id);
                if (edge == null) {
                    edge = this.graph.addEdge(id, outVertex, inVertex, label);
                }
            }
            return edge;
        }
    }

    public Edge getEdge(Object id) {
        return this.graph.getEdge(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEdge(Edge edge) {
        IdGraph<KeyIndexableGraph> idGraph = this.graph;
        synchronized (idGraph) {
            this.graph.removeEdge(edge);
        }
    }

    public Iterable<Edge> getEdges() {
        return this.graph.getEdges();
    }

    public Iterable<Edge> getEdges(String key, Object value) {
        return this.graph.getEdges(key, value);
    }

    public GraphQuery query() {
        return this.graph.query();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        IdGraph<KeyIndexableGraph> idGraph = this.graph;
        synchronized (idGraph) {
            this.graph.shutdown();
        }
    }
}

